/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.Metrics;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class ChangeStreamMetrics
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 8187140831756972470L;
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_RECORD_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_record_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_RECORD_SPLIT_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_record_split_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_RECORD_MERGE_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_record_merge_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_START_RECORD_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_start_record_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_END_RECORD_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_end_record_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter PARTITION_EVENT_RECORD_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"partition_event_record_count");
    public static final @UnknownKeyFor @NonNull @Initialized Distribution PARTITION_CREATED_TO_SCHEDULED_MS = Metrics.distribution(ChangeStreamMetrics.class, (String)"partition_created_to_scheduled_ms");
    public static final @UnknownKeyFor @NonNull @Initialized Distribution PARTITION_SCHEDULED_TO_RUNNING_MS = Metrics.distribution(ChangeStreamMetrics.class, (String)"partition_scheduled_to_running_ms");
    public static final @UnknownKeyFor @NonNull @Initialized Counter ACTIVE_PARTITION_READ_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"active_partition_read_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter DATA_RECORD_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"data_record_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter QUERY_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"query_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter DATA_RECORD_COMMITTED_TO_EMITTED_0MS_TO_1000MS_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"data_record_committed_to_emitted_0ms_to_1000ms_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter DATA_RECORD_COMMITTED_TO_EMITTED_1000MS_TO_3000MS_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"data_record_committed_to_emitted_1000ms_to_3000ms_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter DATA_RECORD_COMMITTED_TO_EMITTED_3000MS_TO_INF_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"data_record_committed_to_emitted_3000ms_to_inf_count");
    public static final @UnknownKeyFor @NonNull @Initialized Counter HEARTBEAT_RECORD_COUNT = Metrics.counter(ChangeStreamMetrics.class, (String)"heartbeat_record_count");
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized MetricName> enabledMetrics;

    public ChangeStreamMetrics() {
        this.enabledMetrics = new HashSet<MetricName>();
        this.enabledMetrics.add(DATA_RECORD_COUNT.getName());
        this.enabledMetrics.add(ACTIVE_PARTITION_READ_COUNT.getName());
        this.enabledMetrics.add(QUERY_COUNT.getName());
        this.enabledMetrics.add(DATA_RECORD_COMMITTED_TO_EMITTED_0MS_TO_1000MS_COUNT.getName());
        this.enabledMetrics.add(DATA_RECORD_COMMITTED_TO_EMITTED_1000MS_TO_3000MS_COUNT.getName());
        this.enabledMetrics.add(DATA_RECORD_COMMITTED_TO_EMITTED_3000MS_TO_INF_COUNT.getName());
    }

    public ChangeStreamMetrics(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized MetricName> enabledMetrics) {
        this.enabledMetrics = enabledMetrics;
    }

    public void incPartitionRecordCount() {
        this.inc(PARTITION_RECORD_COUNT);
    }

    public void incPartitionRecordSplitCount() {
        this.inc(PARTITION_RECORD_SPLIT_COUNT);
    }

    public void incPartitionRecordMergeCount() {
        this.inc(PARTITION_RECORD_MERGE_COUNT);
    }

    public void incPartitionStartRecordCount() {
        this.inc(PARTITION_START_RECORD_COUNT);
    }

    public void incPartitionEndRecordCount() {
        this.inc(PARTITION_END_RECORD_COUNT);
    }

    public void incPartitionEventRecordCount() {
        this.inc(PARTITION_EVENT_RECORD_COUNT);
    }

    public void updatePartitionCreatedToScheduled(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        this.update(PARTITION_CREATED_TO_SCHEDULED_MS, duration.getMillis());
    }

    public void updatePartitionScheduledToRunning(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        this.update(PARTITION_SCHEDULED_TO_RUNNING_MS, duration.getMillis());
    }

    public void incActivePartitionReadCounter() {
        this.inc(ACTIVE_PARTITION_READ_COUNT);
    }

    public void decActivePartitionReadCounter() {
        this.dec(ACTIVE_PARTITION_READ_COUNT);
    }

    public void incDataRecordCounter() {
        this.inc(DATA_RECORD_COUNT);
    }

    public void incQueryCounter() {
        this.inc(QUERY_COUNT);
    }

    public void incHeartbeatRecordCount() {
        this.inc(HEARTBEAT_RECORD_COUNT);
    }

    private void inc(@UnknownKeyFor @NonNull @Initialized Counter counter) {
        if (this.enabledMetrics.contains(counter.getName())) {
            counter.inc();
        }
    }

    private void dec(@UnknownKeyFor @NonNull @Initialized Counter counter) {
        if (this.enabledMetrics.contains(counter.getName())) {
            counter.dec();
        }
    }

    private void update(@UnknownKeyFor @NonNull @Initialized Distribution distribution, @UnknownKeyFor @NonNull @Initialized long value) {
        if (this.enabledMetrics.contains(distribution.getName())) {
            distribution.update(value);
        }
    }

    public void updateDataRecordCommittedToEmitted(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        long millis = duration.getMillis();
        if (millis < 1000L) {
            this.inc(DATA_RECORD_COMMITTED_TO_EMITTED_0MS_TO_1000MS_COUNT);
        } else if (millis < 3000L) {
            this.inc(DATA_RECORD_COMMITTED_TO_EMITTED_1000MS_TO_3000MS_COUNT);
        } else {
            this.inc(DATA_RECORD_COMMITTED_TO_EMITTED_3000MS_TO_INF_COUNT);
        }
    }
}

