/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ServerCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.AltsChannelCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.HandshakerServiceChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.InternalCheckGcpEnvironment;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.internal.AltsProtocolNegotiator;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal.ObjectPool;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal.SharedResourcePool;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.InternalNettyServerCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.InternalProtocolNegotiator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerCredentials {
    private static final Logger logger = Logger.getLogger(AltsServerCredentials.class.getName());

    private AltsServerCredentials() {
    }

    public static ServerCredentials create() {
        return AltsServerCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
    public static final class Builder {
        private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
        private boolean enableUntrustedAlts;

        public Builder enableUntrustedAltsForTesting() {
            this.enableUntrustedAlts = true;
            return this;
        }

        public Builder setHandshakerAddressForTesting(String handshakerAddress) {
            this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
            return this;
        }

        public ServerCredentials build() {
            return InternalNettyServerCredentials.create(this.buildProtocolNegotiator());
        }

        InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            if (!InternalCheckGcpEnvironment.isOnGcp()) {
                if (this.enableUntrustedAlts) {
                    logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
                } else {
                    Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                    return new AltsChannelCredentials.FailingProtocolNegotiator(status);
                }
            }
            return AltsProtocolNegotiator.serverAltsProtocolNegotiator(this.handshakerChannelPool);
        }
    }
}

