/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.translation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.Timer;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public final class PipelineTranslatorUtils {
    private PipelineTranslatorUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> createOutputMap(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> localOutputs) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        int outputIndex = 0;
        for (String tag : Sets.newTreeSet(localOutputs)) {
            builder.put((Object)tag, (Object)outputIndex);
            ++outputIndex;
        }
        return builder.build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> instantiateCoder(@UnknownKeyFor @NonNull @Initialized String collectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return WireCoders.instantiateRunnerWireCoder(collectionNode, components);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate Coder", e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized WindowingStrategy getWindowingStrategy(@UnknownKeyFor @NonNull @Initialized String pCollectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        RunnerApi.WindowingStrategy windowingStrategyProto = components.getWindowingStrategiesOrThrow(components.getPcollectionsOrThrow(pCollectionId).getWindowingStrategyId());
        try {
            return WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)components));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Unable to hydrate windowing strategy %s for %s.", windowingStrategyProto, pCollectionId), e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasUnboundedPCollections(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        Preconditions.checkNotNull((Object)pipeline);
        Collection pCollecctions = pipeline.getComponents().getPcollectionsMap().values();
        return pCollecctions.stream().anyMatch(pc -> pc.getIsBounded() == RunnerApi.IsBounded.Enum.UNBOUNDED);
    }

    public static void fireEligibleTimers(@UnknownKeyFor @NonNull @Initialized InMemoryTimerInternals timerInternals, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized Timer>> timerReceivers, @UnknownKeyFor @NonNull @Initialized Object currentTimerKey) {
        boolean hasFired;
        do {
            TimerInternals.TimerData timer;
            hasFired = false;
            while ((timer = timerInternals.removeNextEventTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerReceivers, currentTimerKey);
            }
            while ((timer = timerInternals.removeNextProcessingTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerReceivers, currentTimerKey);
            }
            while ((timer = timerInternals.removeNextSynchronizedProcessingTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerReceivers, currentTimerKey);
            }
        } while (hasFired);
    }

    private static void fireTimer(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized Timer>> timerReceivers, @UnknownKeyFor @NonNull @Initialized Object currentTimerKey) {
        StateNamespace namespace = timer.getNamespace();
        Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
        BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
        Instant timestamp = timer.getTimestamp();
        Instant outputTimestamp = timer.getOutputTimestamp();
        Timer timerValue = Timer.of((Object)currentTimerKey, (String)timer.getTimerId(), Collections.singletonList(window), (Instant)timestamp, (Instant)outputTimestamp, (PaneInfo)PaneInfo.NO_FIRING);
        KV<String, String> transformAndTimerId = TimerReceiverFactory.decodeTimerDataTimerId(timer.getTimerFamilyId());
        FnDataReceiver<Timer> fnTimerReceiver = timerReceivers.get(transformAndTimerId);
        Preconditions.checkNotNull(fnTimerReceiver, (String)"No FnDataReceiver found for %s", transformAndTimerId);
        try {
            fnTimerReceiver.accept((Object)timerValue);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to process timer: %s", timerValue));
        }
    }

    public static <T> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WindowedValues.WindowedValueCoder<T> getWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized String pCollectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        WindowedValues.WindowedValueCoder coder;
        RunnerApi.PCollection pCollection = components.getPcollectionsOrThrow(pCollectionId);
        PipelineNode.PCollectionNode pCollectionNode = PipelineNode.pCollection((String)pCollectionId, (RunnerApi.PCollection)pCollection);
        try {
            coder = (WindowedValues.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder(pCollectionNode, components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return coder;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getInputId(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode) {
        return (String)Iterables.getOnlyElement(transformNode.getTransform().getInputsMap().values());
    }

    public static @UnknownKeyFor @NonNull @Initialized String getOutputId(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode) {
        return (String)Iterables.getOnlyElement(transformNode.getTransform().getOutputsMap().values());
    }

    public static @UnknownKeyFor @NonNull @Initialized String getExecutableStageIntermediateId(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode) {
        return transformNode.getId();
    }
}

