/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.internal.core.graph.EditDistance;
import com.datastax.dse.driver.internal.core.graph.binary.AbstractSimpleGraphBinaryCustomSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryUtils;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public class EditDistanceSerializer
extends AbstractSimpleGraphBinaryCustomSerializer<EditDistance> {
    public String getTypeName() {
        return "driver.dse.search.EditDistance";
    }

    @Override
    protected EditDistance readCustomValue(int valueLength, Buffer buffer, GraphBinaryReader context) throws IOException {
        int distance = (Integer)context.readValue(buffer, Integer.class, false);
        String query = (String)context.readValue(buffer, String.class, false);
        this.checkValueSize(GraphBinaryUtils.sizeOfEditDistance(query), valueLength);
        return new EditDistance(query, distance);
    }

    @Override
    protected void writeCustomValue(EditDistance value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue((Object)GraphBinaryUtils.sizeOfEditDistance(value.query), buffer, false);
        context.writeValue((Object)value.distance, buffer, false);
        context.writeValue((Object)value.query, buffer, false);
    }
}

