/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class EventLog
implements Log {
    private PrintWriter writer_;
    private boolean writerIsPrivate_ = false;

    public EventLog() {
        this.writer_ = new PrintWriter(System.out, true);
    }

    public EventLog(String pathname) throws IOException {
        if (pathname == null) {
            throw new NullPointerException("pathname");
        }
        File file = new File(pathname);
        FileOutputStream os = new FileOutputStream(pathname, file.exists());
        this.writer_ = new PrintWriter(os, true);
        this.writerIsPrivate_ = true;
    }

    public EventLog(OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.writer_ = new PrintWriter(stream, true);
    }

    public EventLog(PrintWriter out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        this.writer_ = out;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.writerIsPrivate_ && this.writer_ != null) {
                this.writer_.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void log(String msg) {
        this.log(msg, null);
    }

    @Override
    public void log(String msg, Throwable exception) {
        StringBuffer buffer = new StringBuffer(new Date().toString());
        buffer.append(" ");
        buffer.append(msg);
        this.writer_.println(buffer);
        if (exception != null) {
            exception.printStackTrace(this.writer_);
        }
        this.writer_.flush();
    }
}

