/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400JDBCConnectionHandle;
import com.ibm.as400.access.AS400JDBCManagedConnectionPoolDataSource;
import com.ibm.as400.access.AS400JDBCManagedDataSource;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JDConnectionPoolKey;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import java.util.TreeSet;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

final class JDConnectionPoolManager
implements ConnectionEventListener {
    static boolean DEBUG = false;
    static boolean GATHER_STATS = false;
    static boolean TESTING_ERROR_EVENTS = false;
    private final TreeSet activeConnections_ = new TreeSet(new JDAgeComparator());
    private final HashSet activeConnectionsInError_ = new HashSet();
    private final HashMap[] availableConnections_ = new HashMap[]{new HashMap(100), new HashMap(100), null};
    private final LinkedHashSet[] availableConnectionsIdledSequence_ = new LinkedHashSet[]{new LinkedHashSet(), new LinkedHashSet(), null};
    private final ArrayList condemnedConnections_ = new ArrayList(100);
    private final HashSet invalidatedKeys_ = new HashSet();
    private AS400JDBCManagedDataSource logger_;
    private AS400JDBCManagedConnectionPoolDataSource cpds_;
    private int initialPoolSize_;
    private int minPoolSize_;
    private int maxPoolSize_;
    private long maxIdleTime_;
    private long propertyCycle_;
    private long maxLifetime_;
    private long maintainerInterval_;
    private long reaperInterval_;
    private long scavengerInterval_;
    private int condemnedListLengthThreshold_;
    private long minSwapInterval_;
    private int numConnectionsCreated_;
    private int numConnectionsDestroyed_;
    private final Object connectionsCreatedLock_ = new Object();
    private final Object connectionsDestroyedLock_ = new Object();
    private boolean poolSizeLimited_;
    private boolean enforceMaxPoolSize_;
    private boolean connectionLifetimeLimited_;
    private boolean pretestConnections_;
    private boolean reuseConnections_;
    private int minDefaultStackSize_;
    private JDPoolMaintainer poolMaintainer_;
    private Thread maintainerDaemon_;
    private JDPoolReaper poolReaper_;
    private Thread reaperDaemon_;
    private JDPoolScavenger poolScavenger_;
    private Thread scavengerDaemon_;
    private boolean keepDaemonsAlive_ = true;
    private final Object maintainerSnoozeLock_ = new Object();
    private final Object maintainerSleepLock_ = new Object();
    private final Object reaperSleepLock_ = new Object();
    private final Object scavengerSleepLock_ = new Object();
    private boolean poolPaused_ = false;
    private final Object poolPauseLock_ = new Object();
    private boolean fillingPool_;
    private boolean poolClosed_;
    private boolean poolClosedCompletely_;
    private boolean needMoreConnections_;
    private long timeLastSwapAttempted_ = 0L;
    private boolean swapInProgress_;
    private final Object swapLock_ = new Object();
    private boolean healthCheckInProgress_;
    private final Object healthCheckLock_ = new Object();
    private static final int FOREGROUND = 0;
    private static final int BACKGROUND = 1;
    private static final int HOLD = 2;
    private static final int SYNC_NONE = 10;
    private static final int SYNC_ALL = 11;
    private int maintainerDaemonCycles_ = 0;
    private int reaperDaemonCycles_ = 0;
    private int scavengerDaemonCycles_ = 0;
    private int numGetConnectionCalls_received_ = 0;
    private int numGetConnectionCalls_succeeded_ = 0;
    private int numGetConnectionCalls_returnedNull_ = 0;
    private int numGetConnectionCalls_whileClosing_ = 0;
    private int connectionsReturnedToPool_ = 0;
    private int connectionErrorsOccurred_ = 0;
    private int staleConnectionsIdentified_ = 0;
    private int expiredConnectionsIdentifiedByReaper_ = 0;
    private int expiredConnectionsIdentifiedWhenReturned_ = 0;
    private int surplusPrecreatedConnectionsRemoved_ = 0;
    private int survivingConnectionsRemoved_ = 0;
    private int condemnedConnectionsRemoved_ = 0;
    private int swapsAttempted_ = 0;
    private int swapsSucceeded_ = 0;
    private int swapsFailed_ = 0;
    private int swapsFailed_notWorthIt_ = 0;
    private int swapsSucceeded_foreground_ = 0;
    private int swapsSucceeded_background_ = 0;
    private int swapsFailed_foreground_ = 0;
    private int swapsFailed_background_ = 0;
    private int swapsFailed_premature_ = 0;
    private int swapsFailed_foreground_inProgress_ = 0;
    private int swapsFailed_background_inProgress_ = 0;
    private int swapsFailed_foreground_daemonAwake_ = 0;

    JDConnectionPoolManager(AS400JDBCManagedDataSource logger, AS400JDBCManagedConnectionPoolDataSource cpds) {
        this.logger_ = logger;
        this.cpds_ = cpds;
        this.initialPoolSize_ = this.cpds_.getInitialPoolSize();
        this.minPoolSize_ = this.cpds_.getMinPoolSize();
        this.maxPoolSize_ = this.cpds_.getMaxPoolSize();
        this.enforceMaxPoolSize_ = this.cpds_.isEnforceMaxPoolSize();
        this.pretestConnections_ = this.cpds_.isPretestConnections();
        this.reuseConnections_ = this.cpds_.isReuseConnections();
        this.maxIdleTime_ = this.cpds_.getMaxIdleTime() * 1000;
        this.maxLifetime_ = this.cpds_.getMaxLifetime() * 1000;
        this.propertyCycle_ = this.cpds_.getPropertyCycle() * 1000;
        if (DEBUG) {
            this.logInformation("initialPoolSize_:  " + this.initialPoolSize_);
            this.logInformation("minPoolSize_:  " + this.minPoolSize_);
            this.logInformation("maxPoolSize_:  " + this.maxPoolSize_);
            this.logInformation("enforceMaxPoolSize_:  " + this.enforceMaxPoolSize_);
            this.logInformation("pretestConnections_:  " + this.pretestConnections_);
            this.logInformation("reuseConnections_:  " + this.reuseConnections_);
            this.logInformation("maxIdleTime_:  " + this.maxIdleTime_ + " msecs");
            this.logInformation("maxLifetime_:  " + this.maxLifetime_ + " msecs");
            this.logInformation("propertyCycle_:  " + this.propertyCycle_ + " msecs");
            this.logInformation("server name: |" + this.cpds_.getServerName() + "|");
            this.logInformation("default user: |" + this.cpds_.getUser() + "|");
        }
        if (GATHER_STATS) {
            System.out.println("initialPoolSize_:  " + this.initialPoolSize_);
            System.out.println("minPoolSize_:  " + this.minPoolSize_);
            System.out.println("maxPoolSize_:  " + this.maxPoolSize_);
            System.out.println("enforceMaxPoolSize_:  " + this.enforceMaxPoolSize_);
            System.out.println("pretestConnections_:  " + this.pretestConnections_);
            System.out.println("reuseConnections_:  " + this.reuseConnections_);
            System.out.println("maxIdleTime_:  " + this.maxIdleTime_ + " msecs");
            System.out.println("maxLifetime_:  " + this.maxLifetime_ + " msecs");
            System.out.println("propertyCycle_:  " + this.propertyCycle_ + " msecs");
            System.out.println("server name: |" + this.cpds_.getServerName() + "|");
            System.out.println("default user: |" + this.cpds_.getUser() + "|");
        }
        this.maintainerInterval_ = this.propertyCycle_;
        this.reaperInterval_ = 1800000L;
        this.scavengerInterval_ = this.maintainerInterval_ * 20L;
        if (this.maxLifetime_ == 0L) {
            this.connectionLifetimeLimited_ = false;
        } else {
            this.connectionLifetimeLimited_ = true;
            this.reaperInterval_ = this.maxLifetime_ / 3L;
        }
        this.minSwapInterval_ = 50L;
        if (this.maxPoolSize_ == 0) {
            this.poolSizeLimited_ = false;
        } else {
            this.poolSizeLimited_ = true;
            if (this.maxPoolSize_ < this.minPoolSize_) {
                if (JDTrace.isTraceOn()) {
                    this.logWarning("minPoolSize (" + this.minPoolSize_ + ") exceeds maxPoolSize (" + this.maxPoolSize_ + ")");
                }
                this.maxPoolSize_ = this.minPoolSize_ + 5;
            }
            if (this.initialPoolSize_ > this.maxPoolSize_) {
                if (JDTrace.isTraceOn()) {
                    this.logWarning("initialPoolSize (" + this.initialPoolSize_ + ") exceeds maxPoolSize (" + this.maxPoolSize_ + ")");
                }
                this.initialPoolSize_ = this.minPoolSize_;
            }
        }
        this.condemnedListLengthThreshold_ = Math.max(3, this.minPoolSize_ / 50);
        int minHalf = this.minPoolSize_ / 2 + this.minPoolSize_ % 2;
        if (minHalf <= 0) {
            minHalf = 1;
        }
        int reuseMinDefaultStackSize = minHalf;
        this.minDefaultStackSize_ = this.reuseConnections_ ? reuseMinDefaultStackSize : 1;
        this.fillPool(Math.max(1, this.initialPoolSize_ / 2), 0);
        this.fillPool(this.initialPoolSize_ / 2, 1);
        this.poolMaintainer_ = new JDPoolMaintainer();
        this.maintainerDaemon_ = new Thread((Runnable)this.poolMaintainer_, "PoolMaintainerDaemon");
        this.maintainerDaemon_.setDaemon(true);
        this.maintainerDaemon_.start();
        this.poolScavenger_ = new JDPoolScavenger();
        this.scavengerDaemon_ = new Thread((Runnable)this.poolScavenger_, "PoolScavengerDaemon");
        this.scavengerDaemon_.setDaemon(true);
        this.scavengerDaemon_.start();
        if (this.connectionLifetimeLimited_) {
            this.poolReaper_ = new JDPoolReaper();
            this.reaperDaemon_ = new Thread((Runnable)this.poolReaper_, "PoolReaperDaemon");
            this.reaperDaemon_.setDaemon(true);
            this.reaperDaemon_.start();
        }
    }

    private final boolean areDaemonsAlive() {
        boolean ok = true;
        if (!this.maintainerDaemon_.isAlive()) {
            ok = false;
            this.logError("The maintainerDaemon_ is no longer running");
        }
        if (!this.scavengerDaemon_.isAlive()) {
            ok = false;
            this.logError("The scavengerDaemon_ is no longer running");
        }
        if (this.connectionLifetimeLimited_ && !this.reaperDaemon_.isAlive()) {
            ok = false;
            this.logError("The reaperDaemon_ is no longer running");
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean checkHealth(boolean logStatistics) {
        Object object;
        boolean ok = true;
        boolean alreadyChecking = this.healthCheckInProgress_;
        if (!alreadyChecking) {
            object = this.healthCheckLock_;
            synchronized (object) {
                if (this.healthCheckInProgress_) {
                    alreadyChecking = true;
                } else {
                    this.healthCheckInProgress_ = true;
                }
            }
        }
        if (alreadyChecking) {
            if (DEBUG) {
                this.logDiagnostic("checkHealth is already in progress");
            }
            return true;
        }
        try {
            this.pausePool();
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.swapInProgress_) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.swapInProgress_ && DEBUG) {
                this.logError("checkHealth(): swapInProgress_ flag is still on after 50 msec wait.");
            }
            object = this.activeConnections_;
            synchronized (object) {
                HashMap hashMap = this.availableConnections_[0];
                synchronized (hashMap) {
                    HashMap hashMap2 = this.availableConnections_[1];
                    synchronized (hashMap2) {
                        ArrayList arrayList = this.condemnedConnections_;
                        synchronized (arrayList) {
                            Object object2 = this.connectionsCreatedLock_;
                            synchronized (object2) {
                                Object object3 = this.connectionsDestroyedLock_;
                                synchronized (object3) {
                                    int totalAvailConnCount = 0;
                                    for (int side = 0; side <= 1; ++side) {
                                        int availConnCount = 0;
                                        JDConnectionPoolKey[] poolKeys = this.availableConnections_[side].keySet().toArray(new JDConnectionPoolKey[0]);
                                        for (int i = 0; i < poolKeys.length; ++i) {
                                            Stack connStack = (Stack)this.availableConnections_[side].get(poolKeys[i]);
                                            if (connStack == null) continue;
                                            availConnCount += connStack.size();
                                        }
                                        totalAvailConnCount += availConnCount;
                                        if (this.availableConnectionsIdledSequence_[side].size() != availConnCount) {
                                            ok = false;
                                            this.logError("Connection count mismatch for side " + side + ": #avail==" + availConnCount + " ; #idled==" + this.availableConnectionsIdledSequence_[side].size());
                                        }
                                        if (this.poolClosedCompletely_ && availConnCount != 0) {
                                            ok = false;
                                            this.logError("Available connections in list " + side + " ==" + availConnCount + " after pool closed");
                                        }
                                        if (!DEBUG && !GATHER_STATS) continue;
                                        Iterator idledIter = this.availableConnectionsIdledSequence_[side].iterator();
                                        long timeWhenPriorConnIdled = 0L;
                                        int i = 0;
                                        while (idledIter.hasNext()) {
                                            AS400JDBCPooledConnection conn = (AS400JDBCPooledConnection)idledIter.next();
                                            if (conn.timeWhenPoolStatusLastModified_ < timeWhenPriorConnIdled) {
                                                ok = false;
                                                this.logError("Idled connection sequence for side " + side + " is not arranged in order of idled-time");
                                            }
                                            timeWhenPriorConnIdled = conn.timeWhenPoolStatusLastModified_;
                                            ++i;
                                        }
                                    }
                                    int totalConnCount = totalAvailConnCount + this.activeConnections_.size() + this.condemnedConnections_.size();
                                    if (totalConnCount != this.numConnectionsCreated_ - this.numConnectionsDestroyed_) {
                                        this.logWarning("totalConnCount==" + totalConnCount + "; numConnectionsCreated_==" + this.numConnectionsCreated_ + "; numConnectionsDestroyed_==" + this.numConnectionsDestroyed_ + " (difference: " + (this.numConnectionsCreated_ - this.numConnectionsDestroyed_) + ")");
                                    }
                                    if (this.poolClosedCompletely_) {
                                        if (this.availableConnections_[0].size() != 0) {
                                            ok = false;
                                            this.logError("Available connection list (foreground) is not empty after pool closed");
                                        }
                                        if (this.availableConnections_[1].size() != 0) {
                                            ok = false;
                                            this.logError("Available connection list (background) is not empty after pool closed");
                                        }
                                        if (this.activeConnections_.size() != 0) {
                                            ok = false;
                                            this.logError("Active connection count is " + this.activeConnections_.size() + " after pool closed");
                                        }
                                        if (this.activeConnectionsInError_.size() != 0) {
                                            ok = false;
                                            this.logError("Active(error) connection count is " + this.activeConnectionsInError_.size() + " after pool closed");
                                        }
                                        if (this.condemnedConnections_.size() != 0) {
                                            ok = false;
                                            this.logError("Condemned connection count is " + this.condemnedConnections_.size() + " after pool closed");
                                        }
                                        if (this.numConnectionsCreated_ != this.numConnectionsDestroyed_) {
                                            ok = false;
                                            this.logError("numConnectionsCreated_ == " + this.numConnectionsCreated_ + ", numConnectionsDestroyed_ == " + this.numConnectionsDestroyed_ + " after pool closed");
                                        }
                                    }
                                    if (DEBUG) {
                                        this.logInformation("Total available connections==" + totalAvailConnCount + "\n activeConnections_.size()==" + this.activeConnections_.size() + "\n condemnedConnections_.size()==" + this.condemnedConnections_.size());
                                    }
                                    if (DEBUG || GATHER_STATS) {
                                        Iterator activeIter = this.activeConnections_.iterator();
                                        long timeWhenPriorConnWasCreated = 0L;
                                        int i = 0;
                                        while (activeIter.hasNext()) {
                                            AS400JDBCPooledConnection conn = (AS400JDBCPooledConnection)activeIter.next();
                                            if (conn.timeWhenCreated_ < timeWhenPriorConnWasCreated) {
                                                ok = false;
                                                this.logError("Active connection sequence is not arranged in order of creation: conn.timeWhenCreated_==" + conn.timeWhenCreated_ + ", timeWhenPriorConnWasCreated==" + timeWhenPriorConnWasCreated);
                                            }
                                            timeWhenPriorConnWasCreated = conn.timeWhenCreated_;
                                            ++i;
                                        }
                                    }
                                    if (DEBUG || logStatistics) {
                                        String msg = "\nswapsAttempted_==" + this.swapsAttempted_ + "\nswapsSucceeded_==" + this.swapsSucceeded_ + "\nswapsFailed_==" + this.swapsFailed_ + "\nswapsFailed_notWorthIt_==" + this.swapsFailed_notWorthIt_ + "\nswapsSucceeded_foreground_==" + this.swapsSucceeded_foreground_ + "\nswapsSucceeded_background_==" + this.swapsSucceeded_background_ + "\nswapsFailed_foreground_==" + this.swapsFailed_foreground_ + "\nswapsFailed_background_==" + this.swapsFailed_background_ + "\nswapsFailed_premature_==" + this.swapsFailed_premature_ + "\nswapsFailed_foreground_inProgress_==" + this.swapsFailed_foreground_inProgress_ + "\nswapsFailed_background_inProgress_==" + this.swapsFailed_background_inProgress_ + "\nswapsFailed_foreground_daemonAwake_==" + this.swapsFailed_foreground_daemonAwake_ + "\nmaintainerDaemonCycles_==" + this.maintainerDaemonCycles_ + "\nreaperDaemonCycles_==" + this.reaperDaemonCycles_ + "\nscavengerDaemonCycles_==" + this.scavengerDaemonCycles_ + "\nnumGetConnectionCalls_received_==" + this.numGetConnectionCalls_received_ + "\nnumGetConnectionCalls_succeeded_==" + this.numGetConnectionCalls_succeeded_ + "\nnumGetConnectionCalls_returnedNull_==" + this.numGetConnectionCalls_returnedNull_ + "\nnumGetConnectionCalls_whileClosing_==" + this.numGetConnectionCalls_whileClosing_ + "\nconnectionsReturnedToPool_==" + this.connectionsReturnedToPool_ + "\nconnectionErrorsOccurred_==" + this.connectionErrorsOccurred_ + "\nstaleConnectionsIdentified_: " + this.staleConnectionsIdentified_ + "\nexpiredConnectionsIdentifiedByReaper_: " + this.expiredConnectionsIdentifiedByReaper_ + "\nexpiredConnectionsIdentifiedWhenReturned_: " + this.expiredConnectionsIdentifiedWhenReturned_ + "\nsurplusPrecreatedConnectionsRemoved_: " + this.surplusPrecreatedConnectionsRemoved_ + "\nsurvivingConnectionsRemoved_: " + this.survivingConnectionsRemoved_ + "\ncondemnedConnectionsRemoved_: " + this.condemnedConnectionsRemoved_ + "\nnumConnectionsCreated_: " + this.numConnectionsCreated_ + "\nnumConnectionsDestroyed_: " + this.numConnectionsDestroyed_;
                                        this.logInformation(msg);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!this.poolPaused_) {
                if (!this.fillingPool_) {
                    ok = false;
                }
                this.logError("The poolPaused_ flag is off during checkHealth()");
            }
            if (this.swapInProgress_) {
                ok = false;
                this.logError("The swapInProgress_ flag is on during checkHealth()");
            }
            if (!this.poolClosed_) {
                if (!this.areDaemonsAlive()) {
                    ok = false;
                }
                if (!this.keepDaemonsAlive_) {
                    ok = false;
                    this.logError("The keepDaemonsAlive_ flag is off when the poolClosed_ flag is off");
                }
                if (this.poolClosedCompletely_) {
                    ok = false;
                    this.logError("The poolClosedCompletely_ flag is on when the poolClosed_ flag is off");
                }
            } else if (this.poolClosedCompletely_) {
                if (this.maintainerDaemon_.isAlive()) {
                    ok = false;
                    this.logError("The maintainerDaemon_ is still running after closePool()");
                }
                if (this.scavengerDaemon_.isAlive()) {
                    ok = false;
                    this.logError("The scavengerDaemon_ is still running after closePool()");
                }
                if (this.reaperDaemon_.isAlive()) {
                    ok = false;
                    this.logError("The reaperDaemon_ is no still running after closePool()");
                }
                if (this.keepDaemonsAlive_) {
                    ok = false;
                    this.logError("The keepDaemonsAlive_ flag is on after pool has been closed");
                }
                if (this.fillingPool_) {
                    ok = false;
                    this.logError("The fillingPool_ flag is on after pool has been closed");
                }
                if (!this.poolClosed_) {
                    ok = false;
                    this.logError("The poolClosed_ flag is off after pool has been closed");
                }
                if (this.needMoreConnections_) {
                    ok = false;
                    this.logError("The needMoreConnections_ flag is on after pool has been closed");
                }
                if (this.poolMaintainer_.isAwake_) {
                    ok = false;
                    this.logError("The pool maintainer daemon's isAwake_ flag is still on after closePool()");
                }
                if (this.poolMaintainer_.snooze_) {
                    ok = false;
                    this.logError("The pool maintainer daemon's snooze_ flag is still on after closePool()");
                }
            }
        }
        finally {
            this.healthCheckInProgress_ = false;
            this.unpausePool();
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closePhysicalConnection(AS400JDBCPooledConnection pooledConnection) {
        try {
            pooledConnection.close();
        }
        catch (Exception e) {
            if (JDTrace.isTraceOn()) {
                this.logException("Exception when closing physical connection", e);
            }
        }
        catch (Throwable e) {
            if (JDTrace.isTraceOn()) {
                this.logError(e.getMessage());
            }
        }
        finally {
            Object e = this.connectionsDestroyedLock_;
            synchronized (e) {
                ++this.numConnectionsDestroyed_;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closePool() {
        Object object;
        block66: {
            block65: {
                block64: {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "closePool()");
                    }
                    if (this.poolClosed_) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "closePool() returning since pool is closed. ");
                        }
                        return;
                    }
                    this.logInformation("Closing connection pool");
                    this.poolClosed_ = true;
                    this.logInformation(ResourceBundleLoader.getText("AS400CP_SHUTDOWN"));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, ResourceBundleLoader.getText("AS400CP_SHUTDOWN"));
                    }
                    try {
                        this.needMoreConnections_ = false;
                        this.poolPaused_ = false;
                        this.keepDaemonsAlive_ = false;
                        this.poolMaintainer_.snooze_ = false;
                        object = this.maintainerSnoozeLock_;
                        synchronized (object) {
                            this.poolMaintainer_.snooze_ = false;
                            this.maintainerSnoozeLock_.notify();
                        }
                        this.wakeMaintainerDaemon();
                        this.wakeScavengerDaemon();
                        this.wakeReaperDaemon();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "closePool() join maintainer daemon");
                    }
                    try {
                        this.maintainerDaemon_.join(10000L);
                    }
                    catch (Exception e) {
                        if (!JDTrace.isTraceOn()) break block64;
                        JDTrace.logException(this, "closePool() join maintainerDaemon exception", e);
                    }
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "closePool() join scavengerDaemon");
                }
                try {
                    this.scavengerDaemon_.join(10000L);
                }
                catch (Exception e) {
                    if (!JDTrace.isTraceOn()) break block65;
                    JDTrace.logException(this, "closePool() join scavengerDaemon exception", e);
                }
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "closePool() join reaperDaemon");
            }
            if (this.poolReaper_ != null) {
                try {
                    this.reaperDaemon_.join(10000L);
                }
                catch (Exception e) {
                    if (!JDTrace.isTraceOn()) break block66;
                    JDTrace.logException(this, "closePool() join reaperDaemon exception", e);
                }
            }
        }
        object = this.activeConnections_;
        synchronized (object) {
            this.activeConnections_.notifyAll();
        }
        object = this.availableConnections_[0];
        synchronized (object) {
            this.availableConnections_[0].notifyAll();
        }
        object = this.availableConnections_[1];
        synchronized (object) {
            this.availableConnections_[1].notifyAll();
        }
        object = this.condemnedConnections_;
        synchronized (object) {
            this.condemnedConnections_.notifyAll();
        }
        object = this.connectionsCreatedLock_;
        synchronized (object) {
            this.connectionsCreatedLock_.notifyAll();
        }
        object = this.connectionsDestroyedLock_;
        synchronized (object) {
            this.connectionsDestroyedLock_.notifyAll();
        }
        object = this.activeConnections_;
        synchronized (object) {
            HashMap hashMap = this.availableConnections_[0];
            synchronized (hashMap) {
                HashMap hashMap2 = this.availableConnections_[1];
                synchronized (hashMap2) {
                    ArrayList arrayList = this.condemnedConnections_;
                    synchronized (arrayList) {
                        block68: {
                            block67: {
                                if (DEBUG) {
                                    this.logInformation("Number available: " + this.availableConnectionsIdledSequence_[0].size() + this.availableConnectionsIdledSequence_[1].size());
                                    this.logInformation("Number active: " + this.activeConnections_.size());
                                    this.logInformation("Number active in error: " + this.activeConnectionsInError_.size());
                                    this.logInformation("Number condemned: " + this.condemnedConnections_.size());
                                    if (DEBUG) {
                                        this.logInformation("Internal connection counter: " + this.getConnectionCount(11));
                                    }
                                }
                                if (JDTrace.isTraceOn()) {
                                    JDTrace.logInformation(this, "closePool() Number available: " + this.availableConnectionsIdledSequence_[0].size() + this.availableConnectionsIdledSequence_[1].size());
                                    JDTrace.logInformation(this, "closePool() Number active: " + this.activeConnections_.size());
                                    JDTrace.logInformation(this, "closePool() Number active in error: " + this.activeConnectionsInError_.size());
                                    JDTrace.logInformation(this, "closePool() Number condemned: " + this.condemnedConnections_.size());
                                    JDTrace.logInformation(this, "closePool() Internal connection counter: " + this.getConnectionCount(11));
                                }
                                try {
                                    for (int side = 0; side <= 1; ++side) {
                                        JDConnectionPoolKey[] poolKeys = this.availableConnections_[side].keySet().toArray(new JDConnectionPoolKey[0]);
                                        for (int i = 0; i < poolKeys.length; ++i) {
                                            Stack connStack = (Stack)this.availableConnections_[side].get(poolKeys[i]);
                                            if (connStack == null) continue;
                                            for (AS400JDBCPooledConnection conn : connStack) {
                                                this.closePhysicalConnection(conn);
                                                if (!GATHER_STATS) continue;
                                                ++this.survivingConnectionsRemoved_;
                                            }
                                            connStack.clear();
                                        }
                                        this.availableConnections_[side].clear();
                                    }
                                }
                                catch (Exception e) {
                                    if (!JDTrace.isTraceOn()) break block67;
                                    JDTrace.logException(this, "closePool() close availableConnection exception", e);
                                }
                            }
                            this.availableConnectionsIdledSequence_[0].clear();
                            this.availableConnectionsIdledSequence_[1].clear();
                            try {
                                for (AS400JDBCPooledConnection conn : this.activeConnections_) {
                                    this.closePhysicalConnection(conn);
                                    if (!GATHER_STATS) continue;
                                    ++this.survivingConnectionsRemoved_;
                                }
                                this.activeConnections_.clear();
                                this.activeConnectionsInError_.clear();
                            }
                            catch (Throwable conn) {
                                // empty catch block
                            }
                            try {
                                for (AS400JDBCPooledConnection conn : this.condemnedConnections_) {
                                    this.closePhysicalConnection(conn);
                                    if (!GATHER_STATS) continue;
                                    ++this.condemnedConnectionsRemoved_;
                                }
                                this.condemnedConnections_.clear();
                            }
                            catch (Exception e) {
                                if (!JDTrace.isTraceOn()) break block68;
                                JDTrace.logException(this, "closePool() close condemnedConnection exception", e);
                            }
                        }
                    }
                }
            }
        }
        this.logInformation(ResourceBundleLoader.getText("AS400CP_SHUTDOWNCOMP"));
        this.poolClosedCompletely_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "closePool() done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionEvent event) {
        boolean removed;
        if (DEBUG || GATHER_STATS) {
            ++this.connectionsReturnedToPool_;
        }
        if (this.poolClosed_) {
            return;
        }
        this.pauseIfPoolPaused(0L);
        AS400JDBCPooledConnection conn = (AS400JDBCPooledConnection)event.getSource();
        if (JDTrace.isTraceOn()) {
            this.logInformation(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_RETCONN"), new String[]{this.cpds_.getServerName(), conn.getPoolKey().getUser()}));
        }
        TreeSet treeSet = this.activeConnections_;
        synchronized (treeSet) {
            if (this.poolClosed_) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "did not " + conn.getClass().toString() + "(" + conn.hashCode() + ") from activeConnections because pool closed");
                }
                return;
            }
            removed = this.activeConnections_.remove(conn);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "removed  " + conn.getClass().toString() + "(" + conn.hashCode() + ") from activeConnections");
            }
            if (conn.fatalConnectionErrorOccurred_) {
                this.activeConnectionsInError_.remove(conn);
            }
        }
        if (removed) {
            long timeNow = System.currentTimeMillis();
            if (!(!this.reuseConnections_ || conn.fatalConnectionErrorOccurred_ || this.maxLifetime_ != 0L && this.isExpired(conn, timeNow - this.maxLifetime_))) {
                conn.returned();
                JDConnectionPoolKey poolKey = conn.getPoolKey();
                HashMap hashMap = this.availableConnections_[0];
                synchronized (hashMap) {
                    Stack<AS400JDBCPooledConnection> connStack = (Stack<AS400JDBCPooledConnection>)this.availableConnections_[0].get(poolKey);
                    if (connStack == null) {
                        connStack = new Stack<AS400JDBCPooledConnection>();
                        this.availableConnections_[0].put(poolKey, connStack);
                    }
                    connStack.push(conn);
                    this.availableConnectionsIdledSequence_[0].add(conn);
                    conn.timeWhenPoolStatusLastModified_ = timeNow;
                }
            } else {
                if ((DEBUG || GATHER_STATS) && this.isExpired(conn, timeNow - this.maxLifetime_)) {
                    ++this.expiredConnectionsIdentifiedWhenReturned_;
                }
                ArrayList arrayList = this.condemnedConnections_;
                synchronized (arrayList) {
                    this.condemnedConnections_.add(conn);
                }
            }
        } else if (JDTrace.isTraceOn()) {
            this.logDiagnostic("connectionClosed(): The returned connection was not found on the 'active connections' list: " + conn.toString());
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        this.logException("connectionErrorOccurred", event.getSQLException());
        if (DEBUG || GATHER_STATS) {
            ++this.connectionErrorsOccurred_;
        }
        if (this.poolClosed_) {
            return;
        }
        this.pauseIfPoolPaused(0L);
        AS400JDBCPooledConnection conn = (AS400JDBCPooledConnection)event.getSource();
        this.activeConnectionsInError_.add(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createNewConnection(JDConnectionPoolKey poolKey, boolean keyIsDefault, char[] password) {
        if (DEBUG) {
            this.logInformation("createNewConnection(" + poolKey.getUser() + ")");
        }
        if (this.poolClosed_) {
            return;
        }
        if (this.isPoolFull()) {
            if (DEBUG) {
                this.logWarning("Connection pool is full, so no new connection was added.");
            }
            return;
        }
        if (JDTrace.isTraceOn()) {
            this.logInformation(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_FILLING"), new String[]{Integer.valueOf(1).toString(), this.cpds_.getServerName(), poolKey.getUser()}));
        }
        AS400JDBCPooledConnection newConn = null;
        boolean addedConnectionToPool = false;
        try {
            newConn = keyIsDefault ? (AS400JDBCPooledConnection)this.cpds_.getPooledConnection() : (AS400JDBCPooledConnection)this.cpds_.getPooledConnection(poolKey.getUser(), password);
            Object object = this.connectionsCreatedLock_;
            synchronized (object) {
                ++this.numConnectionsCreated_;
            }
            newConn.addConnectionEventListener(this);
            newConn.setPoolKey(poolKey);
            object = this.availableConnections_[0];
            synchronized (object) {
                Stack<AS400JDBCPooledConnection> connStack = (Stack<AS400JDBCPooledConnection>)this.availableConnections_[0].get(poolKey);
                if (connStack == null) {
                    connStack = new Stack<AS400JDBCPooledConnection>();
                    this.availableConnections_[0].put(poolKey, connStack);
                }
                if (!this.isPoolOverFull()) {
                    connStack.push(newConn);
                    this.availableConnectionsIdledSequence_[0].add(newConn);
                    addedConnectionToPool = true;
                    newConn.timeWhenPoolStatusLastModified_ = System.currentTimeMillis();
                } else if (DEBUG) {
                    this.logWarning("Connection pool is full, so new connection not added");
                }
            }
        }
        catch (SQLException e) {
            this.wakeMaintainerDaemon();
            this.logException(ResourceBundleLoader.getText("AS400CP_FILLEXC"), e);
        }
        finally {
            if (!addedConnectionToPool && newConn != null) {
                if (DEBUG) {
                    this.logDiagnostic("Closing pre-created connection");
                }
                this.closePhysicalConnection(newConn);
                if (GATHER_STATS) {
                    ++this.surplusPrecreatedConnectionsRemoved_;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillPool(int numConnectionsToAdd, int side) {
        block35: {
            if (this.poolClosed_) {
                return;
            }
            if (DEBUG) {
                this.logDiagnostic("fillPool(" + numConnectionsToAdd + "," + side + ")");
            }
            if (this.isPoolFull()) {
                if (DEBUG) {
                    this.logDiagnostic("fillPool() is returning because pool is already full");
                }
                return;
            }
            if (this.poolSizeLimited_ && numConnectionsToAdd + this.getConnectionCount(10) > this.maxPoolSize_) {
                if (DEBUG) {
                    this.logDiagnostic("The requested number of connections (" + numConnectionsToAdd + ") would cause the connection pool to exceed its maximum size");
                }
                numConnectionsToAdd = this.maxPoolSize_ - this.getConnectionCount(10);
            }
            if (numConnectionsToAdd < 1) {
                if (DEBUG) {
                    this.logDiagnostic("fillPool() is returning because pool is already full");
                }
                return;
            }
            JDConnectionPoolKey poolKey = this.cpds_.getConnectionPoolKey();
            AS400JDBCPooledConnection[] newConnections = null;
            int numberOfConnsCreatedForThisRequest = 0;
            int numConnectionsAddedToPool = 0;
            this.pauseIfPoolPaused(0L);
            this.fillingPool_ = true;
            try {
                newConnections = new AS400JDBCPooledConnection[numConnectionsToAdd];
                String user = this.cpds_.getUser();
                if (user == null || user.length() <= 0) break block35;
                try {
                    for (int i = 0; i < numConnectionsToAdd; ++i) {
                        AS400JDBCPooledConnection conn = (AS400JDBCPooledConnection)this.cpds_.getPooledConnection();
                        ++numberOfConnsCreatedForThisRequest;
                        conn.addConnectionEventListener(this);
                        conn.setPoolKey(poolKey);
                        newConnections[i] = conn;
                    }
                }
                finally {
                    if (numberOfConnsCreatedForThisRequest != 0) {
                        Object object = this.connectionsCreatedLock_;
                        synchronized (object) {
                            this.numConnectionsCreated_ += numberOfConnsCreatedForThisRequest;
                        }
                    }
                }
                if (JDTrace.isTraceOn()) {
                    this.logInformation(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_FILLING"), new String[]{Integer.valueOf(numConnectionsToAdd).toString(), this.cpds_.getServerName(), poolKey.getUser()}));
                }
                HashMap hashMap = this.availableConnections_[side];
                synchronized (hashMap) {
                    Stack<AS400JDBCPooledConnection> connStack = (Stack<AS400JDBCPooledConnection>)this.availableConnections_[side].get(poolKey);
                    if (connStack == null) {
                        connStack = new Stack<AS400JDBCPooledConnection>();
                        this.availableConnections_[side].put(poolKey, connStack);
                    }
                    if (this.isPoolOverFull()) {
                        numConnectionsToAdd -= Math.max(0, this.getConnectionCount(11) - this.maxPoolSize_);
                    }
                    long timeNow = System.currentTimeMillis();
                    for (int i = 0; i < numConnectionsToAdd; ++i) {
                        connStack.push(newConnections[i]);
                        this.availableConnectionsIdledSequence_[side].add(newConnections[i]);
                        ++numConnectionsAddedToPool;
                        newConnections[i].timeWhenPoolStatusLastModified_ = timeNow;
                    }
                }
            }
            catch (SQLException e) {
                this.wakeMaintainerDaemon();
                this.logException(ResourceBundleLoader.getText("AS400CP_FILLEXC"), e);
            }
            finally {
                if (numberOfConnsCreatedForThisRequest > numConnectionsAddedToPool) {
                    if (DEBUG) {
                        this.logDiagnostic("newConnections.length==" + newConnections.length + "; numConnectionsAddedToPool==" + numConnectionsAddedToPool + "; need to close " + (numberOfConnsCreatedForThisRequest - numConnectionsAddedToPool) + " connections");
                    }
                    for (int i = numConnectionsAddedToPool; i < numberOfConnsCreatedForThisRequest && i < newConnections.length; ++i) {
                        if (DEBUG) {
                            this.logDiagnostic("Closing surplus pre-created connection[" + i + "]");
                        }
                        this.closePhysicalConnection(newConnections[i]);
                        if (!GATHER_STATS) continue;
                        ++this.surplusPrecreatedConnectionsRemoved_;
                    }
                }
                this.fillingPool_ = false;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (DEBUG) {
            this.logInformation("finalize");
        }
        this.closePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getConnectionCount(int howToSync) {
        switch (howToSync) {
            case 10: {
                return this.numConnectionsCreated_ - this.numConnectionsDestroyed_;
            }
            case 11: {
                Object object = this.connectionsCreatedLock_;
                synchronized (object) {
                    Object object2 = this.connectionsDestroyedLock_;
                    synchronized (object2) {
                        return this.numConnectionsCreated_ - this.numConnectionsDestroyed_;
                    }
                }
            }
        }
        this.logError("Internal error: JDConnectionPoolManager.getConnectionCount(" + howToSync + ")");
        return this.numConnectionsCreated_ - this.numConnectionsDestroyed_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AS400JDBCConnectionHandle getConnection(JDConnectionPoolKey poolKey, char[] password) throws SQLException {
        boolean keyIsDefault;
        if (DEBUG || GATHER_STATS) {
            ++this.numGetConnectionCalls_received_;
        }
        if (this.poolClosed_) {
            if (DEBUG || GATHER_STATS) {
                ++this.numGetConnectionCalls_whileClosing_;
            }
            String msg = ResourceBundleLoader.getText("EXC_CONN_POOL_CLOSED");
            Trace.log(2, msg);
            throw new SQLException(msg);
        }
        this.pauseIfPoolPaused(0L);
        boolean triedToSwap = false;
        boolean triedToCreateNewConnection = false;
        if (poolKey == null) {
            poolKey = this.cpds_.getConnectionPoolKey();
            keyIsDefault = true;
        } else {
            keyIsDefault = poolKey.equals(this.cpds_.getConnectionPoolKey());
        }
        AS400JDBCPooledConnection conn1 = null;
        boolean needMoreDefaultConnections = false;
        boolean done = false;
        for (int ii = 0; ii < 5 && !done; ++ii) {
            HashMap hashMap = this.availableConnections_[0];
            synchronized (hashMap) {
                if (this.poolClosed_) {
                    if (DEBUG || GATHER_STATS) {
                        ++this.numGetConnectionCalls_whileClosing_;
                    }
                    String msg = ResourceBundleLoader.getText("EXC_CONN_POOL_CLOSED");
                    Trace.log(2, msg);
                    throw new SQLException(msg);
                }
                for (int jj = 0; conn1 == null && jj < 3; ++jj) {
                    Stack connStack = (Stack)this.availableConnections_[0].get(poolKey);
                    if (connStack != null && !connStack.empty()) {
                        conn1 = (AS400JDBCPooledConnection)connStack.pop();
                        this.availableConnectionsIdledSequence_[0].remove(conn1);
                        if (keyIsDefault && connStack.empty()) {
                            needMoreDefaultConnections = true;
                        }
                    }
                    if (conn1 != null) continue;
                    if (!triedToSwap) {
                        if (DEBUG) {
                            this.logInformation("getConnection() is requesting a swap");
                        }
                        this.swapConnectionLists(0, poolKey);
                        triedToSwap = true;
                        continue;
                    }
                    if (triedToCreateNewConnection || this.isPoolFull()) continue;
                    this.createNewConnection(poolKey, keyIsDefault, password);
                    triedToCreateNewConnection = true;
                }
            }
            if (!this.pretestConnections_ || conn1 == null) {
                done = true;
                continue;
            }
            AS400Impl system = null;
            Object exc = null;
            try {
                system = conn1.getInternalConnection().getAS400();
            }
            catch (SQLException e) {
                this.logException(ResourceBundleLoader.getText("AS400CP_FILLEXC"), e);
            }
            if (system != null && system.isConnectionAlive(4)) continue;
            if (JDTrace.isTraceOn()) {
                this.logDiagnostic("JDConnectionPoolManager.getConnection() is condemning a connection that has failed a validity pretest: " + conn1.toString());
            }
            ArrayList arrayList = this.condemnedConnections_;
            synchronized (arrayList) {
                this.condemnedConnections_.add(conn1);
            }
            conn1 = null;
            done = false;
        }
        AS400JDBCConnectionHandle handle1 = null;
        if (conn1 != null) {
            try {
                handle1 = conn1.getConnectionHandle();
            }
            catch (SQLException e) {
                this.logException(ResourceBundleLoader.getText("AS400CP_FILLEXC"), e);
                ArrayList exc = this.condemnedConnections_;
                synchronized (exc) {
                    this.condemnedConnections_.add(conn1);
                }
                conn1 = null;
                handle1 = null;
            }
        }
        if (conn1 != null) {
            if (DEBUG || GATHER_STATS) {
                ++this.numGetConnectionCalls_succeeded_;
            }
            TreeSet e = this.activeConnections_;
            synchronized (e) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "adding " + conn1.getClass().toString() + "(" + conn1.hashCode() + ") to activeConnections");
                }
                this.activeConnections_.add(conn1);
                conn1.timeWhenPoolStatusLastModified_ = System.currentTimeMillis();
            }
        }
        if (conn1 == null) {
            if (keyIsDefault) {
                needMoreDefaultConnections = true;
            }
            if (GATHER_STATS) {
                System.out.print("((" + poolKey.getUser() + "/" + password + "))");
            }
            if (DEBUG || GATHER_STATS) {
                ++this.numGetConnectionCalls_returnedNull_;
            }
            if (DEBUG) {
                Stack foregroundStack = (Stack)this.availableConnections_[0].get(poolKey);
                Stack backgroundStack = (Stack)this.availableConnections_[1].get(poolKey);
                this.logWarning("PoolManager returning null for  |" + poolKey + "|. " + this.getConnectionCount(11) + "/" + this.maxPoolSize_ + "/ " + (foregroundStack == null ? "null" : Integer.toString(foregroundStack.size())) + "," + (backgroundStack == null ? "null" : Integer.toString(backgroundStack.size())));
            }
        }
        if (!this.needMoreConnections_ && (needMoreDefaultConnections || this.isPoolFull() || this.getConnectionCount(10) < this.minPoolSize_)) {
            this.needMoreConnections_ = true;
            this.wakeMaintainerDaemon();
        }
        if (handle1 == null && this.enforceMaxPoolSize_) {
            String msg = ResourceBundleLoader.getText("AS400CP_MAXSIZE_FAILED");
            Trace.log(2, msg);
            throw new SQLException(msg);
        }
        return handle1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void invalidate(JDConnectionPoolKey poolKey) {
        if (this.poolClosed_) {
            return;
        }
        HashSet hashSet = this.invalidatedKeys_;
        synchronized (hashSet) {
            this.invalidatedKeys_.add(poolKey);
        }
    }

    private final boolean isExpired(AS400JDBCPooledConnection conn, long cutoffTime) {
        return conn.timeWhenCreated_ < cutoffTime;
    }

    private final boolean isStale(AS400JDBCPooledConnection conn, long cutoffTime) {
        return conn.timeWhenPoolStatusLastModified_ < cutoffTime;
    }

    private final boolean isPoolFull() {
        if (this.poolSizeLimited_ && this.getConnectionCount(10) >= this.maxPoolSize_) {
            if (DEBUG || GATHER_STATS) {
                System.out.println("\nPOOL IS FULL: " + 100 * this.getConnectionCount(10) / this.maxPoolSize_ + "% ALLOCATED");
            }
            return true;
        }
        return false;
    }

    private final boolean isPoolOverFull() {
        return this.poolSizeLimited_ && this.getConnectionCount(10) > this.maxPoolSize_;
    }

    private final void logDiagnostic(String text) {
        this.logger_.logDiagnostic(text);
    }

    private final void logError(String text) {
        this.logger_.logError(text);
    }

    private final void logException(String text, Exception e) {
        this.logger_.logException(text, e);
    }

    private final void logInformation(String text) {
        this.logger_.logInformation(text);
    }

    private final void logWarning(String text) {
        this.logger_.logWarning(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pauseIfPoolPaused(long maxTimeToPause) {
        while (this.poolPaused_) {
            if (DEBUG) {
                this.logDiagnostic("Pool is paused");
            }
            try {
                Object object = this.poolPauseLock_;
                synchronized (object) {
                    if (this.poolPaused_) {
                        this.poolPauseLock_.wait(maxTimeToPause);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pausePool() {
        this.poolPaused_ = true;
        Object object = this.poolPauseLock_;
        synchronized (object) {
            this.poolPaused_ = true;
        }
    }

    private final boolean isBackgroundListLongerThanForegroundList(JDConnectionPoolKey poolKey) {
        Stack foregroundStack;
        Stack backgroundStack = (Stack)this.availableConnections_[1].get(poolKey);
        return backgroundStack != null && backgroundStack.size() != 0 && ((foregroundStack = (Stack)this.availableConnections_[0].get(poolKey)) == null || foregroundStack.size() < backgroundStack.size());
    }

    private final void swapAvailLists() {
        this.availableConnections_[2] = this.availableConnections_[0];
        this.availableConnections_[0] = this.availableConnections_[1];
        this.availableConnections_[1] = this.availableConnections_[2];
        this.availableConnections_[2] = null;
        this.availableConnectionsIdledSequence_[2] = this.availableConnectionsIdledSequence_[0];
        this.availableConnectionsIdledSequence_[0] = this.availableConnectionsIdledSequence_[1];
        this.availableConnectionsIdledSequence_[1] = this.availableConnectionsIdledSequence_[2];
        this.availableConnectionsIdledSequence_[2] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean swapConnectionLists(int sideRequestingSwap, JDConnectionPoolKey poolKey) {
        if (GATHER_STATS) {
            ++this.swapsAttempted_;
        }
        boolean swapped = false;
        boolean alreadySwapping = this.swapInProgress_;
        try {
            Object object;
            if (!alreadySwapping) {
                if (System.currentTimeMillis() - this.timeLastSwapAttempted_ < this.minSwapInterval_) {
                    if (DEBUG || GATHER_STATS) {
                        ++this.swapsFailed_premature_;
                    }
                    if (DEBUG) {
                        this.logDiagnostic("Premature swap request rejected");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (!this.isBackgroundListLongerThanForegroundList(poolKey)) {
                    if (DEBUG) {
                        this.logDiagnostic("Swap request rejected because background list is not longer than foreground list");
                    }
                    if (GATHER_STATS) {
                        ++this.swapsFailed_notWorthIt_;
                    }
                    boolean bl = false;
                    return bl;
                }
                object = this.swapLock_;
                synchronized (object) {
                    if (this.swapInProgress_) {
                        alreadySwapping = true;
                    } else {
                        this.swapInProgress_ = true;
                    }
                }
            }
            if (alreadySwapping) {
                if (DEBUG) {
                    this.logDiagnostic("Swap request rejected because swap already in progress");
                }
                if (GATHER_STATS) {
                    if (sideRequestingSwap == 0) {
                        ++this.swapsFailed_foreground_inProgress_;
                    } else {
                        ++this.swapsFailed_background_inProgress_;
                    }
                }
                boolean bl = false;
                return bl;
            }
            try {
                switch (sideRequestingSwap) {
                    case 1: {
                        object = this.availableConnections_[0];
                        synchronized (object) {
                            if (this.poolClosed_) {
                                boolean bl = false;
                                return bl;
                            }
                            HashMap hashMap = this.availableConnections_[1];
                            synchronized (hashMap) {
                                this.timeLastSwapAttempted_ = System.currentTimeMillis();
                                if (this.isBackgroundListLongerThanForegroundList(poolKey)) {
                                    this.swapAvailLists();
                                    swapped = true;
                                    if (!DEBUG) {
                                        if (!GATHER_STATS) return swapped;
                                    }
                                    ++this.swapsSucceeded_background_;
                                } else {
                                    if (DEBUG || GATHER_STATS) {
                                        ++this.swapsFailed_background_;
                                    }
                                    if (!DEBUG) return swapped;
                                    this.logDiagnostic("Swap requested by daemon rejected because background list is not longer than foreground list");
                                }
                                return swapped;
                            }
                        }
                    }
                    case 0: {
                        if (this.poolMaintainer_.isAwake_) {
                            if (DEBUG || GATHER_STATS) {
                                ++this.swapsFailed_foreground_daemonAwake_;
                            }
                            if (DEBUG) {
                                this.logDiagnostic("Foreground swap request rejected because daemon is awake");
                            }
                            boolean bl = false;
                            return bl;
                        }
                        object = this.maintainerSnoozeLock_;
                        synchronized (object) {
                            this.poolMaintainer_.snooze_ = true;
                        }
                        try {
                            if (this.poolMaintainer_.isAwake_) {
                                if (DEBUG || GATHER_STATS) {
                                    ++this.swapsFailed_foreground_daemonAwake_;
                                }
                                if (DEBUG) {
                                    this.logDiagnostic("Foreground swap request rejected because daemon is awake");
                                }
                                boolean bl = false;
                                return bl;
                            }
                            object = this.availableConnections_[0];
                            synchronized (object) {
                                if (this.poolClosed_) {
                                    boolean bl = false;
                                    return bl;
                                }
                                HashMap hashMap = this.availableConnections_[1];
                                synchronized (hashMap) {
                                    this.timeLastSwapAttempted_ = System.currentTimeMillis();
                                    if (this.isBackgroundListLongerThanForegroundList(poolKey)) {
                                        this.swapAvailLists();
                                        swapped = true;
                                        if (!DEBUG) {
                                            if (!GATHER_STATS) return swapped;
                                        }
                                        ++this.swapsSucceeded_foreground_;
                                    } else {
                                        if (DEBUG || GATHER_STATS) {
                                            ++this.swapsFailed_foreground_;
                                        }
                                        if (!DEBUG) return swapped;
                                        this.logDiagnostic("Swap request rejected because background list is not longer than foreground list");
                                    }
                                    return swapped;
                                }
                            }
                        }
                        finally {
                            this.poolMaintainer_.snooze_ = false;
                            Object object2 = this.maintainerSnoozeLock_;
                            synchronized (object2) {
                                this.poolMaintainer_.snooze_ = false;
                                this.maintainerSnoozeLock_.notify();
                            }
                        }
                    }
                }
                this.logError("Internal error: JDConnectionPoolManager.swapConnectionLists(" + sideRequestingSwap + ")" + sideRequestingSwap);
                this.swapConnectionLists(0, poolKey);
                return swapped;
            }
            finally {
                if (swapped) {
                    this.needMoreConnections_ = false;
                }
                this.swapInProgress_ = false;
            }
        }
        finally {
            if (GATHER_STATS) {
                if (swapped) {
                    ++this.swapsSucceeded_;
                } else {
                    ++this.swapsFailed_;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unpausePool() {
        this.poolPaused_ = false;
        Object object = this.poolPauseLock_;
        synchronized (object) {
            this.poolPaused_ = false;
            this.poolPauseLock_.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wakeMaintainerDaemon() {
        Object object = this.maintainerSleepLock_;
        synchronized (object) {
            this.maintainerSleepLock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wakeReaperDaemon() {
        Object object = this.reaperSleepLock_;
        synchronized (object) {
            this.reaperSleepLock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wakeScavengerDaemon() {
        Object object = this.scavengerSleepLock_;
        synchronized (object) {
            this.scavengerSleepLock_.notify();
        }
    }

    static /* synthetic */ long access$500(JDConnectionPoolManager x0) {
        return x0.maintainerInterval_;
    }

    static /* synthetic */ Object access$1000(JDConnectionPoolManager x0) {
        return x0.maintainerSleepLock_;
    }

    static /* synthetic */ Object access$1200(JDConnectionPoolManager x0) {
        return x0.maintainerSnoozeLock_;
    }

    static /* synthetic */ int access$1308(JDConnectionPoolManager x0) {
        return x0.maintainerDaemonCycles_++;
    }

    static /* synthetic */ boolean access$1500(JDConnectionPoolManager x0) {
        return x0.isPoolFull();
    }

    static /* synthetic */ HashMap[] access$1700(JDConnectionPoolManager x0) {
        return x0.availableConnections_;
    }

    static /* synthetic */ HashSet access$1800(JDConnectionPoolManager x0) {
        return x0.invalidatedKeys_;
    }

    static /* synthetic */ int access$2008(JDConnectionPoolManager x0) {
        return x0.staleConnectionsIdentified_++;
    }

    static /* synthetic */ LinkedHashSet[] access$2100(JDConnectionPoolManager x0) {
        return x0.availableConnectionsIdledSequence_;
    }

    static /* synthetic */ int access$2700(JDConnectionPoolManager x0) {
        return x0.maxPoolSize_;
    }

    static /* synthetic */ AS400JDBCManagedConnectionPoolDataSource access$2800(JDConnectionPoolManager x0) {
        return x0.cpds_;
    }

    static /* synthetic */ int access$2900(JDConnectionPoolManager x0) {
        return x0.minDefaultStackSize_;
    }

    static /* synthetic */ void access$3000(JDConnectionPoolManager x0, int x1, int x2) {
        x0.fillPool(x1, x2);
    }

    static /* synthetic */ boolean access$3100(JDConnectionPoolManager x0) {
        return x0.needMoreConnections_;
    }

    static /* synthetic */ boolean access$3200(JDConnectionPoolManager x0, int x1, JDConnectionPoolKey x2) {
        return x0.swapConnectionLists(x1, x2);
    }

    static /* synthetic */ long access$3602(JDConnectionPoolManager x0, long x1) {
        x0.minSwapInterval_ = x1;
        return x0.minSwapInterval_;
    }

    private final class JDPoolScavenger
    implements Runnable {
        private static final String DAEMON_NAME = "Scavenger daemon";

        private JDPoolScavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            JDConnectionPoolManager.this.logInformation("Scavenger daemon started with scavengerInterval_ = " + JDConnectionPoolManager.this.scavengerInterval_ + " msecs");
            ArrayList<AS400JDBCPooledConnection> candidatesForRemoval = new ArrayList<AS400JDBCPooledConnection>(JDConnectionPoolManager.this.minPoolSize_);
            long previousRunTime = 0L;
            long runStartTime = 0L;
            try {
                while (JDConnectionPoolManager.this.keepDaemonsAlive_) {
                    if (GATHER_STATS) {
                        System.out.print("(s)");
                    }
                    try {
                        Object object;
                        long timeToSleep = JDConnectionPoolManager.this.scavengerInterval_ - previousRunTime;
                        if (timeToSleep > 0L) {
                            try {
                                object = JDConnectionPoolManager.this.scavengerSleepLock_;
                                // MONITORENTER : object
                                JDConnectionPoolManager.this.scavengerSleepLock_.wait(timeToSleep);
                                // MONITOREXIT : object
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (DEBUG) {
                                JDConnectionPoolManager.this.logInformation("Scavenger daemon emerged from wait()");
                            }
                        } else if (JDTrace.isTraceOn()) {
                            JDConnectionPoolManager.this.logWarning("Scavenger daemon did not sleep");
                        }
                        if (!JDConnectionPoolManager.this.keepDaemonsAlive_) {
                            return;
                        }
                        if (DEBUG) {
                            JDConnectionPoolManager.this.logInformation("Scavenger daemon woke up");
                        }
                        if (DEBUG || GATHER_STATS) {
                            JDConnectionPoolManager.this.scavengerDaemonCycles_++;
                        }
                        JDConnectionPoolManager.this.pauseIfPoolPaused(0L);
                        runStartTime = System.currentTimeMillis();
                        if (GATHER_STATS) {
                            System.out.print("(+S)");
                        }
                        object = JDConnectionPoolManager.this.condemnedConnections_;
                        // MONITORENTER : object
                        if (!JDConnectionPoolManager.this.keepDaemonsAlive_) {
                            // MONITOREXIT : object
                            return;
                        }
                        Iterator condemnedIter = JDConnectionPoolManager.this.condemnedConnections_.iterator();
                        while (condemnedIter.hasNext()) {
                            AS400JDBCPooledConnection conn = (AS400JDBCPooledConnection)condemnedIter.next();
                            condemnedIter.remove();
                            candidatesForRemoval.add(conn);
                        }
                        // MONITOREXIT : object
                        if ((DEBUG || GATHER_STATS) && candidatesForRemoval.size() != 0) {
                            System.out.println("\n(CLEANUP)Scavenger daemon is closing " + candidatesForRemoval.size() + " condemned connections.");
                        }
                        Iterator candidatesIter = candidatesForRemoval.iterator();
                        while (candidatesIter.hasNext()) {
                            JDConnectionPoolManager.this.closePhysicalConnection((AS400JDBCPooledConnection)candidatesIter.next());
                            if (DEBUG || GATHER_STATS) {
                                JDConnectionPoolManager.this.condemnedConnectionsRemoved_++;
                            }
                            candidatesIter.remove();
                        }
                        if (!DEBUG || JDConnectionPoolManager.this.getConnectionCount(11) >= 0) continue;
                        JDConnectionPoolManager.this.logError("Scavenger daemon: Total connection count is negative");
                    }
                    catch (Exception e) {
                        if (!JDTrace.isTraceOn()) continue;
                        JDConnectionPoolManager.this.logException("Exception caught by Scavenger daemon", e);
                    }
                    finally {
                        previousRunTime = System.currentTimeMillis() - runStartTime;
                        if (!JDConnectionPoolManager.this.isPoolOverFull()) continue;
                        JDConnectionPoolManager.this.wakeReaperDaemon();
                    }
                }
                return;
            }
            finally {
                JDConnectionPoolManager.this.logInformation("Scavenger daemon has stopped");
            }
        }
    }

    private final class JDPoolReaper
    implements Runnable {
        private static final String DAEMON_NAME = "Reaper daemon";

        private JDPoolReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JDConnectionPoolManager.this.logInformation("Reaper daemon started with reaperInterval_ = " + JDConnectionPoolManager.this.reaperInterval_ + " msecs and maxLifetime_ = " + JDConnectionPoolManager.this.maxLifetime_ + " msecs");
            ArrayList<AS400JDBCPooledConnection> candidatesForRemoval = new ArrayList<AS400JDBCPooledConnection>(JDConnectionPoolManager.this.minPoolSize_);
            long previousRunTime = 0L;
            long runStartTime = 0L;
            try {
                while (JDConnectionPoolManager.this.keepDaemonsAlive_) {
                    if (GATHER_STATS) {
                        System.out.print("(r)");
                    }
                    try {
                        int numCondemnedConnections;
                        long timeToSleep = JDConnectionPoolManager.this.reaperInterval_ - previousRunTime;
                        if (timeToSleep > 0L) {
                            try {
                                Object object = JDConnectionPoolManager.this.reaperSleepLock_;
                                synchronized (object) {
                                    JDConnectionPoolManager.this.reaperSleepLock_.wait(timeToSleep);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (DEBUG) {
                                JDConnectionPoolManager.this.logInformation("Reaper daemon emerged from wait()");
                            }
                        } else if (JDTrace.isTraceOn()) {
                            JDConnectionPoolManager.this.logWarning("Reaper daemon did not sleep");
                        }
                        if (!JDConnectionPoolManager.this.keepDaemonsAlive_) break;
                        if (DEBUG) {
                            JDConnectionPoolManager.this.logInformation("Reaper daemon woke up");
                        }
                        if (DEBUG || GATHER_STATS) {
                            JDConnectionPoolManager.this.reaperDaemonCycles_++;
                        }
                        JDConnectionPoolManager.this.pauseIfPoolPaused(JDConnectionPoolManager.this.reaperInterval_);
                        runStartTime = System.currentTimeMillis();
                        if (GATHER_STATS) {
                            System.out.print("(R)");
                        }
                        long cutoffTime = runStartTime - JDConnectionPoolManager.this.maxLifetime_;
                        candidatesForRemoval.clear();
                        TreeSet treeSet = JDConnectionPoolManager.this.activeConnections_;
                        synchronized (treeSet) {
                            AS400JDBCPooledConnection conn;
                            block39: {
                                if (JDConnectionPoolManager.this.keepDaemonsAlive_) break block39;
                                break;
                            }
                            Iterator activeIter = JDConnectionPoolManager.this.activeConnections_.iterator();
                            while (activeIter.hasNext() && JDConnectionPoolManager.this.isExpired(conn = (AS400JDBCPooledConnection)activeIter.next(), cutoffTime)) {
                                if (!JDConnectionPoolManager.this.isStale(conn, runStartTime - JDConnectionPoolManager.this.maxIdleTime_)) continue;
                                if (DEBUG || GATHER_STATS) {
                                    JDConnectionPoolManager.this.expiredConnectionsIdentifiedByReaper_++;
                                }
                                activeIter.remove();
                                if (conn.fatalConnectionErrorOccurred_) {
                                    JDConnectionPoolManager.this.activeConnectionsInError_.remove(conn);
                                }
                                candidatesForRemoval.add(conn);
                            }
                        }
                        if ((DEBUG || GATHER_STATS) && candidatesForRemoval.size() != 0) {
                            System.out.println("\n(CLEANUP)Reaper daemon has added " + candidatesForRemoval.size() + " expired connections to condemned list.");
                        }
                        Iterator candidatesIter = candidatesForRemoval.iterator();
                        ArrayList arrayList = JDConnectionPoolManager.this.condemnedConnections_;
                        synchronized (arrayList) {
                            while (candidatesIter.hasNext()) {
                                AS400JDBCPooledConnection conn = (AS400JDBCPooledConnection)candidatesIter.next();
                                if (JDTrace.isTraceOn()) {
                                    JDConnectionPoolManager.this.logDiagnostic("Reaper daemon is closing an active connection that has exceeded the maximum lifetime: " + conn.toString());
                                }
                                JDConnectionPoolManager.this.condemnedConnections_.add(conn);
                                candidatesIter.remove();
                            }
                            numCondemnedConnections = JDConnectionPoolManager.this.condemnedConnections_.size();
                        }
                        if (numCondemnedConnections <= JDConnectionPoolManager.this.condemnedListLengthThreshold_) continue;
                        JDConnectionPoolManager.this.wakeScavengerDaemon();
                    }
                    catch (Exception e) {
                        if (!JDTrace.isTraceOn()) continue;
                        JDConnectionPoolManager.this.logException("Exception caught by Reaper daemon", e);
                    }
                    finally {
                        previousRunTime = System.currentTimeMillis() - runStartTime;
                    }
                }
            }
            finally {
                JDConnectionPoolManager.this.logInformation("Reaper daemon has stopped");
            }
        }
    }

    private final class JDPoolMaintainer
    implements Runnable {
        private static final String DAEMON_NAME = "Maintainer daemon";
        boolean isAwake_ = true;
        boolean snooze_ = false;

        private JDPoolMaintainer() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private final class JDAgeComparator
    implements Comparator {
        private JDAgeComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                long creationTime1 = ((AS400JDBCPooledConnection)o1).timeWhenCreated_;
                long creationTime2 = ((AS400JDBCPooledConnection)o2).timeWhenCreated_;
                if (creationTime1 < creationTime2) {
                    return -1;
                }
                if (creationTime1 > creationTime2) {
                    return 1;
                }
                if (o1.hashCode() < o2.hashCode()) {
                    return -1;
                }
                if (o1.hashCode() > o2.hashCode()) {
                    return 1;
                }
                return 0;
            }
            catch (ClassCastException e) {
                JDConnectionPoolManager.this.logException("Exception when comparing connections", e);
                throw new InternalErrorException(6, (Throwable)e);
            }
        }
    }
}

