/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDPrinterFile;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterFileImpl;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class PrinterFile
extends PrintObject
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PATH = "path";

    PrinterFile(AS400 system, NPCPIDPrinterFile id, NPCPAttribute attrs) {
        super(system, id, attrs, 5);
    }

    public PrinterFile() {
        super(null, null, 5);
    }

    public PrinterFile(AS400 system, String printerFileName) {
        super(system, PrinterFile.buildIDCodePoint(printerFileName), null, 5);
    }

    private static NPCPIDPrinterFile buildIDCodePoint(String IFSPrinterFileName) {
        QSYSObjectPathName ifsPath = new QSYSObjectPathName(IFSPrinterFileName, "FILE");
        return new NPCPIDPrinterFile(ifsPath.getObjectName(), ifsPath.getLibraryName());
    }

    @Override
    void checkRunTimeState() {
        super.checkRunTimeState();
        if (this.getIDCodePoint() == null) {
            Trace.log(2, "Parameter 'path' has not been set.");
            throw new ExtendedIllegalStateException(PATH, 4);
        }
    }

    @Override
    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use PrinterFile before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrinterFileImpl)system.loadImpl2("com.ibm.as400.access.PrinterFileImplRemote", "com.ibm.as400.access.PrinterFileImplProxy");
        super.setImpl();
    }

    public String getName() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(92);
    }

    public String getPath() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return QSYSObjectPathName.toPath(IDCodePoint.getStringValue(91), IDCodePoint.getStringValue(92), "FILE");
    }

    public void setAttributes(PrintParameterList attributes) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (attributes == null) {
            Trace.log(2, "Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((PrinterFileImpl)this.impl_).setAttributes(attributes);
        this.attrs = this.impl_.getAttrValue();
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null");
            throw new NullPointerException(PATH);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException(PATH, 5);
        }
        String oldPath = this.getPath();
        this.vetos.fireVetoableChange(PATH, oldPath, path);
        this.setIDCodePoint(PrinterFile.buildIDCodePoint(path));
        this.changes.firePropertyChange(PATH, oldPath, path);
    }
}

