/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.util.BASE64Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import utilities.JarMakerEvent;
import utilities.JarMakerListener;

public class JarMaker {
    static final boolean DEBUG = false;
    private static final boolean DEBUG_MANIFEST = false;
    private static final boolean DEBUG_CP = false;
    private static final boolean DEBUG_ZIP = false;
    private static final boolean DEBUG_REF = false;
    static final String CLASS_SUFFIX = ".class";
    private static final String MANIFEST_DIR_NAME = "META-INF/";
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_NAME_KEYWORD = "Name:";
    private static final String MANIFEST_VERSION_KEYWORD = "Manifest-Version:";
    private static final String MANIFEST_REQVERS_KEYWORD = "Required-Version:";
    private static final int BUFFER_SIZE = 2048;
    private static final int SPLIT_SIZE_KBYTES = 2048;
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final File CURRENT_DIR = new File(System.getProperty("user.dir"));
    static final boolean CHECK_DUPS = true;
    static final boolean NO_CHECK_DUPS = false;
    static final int STARTS_WITH = 1;
    static final int ENDS_WITH = 2;
    static final int CONTAINS = 3;
    private static boolean noSHA_ = false;
    private static boolean noMD5_ = false;
    boolean verbose_;
    boolean requestedUsageInfo_;
    private File sourceJarFile_;
    private File destinationJarFile_;
    private Vector filesRequired_ = new Vector();
    private Vector filesExcluded_ = new Vector();
    private Vector packages_ = new Vector();
    private Vector packagesExcluded_ = new Vector();
    private Hashtable additionalFiles_ = new Hashtable();
    boolean excludeSomeDependencies_;
    Vector dependenciesToExclude_ = new Vector();
    private boolean extract_ = false;
    private File baseDirectoryForExtract_ = new File(System.getProperty("user.dir"));
    private boolean split_ = false;
    private int splitSize_ = 2048;
    private String jarEntryDefaultPrefix_;
    private String jarEntryDefaultPrefixDotted_;
    private transient Vector eventListeners_ = new Vector();
    private Arguments arguments_ = new Arguments();
    static final boolean OPTIONS_ALL = true;
    static final boolean OPTIONS_UNRECOGNIZED = false;

    public JarMaker() {
    }

    JarMaker(String jarEntryDefaultPrefix) {
        this.jarEntryDefaultPrefix_ = jarEntryDefaultPrefix;
        this.jarEntryDefaultPrefixDotted_ = jarEntryDefaultPrefix.replace('/', '.');
    }

    static boolean addElement(Vector vector, Object object) {
        if (vector.contains(object)) {
            return false;
        }
        vector.addElement(object);
        return true;
    }

    static void removeElements(Vector vector, String namePattern, int patternLocation) {
        Vector<String> entriesToRemove = new Vector<String>();
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            boolean removeEntry = false;
            switch (patternLocation) {
                case 1: {
                    if (!entry.startsWith(namePattern)) break;
                    removeEntry = true;
                    break;
                }
                case 2: {
                    if (!entry.endsWith(namePattern)) break;
                    removeEntry = true;
                    break;
                }
                default: {
                    if (entry.indexOf(namePattern) == -1) break;
                    removeEntry = true;
                }
            }
            if (!removeEntry) continue;
            entriesToRemove.addElement(entry);
        }
        Enumeration e2 = entriesToRemove.elements();
        while (e2.hasMoreElements()) {
            vector.removeElement((String)e2.nextElement());
        }
    }

    public synchronized void addJarMakerListener(JarMakerListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners_.addElement(listener);
    }

    static void addPackageFiles(Vector neededJarEntries, JarMap jarMap, Vector packages) throws IOException {
        Enumeration pkgs = packages.elements();
        while (pkgs.hasMoreElements()) {
            String packageName = (String)pkgs.nextElement();
            String packagePrefix = packageName.replace('.', '/');
            Vector entriesInPackage = JarMaker.getEntryNamesForPackage(packagePrefix, jarMap);
            if (entriesInPackage.size() == 0) {
                System.err.println("Error: Specified package not found in source file:");
                System.err.println("       " + packageName);
                throw new ZipException(packageName);
            }
            JarMaker.copyVector(entriesInPackage, neededJarEntries, true);
        }
    }

    static void removePackageFiles(Vector neededJarEntries, JarMap jarMap, Vector packages) throws IOException {
        Enumeration pkgs = packages.elements();
        while (pkgs.hasMoreElements()) {
            String packageName = (String)pkgs.nextElement();
            String packagePrefix = packageName.replace('.', '/');
            Vector entriesInPackage = JarMaker.getEntryNamesForPackage(packagePrefix, jarMap);
            if (entriesInPackage.size() == 0) {
                System.err.println("Error: Specified package not found in source file:");
                System.err.println("       " + packageName);
                throw new ZipException(packageName);
            }
            JarMaker.removeElements(neededJarEntries, entriesInPackage);
        }
    }

    Vector adjustDependencies1(Vector neededJarEntries, JarMap jarMap) throws IOException {
        return neededJarEntries;
    }

    Vector adjustDependencies2(Vector neededJarEntries, JarMap jarMap) throws IOException {
        JarMaker.removePackageFiles(neededJarEntries, jarMap, this.packagesExcluded_);
        JarMaker.addPackageFiles(neededJarEntries, jarMap, this.packages_);
        return neededJarEntries;
    }

    void analyzeJarEntry(String jarEntryName, Vector unanalyzedEntries, Vector referencedJarEntries, JarMap jarMap) throws IOException {
        this.fireAnalysisEvent(true, jarEntryName);
        if (jarEntryName.endsWith(CLASS_SUFFIX)) {
            if (this.excludeSomeDependencies_ && this.dependenciesToExclude_.contains(jarEntryName)) {
                if (this.verbose_) {
                    System.out.println("\nExcluding entry from dependency analysis: " + jarEntryName + "\n");
                }
                JarMaker.addElement(referencedJarEntries, jarEntryName);
            } else {
                Vector referencedEntries = this.getReferencedEntries(jarEntryName, jarMap);
                Enumeration e = referencedEntries.elements();
                while (e.hasMoreElements()) {
                    String entryName = (String)e.nextElement();
                    if (!unanalyzedEntries.contains(entryName)) continue;
                    unanalyzedEntries.removeElement(entryName);
                    this.analyzeJarEntry(entryName, unanalyzedEntries, referencedJarEntries, jarMap);
                    JarMaker.addElement(referencedJarEntries, entryName);
                }
            }
        }
        this.fireAnalysisEvent(false, jarEntryName);
    }

    private static void constructManifestEntry(StringBuffer buffer, File file, String entryName) throws IOException {
        String encodedStr;
        String lineSHA = null;
        String lineMD5 = null;
        byte[] fileContents = JarMaker.getBytes(file);
        if (!noSHA_) {
            try {
                MessageDigest shaMD = MessageDigest.getInstance("SHA");
                byte[] shaDigest = shaMD.digest(fileContents);
                encodedStr = new BASE64Encoder().encodeBuffer(shaDigest);
                lineSHA = "SHA-Digest: " + encodedStr;
            }
            catch (NoSuchAlgorithmException e) {
                noSHA_ = true;
            }
        }
        if (!noMD5_) {
            try {
                MessageDigest md5MD = MessageDigest.getInstance("MD5");
                byte[] md5Digest = md5MD.digest(fileContents);
                encodedStr = new BASE64Encoder().encodeBuffer(md5Digest);
                lineMD5 = "MD5-Digest: " + encodedStr;
            }
            catch (NoSuchAlgorithmException e) {
                noMD5_ = true;
            }
        }
        if (lineSHA != null || lineMD5 != null) {
            buffer.append("Name: ").append(entryName).append("\n");
            buffer.append("Digest-Algorithms:");
            if (lineSHA != null) {
                buffer.append(" SHA");
            }
            if (lineMD5 != null) {
                buffer.append(" MD5");
            }
            buffer.append('\n');
            if (lineSHA != null) {
                buffer.append(lineSHA);
                if (!lineSHA.endsWith("\n")) {
                    buffer.append('\n');
                }
            }
            if (lineMD5 != null) {
                buffer.append(lineMD5);
                if (!lineMD5.endsWith("\n")) {
                    buffer.append('\n');
                }
            }
            buffer.append('\n');
        } else {
            System.err.println("Error: Failed to construct manifest entry for file");
            System.err.println("       " + file.getAbsolutePath());
        }
    }

    static final boolean contains(int[] list, int element) {
        return Arrays.binarySearch(list, element) >= 0;
    }

    private static void copyBytes(InputStream inStream, OutputStream outStream, long bytesToCopy) throws IOException {
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        int totalBytes = 0;
        boolean done = false;
        while (!done && (long)totalBytes < bytesToCopy) {
            bytesRead = inStream.read(buffer, 0, buffer.length);
            if (bytesRead == -1) {
                done = true;
                continue;
            }
            outStream.write(buffer, 0, bytesRead);
            totalBytes += bytesRead;
        }
    }

    static void copyFile(File sourceFile, File destinationFile) throws IOException {
        if (sourceFile == null) {
            throw new NullPointerException("sourceFile");
        }
        if (destinationFile == null) {
            throw new NullPointerException("destinationFile");
        }
        BufferedInputStream source = null;
        FilterOutputStream destination = null;
        String parentDirName = destinationFile.getParent();
        if (parentDirName == null) {
            throw new NullPointerException("parentDirectory");
        }
        File outFileDir = new File(parentDirName);
        if (!outFileDir.exists() && !outFileDir.mkdirs()) {
            throw new IOException(outFileDir.getAbsolutePath() + ": Cannot create directory.");
        }
        byte[] buffer = new byte[2048];
        try {
            source = new BufferedInputStream(new FileInputStream(sourceFile), 2048);
            destination = new BufferedOutputStream(new FileOutputStream(destinationFile), 2048);
            boolean done = false;
            while (!done) {
                int bytesRead = source.read(buffer);
                if (bytesRead == -1) {
                    done = true;
                    continue;
                }
                ((BufferedOutputStream)destination).write(buffer, 0, bytesRead);
            }
            ((BufferedOutputStream)destination).flush();
        }
        catch (IOException e) {
            System.err.println("Error: IOException when copying file");
            System.err.println("       " + destinationFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (Throwable throwable) {}
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    static void copyVector(Vector fromList, Vector toList, boolean checkDups) {
        Enumeration e = fromList.elements();
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (checkDups && toList.contains(element)) continue;
            toList.addElement(element);
        }
    }

    static void removeElements(Vector list, Vector entriesToRemove) {
        Enumeration e = entriesToRemove.elements();
        while (e.hasMoreElements()) {
            list.remove(e.nextElement());
        }
    }

    static void copyZipEntry(ZipEntry inZipEntry, InputStream inStream, ZipOutputStream zipOutStream) throws IOException {
        long time;
        long size;
        if (inZipEntry == null) {
            throw new NullPointerException("inZipEntry");
        }
        if (inStream == null) {
            throw new NullPointerException("inStream");
        }
        if (zipOutStream == null) {
            throw new NullPointerException("zipOutStream");
        }
        ZipEntry outZipEntry = new ZipEntry(inZipEntry.getName());
        outZipEntry.setComment(inZipEntry.getComment());
        long crc = inZipEntry.getCrc();
        if (crc != -1L) {
            outZipEntry.setCrc(crc);
        }
        outZipEntry.setExtra(inZipEntry.getExtra());
        int method = inZipEntry.getMethod();
        if (method != -1) {
            outZipEntry.setMethod(method);
        }
        if ((size = inZipEntry.getSize()) != -1L) {
            outZipEntry.setSize(size);
        }
        if ((time = inZipEntry.getTime()) != -1L) {
            outZipEntry.setTime(time);
        }
        zipOutStream.putNextEntry(outZipEntry);
        byte[] buffer = new byte[2048];
        if (!inZipEntry.isDirectory()) {
            int bytesRead = 0;
            int totalBytes = 0;
            boolean done = false;
            while (!done && (long)totalBytes < size) {
                bytesRead = inStream.read(buffer);
                if (bytesRead == -1) {
                    done = true;
                    continue;
                }
                zipOutStream.write(buffer, 0, bytesRead);
                totalBytes += bytesRead;
            }
        }
    }

    private static int determineDirMetadataSize(Vector dirNames, int baseMetadataPerZipEntry) {
        int result = 0;
        Enumeration e = dirNames.elements();
        while (e.hasMoreElements()) {
            String dirName = (String)e.nextElement();
            result += dirName.length();
            result += baseMetadataPerZipEntry;
        }
        return result;
    }

    public File extract(File sourceJarFile) throws FileNotFoundException, IOException, ZipException {
        if (sourceJarFile == null) {
            throw new NullPointerException("sourceJarFile");
        }
        File outputDirectory = new File(System.getProperty("user.dir"));
        this.extract(sourceJarFile, outputDirectory);
        return outputDirectory;
    }

    public void extract(File sourceJarFile, File outputDirectory) throws FileNotFoundException, IOException, ZipException {
        if (sourceJarFile == null) {
            throw new NullPointerException("sourceJarFile");
        }
        if (outputDirectory == null) {
            throw new NullPointerException("outputDirectory");
        }
        if (!sourceJarFile.exists()) {
            throw new FileNotFoundException(sourceJarFile.getAbsolutePath());
        }
        if (this.verbose_) {
            System.out.println("Source file is " + sourceJarFile.getAbsolutePath());
            System.out.println("Extraction output directory is " + outputDirectory.getAbsolutePath());
        }
        FilterOutputStream destinationFile = null;
        InputStream inStream = null;
        String basePath = outputDirectory.getAbsolutePath();
        JarMap jarMap = null;
        if (this.additionalFiles_.size() != 0) {
            System.err.println("Warning: Additional files were specified.  They are ignored by extract().");
        }
        try {
            jarMap = new JarMap(sourceJarFile, this.verbose_);
            Vector referencedJarEntries = this.identifyDependencies(jarMap);
            if (jarMap.hasManifest() && !referencedJarEntries.contains(MANIFEST_ENTRY_NAME)) {
                int dirIndex = referencedJarEntries.indexOf(MANIFEST_DIR_NAME);
                if (dirIndex == -1) {
                    referencedJarEntries.insertElementAt(MANIFEST_DIR_NAME, 0);
                    dirIndex = 0;
                }
                referencedJarEntries.insertElementAt(MANIFEST_ENTRY_NAME, dirIndex + 1);
            }
            if (this.verbose_) {
                System.out.println("Extracting files");
            }
            Enumeration e = referencedJarEntries.elements();
            while (e.hasMoreElements()) {
                String entryName = (String)e.nextElement();
                String filePath = JarMaker.generateFilePath(basePath, entryName);
                if (this.verbose_) {
                    System.out.print(".");
                }
                if (entryName.endsWith("/")) {
                    File outFileDir = new File(filePath.substring(0, filePath.length() - 1));
                    if (outFileDir.exists() || outFileDir.mkdirs()) continue;
                    throw new IOException(outFileDir.getAbsolutePath() + ": Cannot create directory.");
                }
                destinationFile = new BufferedOutputStream(new FileOutputStream(filePath), 2048);
                ZipEntry entry = jarMap.getEntry(entryName);
                if (entry == null) {
                    throw new FileNotFoundException(entryName);
                }
                inStream = jarMap.getInputStream(entry);
                JarMaker.copyBytes(inStream, destinationFile, entry.getSize());
                destinationFile.close();
                destinationFile = null;
                inStream.close();
                inStream = null;
            }
        }
        catch (ZipException e) {
            System.err.println("Error: ZipException when extracting source file");
            System.err.println("       " + sourceJarFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        catch (IOException e) {
            System.err.println("Error: IOException when extracting source file");
            System.err.println("       " + sourceJarFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        finally {
            if (jarMap != null) {
                try {
                    jarMap.close();
                }
                catch (Throwable throwable) {}
            }
            if (destinationFile != null) {
                try {
                    destinationFile.close();
                }
                catch (Throwable throwable) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAnalysisEvent(boolean start, String entryName) {
        Vector targets;
        JarMaker jarMaker = this;
        synchronized (jarMaker) {
            targets = (Vector)this.eventListeners_.clone();
        }
        JarMakerEvent event = new JarMakerEvent(this, entryName);
        for (int i = 0; i < targets.size(); ++i) {
            JarMakerListener target = (JarMakerListener)targets.elementAt(i);
            if (start) {
                target.dependencyAnalysisStarted(event);
                continue;
            }
            target.dependencyAnalysisCompleted(event);
        }
    }

    private static Vector generateDirEntries(String entryName, Vector listSoFar) {
        Vector<String> outList = new Vector<String>();
        String pathPrefix = entryName.substring(0, entryName.lastIndexOf("/") + 1);
        if (pathPrefix.length() != 0) {
            int slashPos = pathPrefix.indexOf("/");
            while (slashPos != -1 && slashPos < entryName.length() - 1) {
                String subPrefix = pathPrefix.substring(0, slashPos + 1);
                if (!listSoFar.contains(subPrefix)) {
                    outList.addElement(subPrefix);
                }
                slashPos = pathPrefix.indexOf("/", slashPos + 1);
            }
        }
        return outList;
    }

    static String generateFilePath(File baseDirectory, String entryName) {
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory");
        }
        return JarMaker.generateFilePath(baseDirectory.getAbsolutePath(), entryName);
    }

    static String generateFilePath(String basePath, String entryName) {
        if (basePath == null) {
            throw new NullPointerException("basePath");
        }
        if (entryName == null) {
            throw new NullPointerException("entryName");
        }
        StringBuilder pathBuf = new StringBuilder(basePath.trim());
        if (pathBuf.charAt(pathBuf.length() - 1) != FILE_SEPARATOR) {
            pathBuf.append(FILE_SEPARATOR);
        }
        StringBuffer convertedName = new StringBuffer(entryName.trim().replace('/', FILE_SEPARATOR));
        pathBuf.append(convertedName);
        String path = pathBuf.toString();
        return path;
    }

    private static Hashtable generateJarEntryMap(Hashtable fileList) {
        Hashtable<File, String> entryNames = fileList.size() != 0 ? new Hashtable(fileList.size()) : new Hashtable<File, String>();
        Enumeration e = fileList.keys();
        while (e.hasMoreElements()) {
            File file = (File)e.nextElement();
            File baseDir = (File)fileList.get(file);
            String entryName = JarMaker.generateJarEntryName(file, baseDir);
            entryNames.put(file, entryName);
        }
        return entryNames;
    }

    private static String generateJarEntryName(File file, File baseDir) {
        String basePath;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(basePath = baseDir.getAbsolutePath())) {
            filePath = filePath.substring(basePath.length());
        } else {
            System.err.println("Warning: File path does not begin with base path for additional files.");
            System.err.println("   File path: " + filePath);
            System.err.println("   Base path: " + basePath);
        }
        String entryName = filePath.replace(FILE_SEPARATOR, '/');
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        }
        return entryName;
    }

    public Vector getAdditionalFiles() {
        Vector<File> files = new Vector<File>();
        Enumeration e = this.additionalFiles_.keys();
        while (e.hasMoreElements()) {
            files.addElement((File)e.nextElement());
        }
        return files;
    }

    static byte[] getBytes(File file) throws IOException {
        long fileSize = file.length();
        byte[] buffer = new byte[(int)fileSize];
        try (FileInputStream inStream = new FileInputStream(file);){
            int bytesRead = ((InputStream)inStream).read(buffer);
            if ((long)bytesRead < fileSize) {
                throw new IOException(file.getAbsolutePath() + ": Failed to read entire file.");
            }
        }
        return buffer;
    }

    File getDestinationJar() {
        return this.destinationJarFile_;
    }

    private static Vector getEntryNamesForPackage(String packagePrefix, JarMap jarMap) {
        Vector<String> entriesInPackage = new Vector<String>();
        int prefixLength = packagePrefix.length();
        Enumeration e = jarMap.elements();
        block3: while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            switch (prefixLength) {
                case 0: {
                    if (entryName.indexOf(47) != -1) continue block3;
                    entriesInPackage.addElement(entryName);
                    continue block3;
                }
            }
            if (!entryName.startsWith(packagePrefix) || entryName.lastIndexOf(47) != prefixLength) continue;
            entriesInPackage.addElement(entryName);
        }
        return entriesInPackage;
    }

    File getExtractionDirectory() {
        return this.baseDirectoryForExtract_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getReferencedEntries(String jarEntryName, JarMap jarMap) throws IOException {
        if (this.verbose_) {
            System.out.print(".");
        }
        ZipEntry entry = jarMap.getEntry(jarEntryName);
        String entryName = entry.getName();
        String contextPackageName = "";
        int finalSlashPos = entryName.lastIndexOf(47);
        if (finalSlashPos != -1) {
            contextPackageName = entryName.substring(0, finalSlashPos).replace('/', '.');
        }
        try (InputStream inStream = null;){
            inStream = jarMap.getInputStream(entry);
            Vector classIndexes = this.prescanForClassIndexes(inStream, contextPackageName, jarMap);
            inStream.close();
            inStream = jarMap.getInputStream(entry);
            Vector referenced = this.processBytecodeStream(inStream, contextPackageName, jarMap, classIndexes);
            inStream.close();
            inStream = null;
            Vector vector = referenced;
            return vector;
        }
    }

    public Vector getRequiredFiles() {
        return this.filesRequired_;
    }

    public Vector getFilesRequired() {
        return this.filesRequired_;
    }

    public Vector getFilesExcluded() {
        return this.filesExcluded_;
    }

    public Vector getPackages() {
        return this.packages_;
    }

    public Vector getPackagesExcluded() {
        return this.packagesExcluded_;
    }

    File getSourceJar() {
        return this.sourceJarFile_;
    }

    int getSplitSize() {
        return this.splitSize_;
    }

    String[] getUnrecognizedArgs() {
        return this.arguments_.getUnrecognized();
    }

    private Vector identifyDependencies(JarMap jarMap) throws IOException {
        if (this.verbose_) {
            System.out.println("Analyzing source file");
        }
        Vector referencedJarEntries = new Vector();
        Vector<String> unanalyzedEntries = new Vector<String>();
        Enumeration e = jarMap.entries();
        while (e.hasMoreElements()) {
            unanalyzedEntries.addElement(((ZipEntry)e.nextElement()).getName());
        }
        unanalyzedEntries.removeElement(MANIFEST_ENTRY_NAME);
        Vector filesToInclude = new Vector();
        JarMaker.copyVector(this.filesRequired_, filesToInclude, false);
        JarMaker.copyVector(this.filesExcluded_, this.dependenciesToExclude_, true);
        filesToInclude = this.adjustDependencies1(filesToInclude, jarMap);
        if (filesToInclude.size() == 0) {
            if (this.verbose_) {
                System.out.println("No required JAR or ZIP entries were specified");
            }
        } else {
            if (this.verbose_) {
                System.out.println("Analyzing " + filesToInclude.size() + " required entries, starting with " + filesToInclude.elementAt(0) + ".");
            }
            Enumeration reqEntries = filesToInclude.elements();
            while (reqEntries.hasMoreElements()) {
                String entryName = (String)reqEntries.nextElement();
                if (!jarMap.contains(entryName)) {
                    System.err.println("Warning: The source file does not contain the specified required file: " + entryName);
                    filesToInclude.removeElement(entryName);
                    continue;
                }
                if (!unanalyzedEntries.contains(entryName)) continue;
                unanalyzedEntries.removeElement(entryName);
                this.analyzeJarEntry(entryName, unanalyzedEntries, referencedJarEntries, jarMap);
                JarMaker.addElement(referencedJarEntries, entryName);
            }
            if (this.verbose_) {
                System.out.println();
            }
        }
        if (referencedJarEntries.size() == 0 && this.packages_.size() == 0) {
            JarMaker.copyVector(jarMap.getEntryNames(), referencedJarEntries, false);
        }
        referencedJarEntries = this.adjustDependencies2(referencedJarEntries, jarMap);
        JarMaker.removeElements(referencedJarEntries, this.filesExcluded_);
        referencedJarEntries = JarMaker.sortStrings(referencedJarEntries);
        referencedJarEntries = JarMaker.insertDirectoryEntries(referencedJarEntries);
        return referencedJarEntries;
    }

    private static Vector insertDirectoryEntries(Vector oldList) {
        String priorPrefix = "";
        Vector<String> newList = new Vector<String>(oldList.size());
        Enumeration e = oldList.elements();
        while (e.hasMoreElements()) {
            String listEntry = (String)e.nextElement();
            String prefix = listEntry.substring(0, listEntry.lastIndexOf("/") + 1);
            if (!prefix.equals(priorPrefix)) {
                priorPrefix = prefix;
                int slashPos = prefix.indexOf("/");
                while (slashPos != -1) {
                    String subPrefix = prefix.substring(0, slashPos + 1);
                    if (!newList.contains(subPrefix) && !subPrefix.equals(listEntry)) {
                        newList.addElement(subPrefix);
                    }
                    slashPos = prefix.indexOf("/", slashPos + 1);
                }
            }
            newList.addElement(listEntry);
        }
        return newList;
    }

    boolean isExtract() {
        return this.extract_;
    }

    boolean isOptionInfoSufficient() {
        return this.arguments_.isOptionInfoSufficient();
    }

    boolean isSplit() {
        return this.split_;
    }

    boolean isVerbose() {
        return this.verbose_;
    }

    static String listCommandOptions(CommandLineArguments arguments, boolean listAll) {
        StringBuilder sb = new StringBuilder();
        Enumeration opts = listAll ? arguments.getOptionNames() : arguments.getExtraOptions();
        while (opts.hasMoreElements()) {
            String name = (String)opts.nextElement();
            sb.append(" [").append(name);
            String val = arguments.getOptionValue(name);
            if (val != null && val.length() != 0) {
                sb.append(" ").append(val);
            }
            sb.append("]");
        }
        return sb.toString().trim();
    }

    public File makeJar(File sourceJarFile) throws FileNotFoundException, IOException, ZipException {
        if (sourceJarFile == null) {
            throw new NullPointerException("sourceJarFile");
        }
        File destinationJarFile = JarMaker.setupDefaultDestinationJarFile(sourceJarFile);
        this.makeJar(sourceJarFile, destinationJarFile);
        return destinationJarFile;
    }

    public void makeJar(File sourceJarFile, File destinationJarFile) throws FileNotFoundException, IOException, ZipException {
        if (sourceJarFile == null) {
            throw new NullPointerException("sourceJarFile");
        }
        if (destinationJarFile == null) {
            throw new NullPointerException("destinationJarFile");
        }
        if (!sourceJarFile.exists()) {
            throw new FileNotFoundException(sourceJarFile.getAbsolutePath());
        }
        if (destinationJarFile.exists() && !destinationJarFile.canWrite()) {
            System.err.println("Error: Cannot write file");
            System.err.println("       " + destinationJarFile.getAbsolutePath());
            throw new IOException(destinationJarFile.getAbsolutePath());
        }
        if (this.verbose_) {
            System.out.println("Source file is " + sourceJarFile.getAbsolutePath());
            System.out.println("Destination file is " + destinationJarFile.getAbsolutePath());
        }
        if (destinationJarFile.getAbsolutePath().equals(sourceJarFile.getAbsolutePath())) {
            System.err.println("Error: Destination file is same as source file.");
            throw new IllegalArgumentException("destinationJarFile(" + destinationJarFile.getAbsolutePath() + ")");
        }
        JarMap jarMap = null;
        ManifestMap manifestMap = null;
        ZipOutputStream zipOutStream = null;
        InputStream inStream = null;
        FilterOutputStream bufferedOutStream = null;
        try {
            jarMap = new JarMap(sourceJarFile, this.verbose_);
            Vector referencedJarEntries = this.identifyDependencies(jarMap);
            Enumeration e1 = this.additionalFiles_.keys();
            while (e1.hasMoreElements()) {
                File file = (File)e1.nextElement();
                if (file.exists() && file.isFile()) continue;
                System.err.println("Error: A specified additional file was not found:");
                System.err.println("       " + file.getAbsolutePath());
            }
            Hashtable additionalFilesMap = JarMaker.generateJarEntryMap(this.additionalFiles_);
            if (this.verbose_) {
                System.out.println();
                System.out.println("Opening destination file " + destinationJarFile.getAbsolutePath());
            }
            bufferedOutStream = new BufferedOutputStream(new FileOutputStream(destinationJarFile), 2048);
            zipOutStream = new ZipOutputStream(bufferedOutStream);
            if (jarMap.hasManifest()) {
                manifestMap = new ManifestMap(jarMap);
                StringBuffer buffer = new StringBuffer();
                String manifestHeader = manifestMap.getHeader();
                if (manifestHeader.length() != 0) {
                    buffer.append(manifestHeader);
                }
                Enumeration e3 = manifestMap.elements();
                while (e3.hasMoreElements()) {
                    String fileName = (String)e3.nextElement();
                    if (!referencedJarEntries.contains(fileName) || additionalFilesMap.contains(fileName)) continue;
                    String manifestEntryText = manifestMap.get(fileName);
                    buffer.append(manifestEntryText);
                }
                if (this.additionalFiles_.size() != 0) {
                    if (this.verbose_) {
                        System.out.println("Creating manifest entries for additional files");
                    }
                    Enumeration af = this.additionalFiles_.keys();
                    while (af.hasMoreElements()) {
                        File file = (File)af.nextElement();
                        String entryName = (String)additionalFilesMap.get(file);
                        JarMaker.constructManifestEntry(buffer, file, entryName);
                    }
                }
                byte[] bufferBytes = buffer.toString().getBytes();
                ZipEntry newManifestEntry = new ZipEntry(MANIFEST_ENTRY_NAME);
                newManifestEntry.setSize(bufferBytes.length);
                zipOutStream.putNextEntry(newManifestEntry);
                zipOutStream.write(bufferBytes);
                zipOutStream.flush();
                ((BufferedOutputStream)bufferedOutStream).flush();
                zipOutStream.closeEntry();
                ((BufferedOutputStream)bufferedOutStream).flush();
            }
            Vector<String> directoriesSoFar = new Vector<String>();
            Enumeration refEntries = referencedJarEntries.elements();
            while (refEntries.hasMoreElements()) {
                ZipEntry entry;
                String referencedEntry = (String)refEntries.nextElement();
                if (this.verbose_) {
                    System.out.print(".");
                }
                if (additionalFilesMap.contains(referencedEntry)) continue;
                if (referencedEntry.endsWith("/")) {
                    directoriesSoFar.addElement(referencedEntry);
                }
                if ((entry = jarMap.getEntry(referencedEntry)) == null) {
                    if (referencedEntry.endsWith("/")) continue;
                    throw new IOException(referencedEntry + ": No such entry in source file.");
                }
                inStream = jarMap.getInputStream(entry);
                JarMaker.copyZipEntry(entry, inStream, zipOutStream);
                zipOutStream.flush();
                ((BufferedOutputStream)bufferedOutStream).flush();
                zipOutStream.closeEntry();
                ((BufferedOutputStream)bufferedOutStream).flush();
                inStream.close();
                inStream = null;
            }
            if (this.verbose_) {
                System.out.println();
            }
            Enumeration addlFiles = this.additionalFiles_.keys();
            while (addlFiles.hasMoreElements()) {
                File file = (File)addlFiles.nextElement();
                String entryName = (String)additionalFilesMap.get(file);
                Vector dirsToAdd = JarMaker.generateDirEntries(entryName, directoriesSoFar);
                Enumeration de = dirsToAdd.elements();
                while (de.hasMoreElements()) {
                    String dirName = (String)de.nextElement();
                    ZipEntry dirEntry = new ZipEntry(dirName);
                    dirEntry.setSize(0L);
                    zipOutStream.putNextEntry(dirEntry);
                    zipOutStream.flush();
                    ((BufferedOutputStream)bufferedOutStream).flush();
                    zipOutStream.closeEntry();
                    ((BufferedOutputStream)bufferedOutStream).flush();
                    directoriesSoFar.addElement(dirName);
                }
                ZipEntry entry = new ZipEntry(entryName);
                entry.setSize(file.length());
                entry.setTime(file.lastModified());
                inStream = new BufferedInputStream(new FileInputStream(file), 2048);
                zipOutStream.putNextEntry(entry);
                JarMaker.copyBytes(inStream, zipOutStream, entry.getSize());
                zipOutStream.flush();
                ((BufferedOutputStream)bufferedOutStream).flush();
                zipOutStream.closeEntry();
                ((BufferedOutputStream)bufferedOutStream).flush();
                inStream.close();
                inStream = null;
            }
        }
        catch (ZipException e) {
            System.err.println("Error: ZipException when writing file");
            System.err.println("       " + destinationJarFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        catch (IOException e) {
            System.err.println("Error: IOException when writing file");
            System.err.println("       " + destinationJarFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        finally {
            if (manifestMap != null) {
                try {
                    manifestMap.close();
                }
                catch (Throwable throwable) {}
            }
            if (jarMap != null) {
                try {
                    jarMap.close();
                }
                catch (Throwable throwable) {}
            }
            if (zipOutStream != null) {
                try {
                    zipOutStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (bufferedOutStream != null) {
                try {
                    bufferedOutStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    boolean parseArgs(String[] args, boolean tolerateUnrecognizedArgs) {
        boolean succeeded = false;
        this.reset();
        if (this.arguments_.parse(args, this, tolerateUnrecognizedArgs)) {
            succeeded = true;
        }
        return succeeded;
    }

    private Vector prescanForClassIndexes(InputStream inStream, String contextPackageName, JarMap jarMap) throws IOException {
        Vector<Integer> classIndexes = new Vector<Integer>();
        DataInputStream dataInput = new DataInputStream(inStream);
        JarMaker.skipBytes(dataInput, 4);
        JarMaker.skipBytes(dataInput, 2);
        JarMaker.skipBytes(dataInput, 2);
        int cpCount = dataInput.readUnsignedShort();
        block9: for (int cpIndex = 1; cpIndex < cpCount; ++cpIndex) {
            byte tag = dataInput.readByte();
            switch (tag) {
                case 1: {
                    int length = dataInput.readUnsignedShort();
                    JarMaker.skipBytes(dataInput, length);
                    continue block9;
                }
                case 3: 
                case 4: {
                    JarMaker.skipBytes(dataInput, 4);
                    continue block9;
                }
                case 5: 
                case 6: {
                    JarMaker.skipBytes(dataInput, 8);
                    ++cpIndex;
                    continue block9;
                }
                case 7: {
                    int nameIndex = dataInput.readUnsignedShort();
                    classIndexes.addElement(nameIndex);
                    continue block9;
                }
                case 8: {
                    JarMaker.skipBytes(dataInput, 2);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    JarMaker.skipBytes(dataInput, 2);
                    JarMaker.skipBytes(dataInput, 2);
                    continue block9;
                }
                case 12: {
                    JarMaker.skipBytes(dataInput, 2);
                    JarMaker.skipBytes(dataInput, 2);
                    continue block9;
                }
            }
        }
        return classIndexes;
    }

    private Vector processBytecodeStream(InputStream inStream, String packagePrefix, JarMap jarMap, Vector classIndexes) throws IOException {
        Vector<String> allReferences = new Vector<String>();
        DataInputStream dataInput = new DataInputStream(inStream);
        JarMaker.skipBytes(dataInput, 4);
        JarMaker.skipBytes(dataInput, 2);
        JarMaker.skipBytes(dataInput, 2);
        int cpCount = dataInput.readUnsignedShort();
        block9: for (int cpIndex = 1; cpIndex < cpCount; ++cpIndex) {
            byte tag = dataInput.readByte();
            switch (tag) {
                case 1: {
                    int length = dataInput.readUnsignedShort();
                    if (length <= 0) continue block9;
                    byte[] bytes = new byte[length];
                    dataInput.readFully(bytes);
                    String referencedJarEntry = this.processUtf8(cpIndex, new String(bytes, "UTF8"), classIndexes, packagePrefix, jarMap);
                    if (referencedJarEntry == null) continue block9;
                    allReferences.addElement(referencedJarEntry);
                    continue block9;
                }
                case 3: 
                case 4: {
                    JarMaker.skipBytes(dataInput, 4);
                    continue block9;
                }
                case 5: 
                case 6: {
                    JarMaker.skipBytes(dataInput, 8);
                    ++cpIndex;
                    continue block9;
                }
                case 7: {
                    int nameIndex = dataInput.readUnsignedShort();
                    continue block9;
                }
                case 8: {
                    JarMaker.skipBytes(dataInput, 2);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    JarMaker.skipBytes(dataInput, 2);
                    JarMaker.skipBytes(dataInput, 2);
                    continue block9;
                }
                case 12: {
                    JarMaker.skipBytes(dataInput, 2);
                    JarMaker.skipBytes(dataInput, 2);
                    continue block9;
                }
            }
        }
        return allReferences;
    }

    private String processUtf8(int cpIndex, String literal, Vector classIndexes, String contextPackageName, JarMap jarMap) {
        String result = null;
        if (classIndexes.contains(cpIndex)) {
            String classFileName = literal + CLASS_SUFFIX;
            if (jarMap.contains(classFileName)) {
                result = classFileName;
            }
        } else if (contextPackageName.length() != 0 && literal.startsWith(contextPackageName) || this.jarEntryDefaultPrefix_ != null && (literal.startsWith(this.jarEntryDefaultPrefix_) || literal.startsWith(this.jarEntryDefaultPrefixDotted_))) {
            String propertiesFileName = literal.replace('.', '/') + ".properties";
            if (jarMap.contains(propertiesFileName)) {
                result = propertiesFileName;
            } else {
                String classFileName = literal.replace('.', '/') + CLASS_SUFFIX;
                if (jarMap.contains(classFileName)) {
                    result = classFileName;
                }
            }
        } else {
            String suffix = null;
            int dotPos = literal.lastIndexOf(46);
            if (dotPos != -1) {
                suffix = literal.substring(dotPos).toLowerCase();
            }
            if (suffix != null && (suffix.equals(".gif") || suffix.equals(".jpg") || suffix.equals(".html") || suffix.equals(".pdml") || suffix.equals(".pcml") || suffix.equals(".ser"))) {
                String gifFileName = null;
                if (contextPackageName.length() != 0) {
                    gifFileName = contextPackageName.replace('.', '/') + "/" + literal;
                    if (jarMap.contains(gifFileName)) {
                        result = gifFileName;
                    } else if (jarMap.contains(literal)) {
                        result = literal;
                    }
                } else if (jarMap.contains(literal)) {
                    result = literal;
                }
            }
        }
        return result;
    }

    public synchronized void removeJarMakerListener(JarMakerListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners_.removeElement(listener);
    }

    public void reset() {
        this.sourceJarFile_ = null;
        this.destinationJarFile_ = null;
        this.filesRequired_.removeAllElements();
        this.filesExcluded_.removeAllElements();
        this.packages_.removeAllElements();
        this.packagesExcluded_.removeAllElements();
        this.additionalFiles_.clear();
        this.verbose_ = false;
        this.extract_ = false;
        this.baseDirectoryForExtract_ = new File(System.getProperty("user.dir"));
        this.split_ = false;
        this.splitSize_ = 2048;
        this.eventListeners_.removeAllElements();
        this.arguments_ = new Arguments();
    }

    public void setAdditionalFiles(Vector fileList) {
        File baseDirectory = new File(System.getProperty("user.dir"));
        this.setAdditionalFiles(fileList, baseDirectory);
    }

    public void setAdditionalFiles(Vector fileList, File baseDirectory) {
        if (fileList == null) {
            throw new NullPointerException("fileList");
        }
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory");
        }
        fileList = JarMaker.validateList(fileList, "additionalFile", "java.io.File", this.verbose_);
        Enumeration e = fileList.elements();
        while (e.hasMoreElements()) {
            File file = (File)e.nextElement();
            if (this.additionalFiles_.containsKey(file)) continue;
            this.additionalFiles_.put(file, baseDirectory);
        }
    }

    void setDestinationJar(File destinationJarFile) {
        if (destinationJarFile == null) {
            throw new NullPointerException("destinationJarFile");
        }
        this.destinationJarFile_ = destinationJarFile;
    }

    void setExtract(boolean extract) {
        this.extract_ = extract;
    }

    void setExtractionDirectory(File baseDirectory) {
        this.baseDirectoryForExtract_ = baseDirectory;
    }

    public void setPackages(Vector packages) {
        if (packages == null) {
            throw new NullPointerException("packages");
        }
        packages = JarMaker.validateList(packages, "packageName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(packages, this.packages_, true);
    }

    public void setPackagesExcluded(Vector packages) {
        if (packages == null) {
            throw new NullPointerException("packages");
        }
        packages = JarMaker.validateList(packages, "packageName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(packages, this.packagesExcluded_, true);
    }

    public void setRequiredFiles(Vector entryList) {
        this.setFilesRequired(entryList);
    }

    public void setFilesRequired(Vector entryList) {
        if (entryList == null) {
            throw new NullPointerException("entryList");
        }
        entryList = JarMaker.validateList(entryList, "entryName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(entryList, this.filesRequired_, true);
    }

    public void setFilesExcluded(Vector entryList) {
        if (entryList == null) {
            throw new NullPointerException("entryList");
        }
        entryList = JarMaker.validateList(entryList, "entryName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(entryList, this.filesExcluded_, true);
    }

    void setSourceJar(File sourceJarFile) {
        if (sourceJarFile == null) {
            throw new NullPointerException("sourceJarFile");
        }
        this.sourceJarFile_ = sourceJarFile;
    }

    void setSplit(boolean split) {
        this.split_ = split;
    }

    void setSplitSize(int splitSize) {
        this.splitSize_ = splitSize;
    }

    static File setupDefaultDestinationJarFile(File sourceJarFile) {
        String sourceJarName = sourceJarFile.getName();
        int index = sourceJarName.lastIndexOf(46);
        String suffix = "Small";
        String destinationJarName = index == -1 ? sourceJarName + suffix : sourceJarName.substring(0, index) + suffix + sourceJarName.substring(index);
        return new File(CURRENT_DIR, destinationJarName);
    }

    private static File setupSplitJarFile(File sourceJarFile, int suffix) {
        String sourceJarName = sourceJarFile.getName();
        int index = sourceJarName.lastIndexOf(46);
        String destinationJarName = index == -1 ? sourceJarName + suffix : sourceJarName.substring(0, index) + Integer.toString(suffix) + sourceJarName.substring(index);
        return new File(CURRENT_DIR, destinationJarName);
    }

    public void setVerbose() {
        this.setVerbose(true);
    }

    public void setVerbose(boolean verbose) {
        this.verbose_ = verbose;
    }

    private static final void skipBytes(DataInputStream dataInput, int length) throws IOException {
        int bytesSkipped = dataInput.skipBytes(length);
        if (bytesSkipped != length) {
            throw new IOException("Fewer bytes skipped (" + bytesSkipped + ") than specified (" + length + ").");
        }
    }

    static Vector sortStrings(Vector originalList) {
        Vector<String> sortedList = new Vector<String>(originalList.size());
        Enumeration e = originalList.elements();
        while (e.hasMoreElements()) {
            String oldEntry = (String)e.nextElement();
            boolean done = false;
            int insertionPosition = sortedList.size();
            Enumeration sorted = sortedList.elements();
            int i = 0;
            while (!done && sorted.hasMoreElements()) {
                String sortedEntry = (String)sorted.nextElement();
                if (oldEntry.compareTo(sortedEntry) < 0) {
                    insertionPosition = i;
                    done = true;
                }
                ++i;
            }
            sortedList.insertElementAt(oldEntry, insertionPosition);
        }
        return sortedList;
    }

    public Vector split(File sourceJarFile) throws FileNotFoundException, IOException, ZipException {
        return this.split(sourceJarFile, 2048);
    }

    public Vector split(File sourceJarFile, int splitSizeKbytes) throws FileNotFoundException, IOException, ZipException {
        if (sourceJarFile == null) {
            throw new NullPointerException("sourceJarFile");
        }
        if (splitSizeKbytes < 1) {
            throw new IllegalArgumentException("splitSizeKbytes (" + splitSizeKbytes + ")");
        }
        if (!sourceJarFile.exists()) {
            throw new FileNotFoundException(sourceJarFile.getAbsolutePath());
        }
        if (this.verbose_) {
            System.out.println("Source file is " + sourceJarFile.getAbsolutePath());
            System.out.println("Split size is " + splitSizeKbytes + " kilobytes");
        }
        Vector<File> destJarList = new Vector<File>();
        JarMap jarMap = null;
        ManifestMap manifestMap = null;
        Long splitSizeLong = splitSizeKbytes;
        long splitSize = splitSizeLong * 1024L;
        File currentOutputFile = null;
        try {
            int outFileIndex = 0;
            currentOutputFile = JarMaker.setupSplitJarFile(sourceJarFile, outFileIndex++);
            if (sourceJarFile.length() <= splitSize) {
                JarMaker.copyFile(sourceJarFile, currentOutputFile);
                destJarList.addElement(currentOutputFile);
                Vector<File> vector = destJarList;
                return vector;
            }
            jarMap = new JarMap(sourceJarFile, this.verbose_);
            manifestMap = new ManifestMap(jarMap);
            boolean manifestExists = jarMap.hasManifest();
            int baseMetadataPerZipEntry = jarMap.getSizeOfZipMetadataPerEntry();
            int baseMetadataPerZip = jarMap.getSizeOfZipMetadataPerZip();
            if (manifestExists) {
                baseMetadataPerZip += baseMetadataPerZipEntry + 2 * MANIFEST_ENTRY_NAME.length();
            }
            Vector<String> entriesToWriteNext = new Vector<String>();
            long cumulativeSize = baseMetadataPerZip;
            Vector<String> directoriesSoFar = new Vector<String>();
            Vector dirsToAddForThisEntry = null;
            Enumeration e = jarMap.elements();
            while (e.hasMoreElements()) {
                int directoriesMetadataSize;
                byte[] extraFieldData;
                String entryName = (String)e.nextElement();
                ZipEntry entry = jarMap.getEntry(entryName);
                if (entry == null) {
                    throw new RuntimeException("Programming error: No JarMap entry for " + entryName);
                }
                if (entry.isDirectory()) {
                    directoriesSoFar.addElement(entryName);
                }
                long entrySize = entry.getSize();
                long entryMetadataSize = baseMetadataPerZipEntry + 2 * entryName.length();
                String comment = entry.getComment();
                if (comment != null) {
                    entryMetadataSize += (long)comment.length();
                }
                if ((extraFieldData = entry.getExtra()) != null) {
                    entryMetadataSize += (long)(2 * extraFieldData.length);
                }
                if (manifestExists) {
                    entryMetadataSize += (long)manifestMap.getEntrySize(entryName);
                }
                if (entrySize + entryMetadataSize + (long)baseMetadataPerZip + (long)(directoriesMetadataSize = JarMaker.determineDirMetadataSize(dirsToAddForThisEntry = JarMaker.generateDirEntries(entryName, directoriesSoFar), baseMetadataPerZipEntry)) >= splitSize) {
                    Vector<String> entryToWriteNow = new Vector<String>();
                    entryToWriteNow.addElement(entryName);
                    JarMaker.writeJarEntries(entryToWriteNow, currentOutputFile, jarMap, manifestMap, splitSize, this.verbose_);
                    if (currentOutputFile.length() > splitSize) {
                        System.err.println("Warning: Oversize ZIP entry " + entryName);
                        System.err.println("         was written to file " + currentOutputFile.getAbsolutePath() + ".");
                    }
                    destJarList.addElement(currentOutputFile);
                    currentOutputFile = JarMaker.setupSplitJarFile(sourceJarFile, outFileIndex++);
                    continue;
                }
                if (cumulativeSize + entrySize + entryMetadataSize + (long)directoriesMetadataSize > splitSize) {
                    JarMaker.writeJarEntries(entriesToWriteNext, currentOutputFile, jarMap, manifestMap, splitSize, this.verbose_);
                    entriesToWriteNext.removeAllElements();
                    destJarList.addElement(currentOutputFile);
                    currentOutputFile = JarMaker.setupSplitJarFile(sourceJarFile, outFileIndex++);
                    cumulativeSize = baseMetadataPerZip;
                    directoriesSoFar.removeAllElements();
                    dirsToAddForThisEntry = JarMaker.generateDirEntries(entryName, directoriesSoFar);
                    directoriesMetadataSize = JarMaker.determineDirMetadataSize(dirsToAddForThisEntry, baseMetadataPerZipEntry);
                }
                entriesToWriteNext.addElement(entryName);
                if (dirsToAddForThisEntry != null) {
                    JarMaker.copyVector(dirsToAddForThisEntry, directoriesSoFar, false);
                }
                cumulativeSize += entrySize + entryMetadataSize + (long)directoriesMetadataSize;
            }
            if (entriesToWriteNext.size() != 0) {
                JarMaker.writeJarEntries(entriesToWriteNext, currentOutputFile, jarMap, manifestMap, splitSize, this.verbose_);
                entriesToWriteNext.removeAllElements();
                destJarList.addElement(currentOutputFile);
            }
        }
        catch (ZipException e) {
            System.err.println("Error: ZipException when splitting file");
            System.err.println("       " + sourceJarFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        catch (IOException e) {
            System.err.println("Error: IOException when splitting file");
            System.err.println("       " + sourceJarFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        finally {
            if (manifestMap != null) {
                try {
                    manifestMap.close();
                }
                catch (Throwable throwable) {}
            }
            if (jarMap != null) {
                try {
                    jarMap.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return destJarList;
    }

    static Vector validateList(Vector oldList, String parmName, String className, boolean verbose) {
        if (oldList == null) {
            throw new NullPointerException("list");
        }
        if (parmName == null) {
            throw new NullPointerException("parmName");
        }
        if (className == null) {
            throw new NullPointerException("className");
        }
        Class<?> expectedClass = null;
        try {
            expectedClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Programming error: Class not found: " + className);
        }
        Vector newList = new Vector(oldList.size());
        Enumeration e = oldList.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (element == null) {
                throw new NullPointerException(parmName);
            }
            if (!expectedClass.isInstance(element)) {
                String actualClass = element.getClass().getName();
                throw new IllegalArgumentException(parmName + " (object of class " + actualClass + ")");
            }
            if (element instanceof Integer) {
                int value = (Integer)element;
                if (value < 0) {
                    throw new IllegalArgumentException(parmName + " (" + value + ")");
                }
            } else if (element instanceof String) {
                String elem = ((String)element).trim();
                if (elem.length() == 0) {
                    throw new IllegalArgumentException(parmName + "()");
                }
                element = elem;
            }
            if (!newList.contains(element)) {
                newList.addElement(element);
            }
            ++i;
        }
        return newList;
    }

    private static void writeJarEntries(Vector entryNames, File outFile, JarMap jarMap, ManifestMap manifestMap, long splitSize, boolean verbose) throws FileNotFoundException, IOException, ZipException {
        if (entryNames == null) {
            throw new NullPointerException("entryNames");
        }
        if (outFile == null) {
            throw new NullPointerException("outFile");
        }
        if (jarMap == null) {
            throw new NullPointerException("jarMap");
        }
        if (manifestMap == null) {
            throw new NullPointerException("manifestMap");
        }
        if (verbose) {
            System.out.println("writeJarEntries( " + outFile.getName() + " )");
        }
        ZipOutputStream zipOutStream = null;
        BufferedOutputStream bufferedOutStream = null;
        InputStream inStream = null;
        try {
            String entryName;
            bufferedOutStream = new BufferedOutputStream(new FileOutputStream(outFile), 2048);
            zipOutStream = new ZipOutputStream(bufferedOutStream);
            StringBuilder manifestBuffer = new StringBuilder();
            if (jarMap.hasManifest()) {
                String manifestHeader = manifestMap.getHeader();
                if (manifestHeader.length() != 0) {
                    manifestBuffer.append(manifestHeader);
                }
                Enumeration e = entryNames.elements();
                while (e.hasMoreElements()) {
                    entryName = (String)e.nextElement();
                    String manifestText = manifestMap.get(entryName);
                    if (manifestText == null) continue;
                    manifestBuffer.append(manifestText);
                }
            }
            if (manifestBuffer.length() != 0) {
                byte[] bufferBytes = manifestBuffer.toString().getBytes();
                ZipEntry newManifestEntry = new ZipEntry(MANIFEST_ENTRY_NAME);
                newManifestEntry.setSize(bufferBytes.length);
                try {
                    zipOutStream.putNextEntry(newManifestEntry);
                    zipOutStream.write(bufferBytes);
                    zipOutStream.flush();
                    bufferedOutStream.flush();
                    zipOutStream.closeEntry();
                    bufferedOutStream.flush();
                }
                catch (ZipException e) {
                    System.err.println("Error: ZipException for manifest entry");
                    System.err.println("       " + newManifestEntry.getName() + ":");
                    System.err.println(e.toString());
                    throw e;
                }
                catch (IOException e) {
                    System.err.println("Error: IOException for manifest entry");
                    System.err.println("       " + newManifestEntry.getName() + ":");
                    System.err.println(e.toString());
                    throw e;
                }
            }
            Vector<String> directoriesSoFar = new Vector<String>();
            Enumeration e1 = entryNames.elements();
            while (e1.hasMoreElements()) {
                entryName = (String)e1.nextElement();
                ZipEntry entry = jarMap.getEntry(entryName);
                if (entry == null) {
                    System.err.println("Error: Entry not found in source file: " + entryName);
                    continue;
                }
                Vector dirsToAdd = JarMaker.generateDirEntries(entryName, directoriesSoFar);
                Enumeration e2 = dirsToAdd.elements();
                while (e2.hasMoreElements()) {
                    String dirName = (String)e2.nextElement();
                    ZipEntry dirEntry = new ZipEntry(dirName);
                    dirEntry.setSize(0L);
                    zipOutStream.putNextEntry(dirEntry);
                    zipOutStream.flush();
                    bufferedOutStream.flush();
                    zipOutStream.closeEntry();
                    bufferedOutStream.flush();
                    directoriesSoFar.addElement(dirName);
                }
                inStream = jarMap.getInputStream(entry);
                JarMaker.copyZipEntry(entry, inStream, zipOutStream);
                zipOutStream.flush();
                bufferedOutStream.flush();
                zipOutStream.closeEntry();
                bufferedOutStream.flush();
                inStream.close();
                inStream = null;
                if (!entry.isDirectory()) continue;
                directoriesSoFar.addElement(entryName);
            }
            if (outFile.length() > splitSize) {
                System.err.println("Error: Generated file exceeds specified size:");
                System.err.println("       " + outFile.getAbsolutePath());
            }
        }
        catch (ZipException e) {
            System.err.println("Error: ZipException when writing to file");
            System.err.println("       " + outFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        catch (IOException e) {
            System.err.println("Error: IOException when writing to file");
            System.err.println("       " + outFile.getAbsolutePath() + ":");
            System.err.println(e.toString());
            throw e;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (zipOutStream != null) {
                try {
                    zipOutStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (bufferedOutStream != null) {
                try {
                    bufferedOutStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void main(String[] args) {
        try {
            JarMaker jm = new JarMaker();
            if (jm.parseArgs(args, false)) {
                if (jm.isSplit()) {
                    File srcJar = jm.getSourceJar();
                    int splitSize = jm.getSplitSize();
                    jm.split(srcJar, splitSize);
                } else if (jm.isExtract()) {
                    File srcJar = jm.getSourceJar();
                    File outputDir = jm.getExtractionDirectory();
                    jm.extract(srcJar, outputDir);
                } else {
                    File srcJar = jm.getSourceJar();
                    File destJar = jm.getDestinationJar();
                    jm.makeJar(srcJar, destJar);
                }
            } else {
                System.exit(1);
            }
        }
        catch (Throwable e) {
            System.err.println(e.toString());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    static class ManifestMap {
        private Vector entryList_ = new Vector();
        private Hashtable entryMap_ = new Hashtable();
        private JarMap jarMap_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ManifestMap(JarMap jarMap) throws IOException, ZipException {
            if (jarMap == null) {
                throw new NullPointerException("jarMap");
            }
            this.jarMap_ = jarMap;
            ZipEntry manifestEntry = this.jarMap_.getEntry(JarMaker.MANIFEST_ENTRY_NAME);
            if (manifestEntry == null) {
                System.err.println("Warning: Source file has no manifest.  No manifest will be created.");
            } else {
                try (BufferedReader reader = null;){
                    reader = new BufferedReader(new InputStreamReader(jarMap.getInputStream(manifestEntry)));
                    boolean alreadySawVersion = false;
                    boolean alreadySawRequiredVersion = false;
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (line == null) continue;
                        if (line.startsWith(JarMaker.MANIFEST_NAME_KEYWORD)) {
                            StringBuilder buffer = new StringBuilder();
                            String entryName = line.substring(JarMaker.MANIFEST_NAME_KEYWORD.length()).trim();
                            buffer.append(line);
                            buffer.append('\n');
                            while (reader.ready() && line.length() != 0) {
                                line = reader.readLine();
                                if (line == null) continue;
                                buffer.append(line);
                                buffer.append('\n');
                            }
                            String string = buffer.toString();
                            this.entryMap_.put(entryName, string);
                            this.entryList_.addElement(entryName);
                            continue;
                        }
                        if (!alreadySawVersion && line.startsWith(JarMaker.MANIFEST_VERSION_KEYWORD)) {
                            alreadySawVersion = true;
                            this.entryMap_.put(JarMaker.MANIFEST_VERSION_KEYWORD, line + '\n');
                            continue;
                        }
                        if (alreadySawRequiredVersion || !line.startsWith(JarMaker.MANIFEST_REQVERS_KEYWORD)) continue;
                        alreadySawRequiredVersion = true;
                        this.entryMap_.put(JarMaker.MANIFEST_REQVERS_KEYWORD, line + '\n');
                    }
                }
            }
        }

        void close() {
            this.entryList_.removeAllElements();
            this.entryMap_.clear();
            this.jarMap_ = null;
        }

        boolean contains(String entryName) {
            return this.entryList_.contains(entryName);
        }

        Enumeration elements() {
            return this.entryList_.elements();
        }

        String get(String entryName) {
            return (String)this.entryMap_.get(entryName);
        }

        int getEntrySize(String entryName) {
            int size = 0;
            String entryText = (String)this.entryMap_.get(entryName);
            if (entryText != null) {
                size = entryText.length();
            }
            return size;
        }

        String getHeader() {
            String version = this.get(JarMaker.MANIFEST_VERSION_KEYWORD);
            String reqVersion = this.get(JarMaker.MANIFEST_REQVERS_KEYWORD);
            StringBuilder buffer = new StringBuilder();
            if (version != null) {
                buffer.append(version);
            }
            if (reqVersion != null) {
                buffer.append(reqVersion);
            }
            return buffer.toString();
        }
    }

    static class JarMap {
        private ZipFile zipFile_;
        private ZipEntry manifest_;
        private Vector entryList_ = new Vector();
        private boolean verbose_;
        private int zipfileCommentLength_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JarMap(File jarFile, boolean verbose) throws IOException, ZipException {
            if (jarFile == null) {
                throw new NullPointerException("jarFile");
            }
            if (!jarFile.isFile()) {
                throw new FileNotFoundException(jarFile.getAbsolutePath());
            }
            this.zipFile_ = new ZipFile(jarFile);
            this.verbose_ = verbose;
            this.manifest_ = this.zipFile_.getEntry(JarMaker.MANIFEST_ENTRY_NAME);
            BufferedInputStream inStream = null;
            ZipInputStream zipInStream = null;
            try {
                inStream = new BufferedInputStream(new FileInputStream(jarFile), 2048);
                zipInStream = new ZipInputStream(inStream);
                ZipEntry entry = zipInStream.getNextEntry();
                while (entry != null) {
                    this.entryList_.addElement(entry.getName());
                    entry = zipInStream.getNextEntry();
                }
            }
            finally {
                if (zipInStream != null) {
                    try {
                        zipInStream.close();
                        inStream = null;
                    }
                    catch (Throwable throwable) {}
                }
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.entryList_.removeElement(JarMaker.MANIFEST_ENTRY_NAME);
        }

        void close() {
            if (this.verbose_) {
                System.out.println("Closing source file");
            }
            this.entryList_.removeAllElements();
            this.manifest_ = null;
            if (this.zipFile_ != null) {
                try {
                    this.zipFile_.close();
                }
                catch (Exception e) {
                    System.err.println("Error: While closing source file:");
                    System.err.println(e.toString());
                }
                this.zipFile_ = null;
            }
        }

        boolean contains(String entryName) {
            return this.entryList_.contains(entryName);
        }

        Enumeration elements() {
            return this.entryList_.elements();
        }

        Enumeration entries() {
            return this.zipFile_.entries();
        }

        Vector getEntryNames() {
            return this.entryList_;
        }

        ZipEntry getEntry(String entryName) {
            return this.zipFile_.getEntry(entryName);
        }

        InputStream getInputStream(ZipEntry entry) throws IOException, ZipException {
            return this.zipFile_.getInputStream(entry);
        }

        ZipEntry getManifest() {
            return this.manifest_;
        }

        int getSizeOfZipMetadataPerZip() {
            int result = 0;
            result += 22;
            return result += this.zipfileCommentLength_;
        }

        int getSizeOfZipMetadataPerEntry() throws IOException, UnsupportedEncodingException {
            return 88;
        }

        boolean hasManifest() {
            return this.manifest_ != null;
        }
    }

    class Arguments {
        private Vector unrecognizedArgs_ = new Vector();
        private boolean optionsAreSufficient_;

        Arguments() {
        }

        String[] getUnrecognized() {
            Object[] stringArray = new String[this.unrecognizedArgs_.size()];
            this.unrecognizedArgs_.copyInto(stringArray);
            return stringArray;
        }

        boolean isOptionInfoSufficient() {
            return this.optionsAreSufficient_;
        }

        boolean parse(String[] args, JarMaker jmaker, boolean tolerateUnrecognizedArgs) {
            StringTokenizer st;
            if (args.length == 0) {
                System.err.println("Error: No options were specified.");
                if (!tolerateUnrecognizedArgs) {
                    this.printUsage(System.err);
                }
                return false;
            }
            Vector<String> options = new Vector<String>();
            options.addElement("-source");
            options.addElement("-destination");
            options.addElement("-fileRequired");
            options.addElement("-fileExcluded");
            options.addElement("-additionalFile");
            options.addElement("-additionalFilesDirectory");
            options.addElement("-package");
            options.addElement("-packageExcluded");
            options.addElement("-extract");
            options.addElement("-split");
            options.addElement("-verbose");
            options.addElement("-help");
            Hashtable<String, String> shortcuts = new Hashtable<String, String>();
            shortcuts.put("-s", "-source");
            shortcuts.put("-src", "-source");
            shortcuts.put("-so", "-source");
            shortcuts.put("-d", "-destination");
            shortcuts.put("-dest", "-destination");
            shortcuts.put("-fr", "-fileRequired");
            shortcuts.put("-file", "-fileRequired");
            shortcuts.put("-rf", "-fileRequired");
            shortcuts.put("-req", "-fileRequired");
            shortcuts.put("-required", "-fileRequired");
            shortcuts.put("-requiredfile", "-fileRequired");
            shortcuts.put("-fx", "-fileExcluded");
            shortcuts.put("-fileex", "-fileExcluded");
            shortcuts.put("-filesex", "-fileExcluded");
            shortcuts.put("-af", "-additionalFile");
            shortcuts.put("-additional", "-additionalFile");
            shortcuts.put("-afd", "-additionalFilesDirectory");
            shortcuts.put("-additionalfilesdir", "-additionalFilesDirectory");
            shortcuts.put("-p", "-package");
            shortcuts.put("-px", "-packageExcluded");
            shortcuts.put("-packageex", "-packageExcluded");
            shortcuts.put("-packagesex", "-packageExcluded");
            shortcuts.put("-x", "-extract");
            shortcuts.put("-sp", "-split");
            shortcuts.put("-v", "-verbose");
            shortcuts.put("-h", "-help");
            CommandLineArguments arguments = new CommandLineArguments(args, options, shortcuts);
            boolean destinationWasSpecified = false;
            Vector<String> filesRequired = null;
            Vector<String> filesExcluded = null;
            Vector<File> additionalFiles = null;
            File additionalFilesDir = null;
            Vector<String> packages = null;
            Vector<String> packagesExcluded = null;
            Object extractionDirName = null;
            boolean succeeded = true;
            this.unrecognizedArgs_ = new Vector();
            if (arguments.isOptionSpecified("-verbose")) {
                jmaker.setVerbose(true);
                System.out.print("Arguments parsed by JarMaker:");
                String opts = JarMaker.listCommandOptions(arguments, true);
                System.out.println(opts);
                opts = JarMaker.listCommandOptions(arguments, false);
                if (opts.length() != 0) {
                    System.out.print("Arguments unrecognized by JarMaker: ");
                    System.out.println(opts);
                }
            }
            JarMaker.this.requestedUsageInfo_ = arguments.isOptionSpecified("-help");
            String val = arguments.getOptionValue("");
            if (val != null && val.length() != 0) {
                st = new StringTokenizer(val = val.trim(), " ");
                if (st.countTokens() > 1) {
                    val = st.nextToken();
                    StringBuilder sb = new StringBuilder();
                    while (st.hasMoreTokens()) {
                        sb.append(st.nextToken()).append(" ");
                    }
                    System.err.println("Warning: Ignoring extra arguments: " + sb.toString());
                }
                JarMaker.this.setSourceJar(new File(val));
            }
            if ((val = arguments.getOptionValue("-source")) != null) {
                if (val.length() != 0) {
                    JarMaker.this.setSourceJar(new File(val));
                } else {
                    System.err.println("Warning: No file specified after -source.");
                }
            }
            if ((val = arguments.getOptionValue("-destination")) != null) {
                if (val.length() != 0) {
                    JarMaker.this.setDestinationJar(new File(val));
                    destinationWasSpecified = true;
                } else {
                    System.err.println("Warning: No file specified after -destination.");
                }
            }
            if ((val = arguments.getOptionValue("-fileRequired")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (filesRequired == null) {
                            filesRequired = new Vector<String>(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            filesRequired.addElement(st.nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No file specified after -fileRequired.");
                }
            }
            if ((val = arguments.getOptionValue("-fileExcluded")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (filesExcluded == null) {
                            filesExcluded = new Vector<String>(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            filesExcluded.addElement(st.nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No package specified after -fileExcluded.");
                }
            }
            if ((val = arguments.getOptionValue("-package")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (packages == null) {
                            packages = new Vector<String>(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            packages.addElement(st.nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No package specified after -package.");
                }
            }
            if ((val = arguments.getOptionValue("-packageExcluded")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (packagesExcluded == null) {
                            packagesExcluded = new Vector<String>(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            packagesExcluded.addElement(st.nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No package specified after -packageExcluded.");
                }
            }
            if ((val = arguments.getOptionValue("-additionalFile")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (additionalFiles == null) {
                            additionalFiles = new Vector<File>(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            additionalFiles.addElement(new File(st.nextToken()));
                        }
                    }
                } else {
                    System.err.println("Warning: No file specified after -additionalFile.");
                }
            }
            if ((val = arguments.getOptionValue("-additionalFilesDirectory")) != null) {
                if (val.length() != 0) {
                    additionalFilesDir = new File(val);
                } else {
                    System.err.println("Warning: No directory specified after -additionalFilesDirectory.");
                }
            }
            if ((val = arguments.getOptionValue("-extract")) != null) {
                jmaker.setExtract(true);
                if (val.length() != 0) {
                    jmaker.setExtractionDirectory(new File(val));
                }
            }
            if ((val = arguments.getOptionValue("-split")) != null) {
                jmaker.setSplit(true);
                if (val.length() != 0) {
                    int size = 0;
                    boolean badValue = false;
                    try {
                        size = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Error: Non-integer split size: " + val);
                        succeeded = false;
                        badValue = true;
                    }
                    if (size < 0) {
                        System.err.println("Error: Negative split size: " + val);
                        succeeded = false;
                        badValue = true;
                    }
                    if (!badValue) {
                        jmaker.setSplitSize(size);
                    }
                }
            }
            Enumeration enum1 = arguments.getExtraOptions();
            while (enum1.hasMoreElements()) {
                String optionName = (String)enum1.nextElement();
                String optionVal = arguments.getOptionValue(optionName);
                this.unrecognizedArgs_.addElement(optionName);
                if (optionVal != null) {
                    this.unrecognizedArgs_.addElement(optionVal);
                }
                if (tolerateUnrecognizedArgs) continue;
                String optionWithVal = optionVal == null ? optionName : optionName + " " + optionVal;
                System.err.println("Error: Unrecognized option: " + optionWithVal);
                succeeded = false;
            }
            if (JarMaker.this.requestedUsageInfo_) {
                if (tolerateUnrecognizedArgs) {
                    return succeeded;
                }
                this.printUsage(System.out);
                return false;
            }
            if (jmaker.getSourceJar() == null) {
                System.err.println("Error: Source JAR or ZIP file was not specified.");
                succeeded = false;
            } else if (jmaker.isSplit()) {
                this.optionsAreSufficient_ = true;
                jmaker.setExtract(false);
                if (destinationWasSpecified || filesRequired != null || filesExcluded != null || packages != null || packagesExcluded != null || additionalFiles != null) {
                    System.err.println("Warning: When -split is specified, all other options are ignored, except -source, and -verbose.");
                }
            } else {
                if (filesRequired == null && filesExcluded == null && additionalFiles == null && packages == null && packagesExcluded == null && !jmaker.isExtract()) {
                    if (this.unrecognizedArgs_.size() == 0 || !tolerateUnrecognizedArgs) {
                        System.err.println("Error: Need to specify more options.");
                        succeeded = false;
                    }
                } else {
                    this.optionsAreSufficient_ = true;
                }
                if (jmaker.isExtract() && (destinationWasSpecified || additionalFiles != null)) {
                    System.err.println("Warning: When -extract is specified, the following options are ignored: -destination, -additionalFile, and -additionalFilesDirectory.");
                }
                if (!destinationWasSpecified) {
                    File destJar = JarMaker.setupDefaultDestinationJarFile(jmaker.getSourceJar());
                    jmaker.setDestinationJar(destJar);
                }
                if (additionalFilesDir == null) {
                    additionalFilesDir = new File(System.getProperty("user.dir"));
                }
                if (additionalFiles != null) {
                    JarMaker.this.setAdditionalFiles(additionalFiles, additionalFilesDir);
                }
                if (filesRequired != null) {
                    JarMaker.this.setFilesRequired(filesRequired);
                }
                if (filesExcluded != null) {
                    JarMaker.this.setFilesExcluded(filesExcluded);
                }
                if (packages != null) {
                    if (packages.size() > 0) {
                        JarMaker.this.setPackages(packages);
                    } else {
                        succeeded = false;
                    }
                }
                if (packagesExcluded != null) {
                    if (packagesExcluded.size() > 0) {
                        JarMaker.this.setPackagesExcluded(packagesExcluded);
                    } else {
                        succeeded = false;
                    }
                }
            }
            if (!tolerateUnrecognizedArgs && !succeeded) {
                this.printUsage(System.err);
            }
            return succeeded;
        }

        private void printUsage(PrintStream output) {
            output.println("");
            output.println("Usage: ");
            output.println("");
            output.println("  JarMaker -source sourceJarFile");
            output.println("           [-destination jarFile]");
            output.println("           [-fileRequired entry1[,entry2[...]]]");
            output.println("           [-fileExcluded entry1[,entry2[...]]]");
            output.println("           [-additionalFile file1[,file2[...]]]");
            output.println("           [-additionalFilesDirectory directory");
            output.println("           [-package pkg1[,pkg2[...]]]");
            output.println("           [-packageExcluded pkg1[,pkg2[...]]]");
            output.println("           [-extract [directory]]");
            output.println("           [-split [kilobytes]]");
            output.println("           [-verbose]");
            output.println("           [-help]");
            output.println("");
            output.println("At least one of the following options must be specified: ");
            output.println("-fileRequired, -fileExcluded, -additionalFile, -package, -packageExcluded, -extract, -split");
        }
    }
}

