/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;

@InternalApi
public class FilterMarkerRowsCallable<RowT>
extends ServerStreamingCallable<ReadRowsRequest, RowT> {
    private final ServerStreamingCallable<ReadRowsRequest, RowT> innerCallable;
    private final RowAdapter<RowT> rowAdapter;

    public FilterMarkerRowsCallable(ServerStreamingCallable<ReadRowsRequest, RowT> inner, RowAdapter<RowT> rowAdapter) {
        this.rowAdapter = rowAdapter;
        this.innerCallable = inner;
    }

    public void call(ReadRowsRequest request, ResponseObserver<RowT> responseObserver, ApiCallContext context) {
        FilteringResponseObserver innerObserver = new FilteringResponseObserver(responseObserver);
        this.innerCallable.call((Object)request, (ResponseObserver)innerObserver, context);
    }

    private class FilteringResponseObserver
    extends SafeResponseObserver<RowT> {
        private final ResponseObserver<RowT> outerObserver;
        private StreamController innerController;
        private boolean autoFlowControl;

        FilteringResponseObserver(ResponseObserver<RowT> outerObserver) {
            super(outerObserver);
            this.autoFlowControl = true;
            this.outerObserver = outerObserver;
        }

        @Override
        protected void onStartImpl(final StreamController controller) {
            this.innerController = controller;
            this.outerObserver.onStart(new StreamController(){

                public void cancel() {
                    controller.cancel();
                }

                public void disableAutoInboundFlowControl() {
                    FilteringResponseObserver.this.autoFlowControl = false;
                    controller.disableAutoInboundFlowControl();
                }

                public void request(int count) {
                    controller.request(count);
                }
            });
        }

        @Override
        protected void onResponseImpl(RowT response) {
            if (FilterMarkerRowsCallable.this.rowAdapter.isScanMarkerRow(response)) {
                if (!this.autoFlowControl) {
                    this.innerController.request(1);
                }
            } else {
                this.outerObserver.onResponse(response);
            }
        }

        @Override
        protected void onErrorImpl(Throwable t) {
            this.outerObserver.onError(t);
        }

        @Override
        protected void onCompleteImpl() {
            this.outerObserver.onComplete();
        }
    }
}

