/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.truncatetables;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.truncatetables.TruncateTableItem;

@Action(id="TRUNCATE_TABLES", name="i18n::ActionTruncateTables.Name", description="i18n::ActionTruncateTables.Description", image="TruncateTables.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionTruncateTables.keyword"}, documentationUrl="/workflow/actions/truncatetables.html")
public class ActionTruncateTables
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionTruncateTables.class;
    @HopMetadataProperty(key="arg_from_previous")
    private boolean argFromPrevious = false;
    @HopMetadataProperty(hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection = null;
    @HopMetadataProperty(key="field", groupKey="fields")
    private List<TruncateTableItem> items;
    private int nrErrors = 0;
    private int nrSuccess = 0;
    private boolean continueProcess = true;

    public ActionTruncateTables(String name) {
        super(name, "");
    }

    public ActionTruncateTables() {
        this("");
        this.items = new ArrayList<TruncateTableItem>();
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public List<TruncateTableItem> getItems() {
        return this.items;
    }

    public void setItems(List<TruncateTableItem> items) {
        this.items = items;
    }

    private boolean truncateTables(String tableName, String schemaName, Database db) {
        boolean retval = false;
        try {
            if (db.checkTableExists(schemaName, tableName)) {
                if (!Utils.isEmpty((CharSequence)schemaName)) {
                    db.truncateTable(schemaName, tableName);
                } else {
                    db.truncateTable(tableName);
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Log.TableTruncated", (String[])new String[]{tableName}));
                }
                retval = true;
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Error.CanNotFindTable", (String[])new String[]{tableName}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Error.CanNotTruncateTables", (String[])new String[]{tableName, e.toString()}));
        }
        return retval;
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        result.setResult(true);
        this.nrErrors = 0;
        this.continueProcess = true;
        this.nrSuccess = 0;
        if (this.argFromPrevious) {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionTruncateTables.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
            }
            if (rows.isEmpty()) {
                return result;
            }
        }
        if (this.connection != null) {
            try (Database db = new Database((ILoggingObject)this, (IVariables)this, this.getParentWorkflowMeta().findDatabase(this.connection, this.getVariables()));){
                db.connect();
                if (this.argFromPrevious && rows != null) {
                    for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped() && this.continueProcess; ++iteration) {
                        resultRow = (RowMetaAndData)rows.get(iteration);
                        String tableNamePrevious = resultRow.getString(0, null);
                        String schemaNamePrevious = resultRow.getString(1, null);
                        if (!Utils.isEmpty((CharSequence)tableNamePrevious)) {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionTruncateTables.ProcessingRow", (String[])new String[]{tableNamePrevious, schemaNamePrevious}));
                            }
                            if (this.truncateTables(tableNamePrevious, schemaNamePrevious, db)) {
                                this.updateSuccess();
                                continue;
                            }
                            this.updateErrors();
                            continue;
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.RowEmpty", (String[])new String[0]));
                    }
                } else if (!Utils.isEmpty(this.items)) {
                    for (int i = 0; i < this.items.size() && !this.parentWorkflow.isStopped() && this.continueProcess; ++i) {
                        TruncateTableItem tableItem = this.items.get(i);
                        String realTableName = this.resolve(tableItem.getTableName());
                        String realSchemaName = this.resolve(tableItem.getSchemaName());
                        if (!Utils.isEmpty((CharSequence)realTableName)) {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionTruncateTables.ProcessingArg", (String[])new String[]{realTableName, realSchemaName}));
                            }
                            if (this.truncateTables(realTableName, realSchemaName, db)) {
                                this.updateSuccess();
                                continue;
                            }
                            this.updateErrors();
                            continue;
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.ArgEmpty", (String[])new String[]{realTableName, realSchemaName}));
                    }
                }
            }
            catch (Exception dbe) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.NoDbConnection", (String[])new String[0]));
        }
        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesDeleted((long)this.nrSuccess);
        result.setResult(this.nrErrors == 0);
        return result;
    }

    private void updateErrors() {
        ++this.nrErrors;
        this.continueProcess = false;
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty(this.items)) {
            ResourceReference reference = null;
            for (TruncateTableItem item : this.items) {
                String filename = this.resolve(item.getTableName());
                if (reference == null) {
                    reference = new ResourceReference((IResourceHolder)this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }
}

