/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.UUID;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class UuidSyntaxChecker
extends SyntaxChecker {
    public static final UuidSyntaxChecker INSTANCE = new UuidSyntaxChecker("1.3.6.1.1.16.1");

    private UuidSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        if (value instanceof UUID) {
            return true;
        }
        if (!(value instanceof String)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        return Strings.isValidUuid((String)((String)value));
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<UuidSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.1.16.1");
        }

        @Override
        public UuidSyntaxChecker build() {
            return new UuidSyntaxChecker(this.oid);
        }
    }
}

