/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.jdbc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnContainer;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcTableMeta;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.jetbrains.annotations.Nullable;

public class JdbcMetadataCatalog {
    private static final String PK = "PK_";
    private final ClockService clockService;
    private final SchemaSyncService schemaSyncService;
    private final CatalogService catalogService;
    private static final Comparator<JdbcTableMeta> byTblTypeThenSchemaThenTblName = Comparator.comparing(JdbcTableMeta::tableType).thenComparing(JdbcTableMeta::schemaName).thenComparing(JdbcTableMeta::tableName);
    private static final Comparator<JdbcPrimaryKeyMeta> bySchemaThenTblThenKey = Comparator.comparing(JdbcPrimaryKeyMeta::schemaName).thenComparing(JdbcPrimaryKeyMeta::tableName).thenComparing(JdbcPrimaryKeyMeta::name);

    public JdbcMetadataCatalog(ClockService clockService, SchemaSyncService schemaSyncService, CatalogService catalogService) {
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.catalogService = catalogService;
    }

    public CompletableFuture<Collection<JdbcPrimaryKeyMeta>> getPrimaryKeys(String schemaNamePtrn, String tblNamePtrn) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        return this.schemasAtNow().thenApply(schemas -> schemas.stream().filter(schema -> JdbcMetadataCatalog.matches(schema.name(), schemaNameRegex)).flatMap(schema -> Arrays.stream(schema.tables()).filter(table -> JdbcMetadataCatalog.matches(table.name(), tlbNameRegex)).map(table -> JdbcMetadataCatalog.createPrimaryKeyMeta(schema.name(), table))).sorted(bySchemaThenTblThenKey).collect(Collectors.toList()));
    }

    private CompletableFuture<Collection<CatalogSchemaDescriptor>> schemasAtNow() {
        HybridTimestamp now = this.clockService.now();
        return this.schemaSyncService.waitForMetadataCompleteness(now).thenApply(unused -> this.catalogService.activeCatalog(now.longValue()).schemas());
    }

    public CompletableFuture<List<JdbcTableMeta>> getTablesMeta(String schemaNamePtrn, String tblNamePtrn, @Nullable String[] tblTypes) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        Collection<CatalogObjectType> includedObjectTypes = JdbcMetadataCatalog.resolveObjectTypes(tblTypes);
        return this.schemasAtNow().thenApply(schemas -> schemas.stream().filter(schema -> JdbcMetadataCatalog.matches(schema.name(), schemaNameRegex)).flatMap(schema -> includedObjectTypes.stream().flatMap(tblType -> JdbcMetadataCatalog.getCatalogObjects(schema, tblType).filter(desc -> JdbcMetadataCatalog.matches(desc.name(), tlbNameRegex)).map(desc -> new JdbcTableMeta(schema.name(), desc.name(), tblType.name())))).sorted(byTblTypeThenSchemaThenTblName).collect(Collectors.toList()));
    }

    private static Stream<CatalogObjectDescriptor> getCatalogObjects(CatalogSchemaDescriptor schema, CatalogObjectType type) {
        switch (type.ordinal()) {
            case 0: {
                return Arrays.stream(schema.tables());
            }
            case 1: {
                return Arrays.stream(schema.systemViews());
            }
        }
        throw new IllegalArgumentException("Unsupported object type: " + String.valueOf((Object)type));
    }

    private static Collection<CatalogObjectType> resolveObjectTypes(@Nullable String[] tblTypes) {
        if (tblTypes == null) {
            return EnumSet.allOf(CatalogObjectType.class);
        }
        EnumSet<CatalogObjectType> types = EnumSet.noneOf(CatalogObjectType.class);
        for (String tblType : tblTypes) {
            if ("%".equals(tblType)) {
                return EnumSet.allOf(CatalogObjectType.class);
            }
            types.add(CatalogObjectType.valueOf(tblType));
        }
        return types;
    }

    public CompletableFuture<Collection<JdbcColumnMeta>> getColumnsMeta(String schemaNamePtrn, String tblNamePtrn, String colNamePtrn) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        String colNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(colNamePtrn);
        return this.schemasAtNow().thenApply(schemas -> schemas.stream().filter(schema -> JdbcMetadataCatalog.matches(schema.name(), schemaNameRegex)).sorted(Comparator.comparing(CatalogObjectDescriptor::name)).flatMap(schema -> Stream.concat(Arrays.stream(schema.systemViews()), Arrays.stream(schema.tables())).filter(desc -> JdbcMetadataCatalog.matches(desc.name(), tlbNameRegex)).sorted(Comparator.comparing(rec$ -> ((CatalogColumnContainer)rec$).name())).flatMap(desc -> ((CatalogColumnContainer)desc).columns().stream().filter(col -> JdbcMetadataCatalog.matches(col.name(), colNameRegex)).map(col -> JdbcMetadataCatalog.createColumnMeta(schema.name(), desc.name(), col)))).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public CompletableFuture<Collection<String>> getSchemasMeta(String schemaNamePtrn) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        return this.schemasAtNow().thenApply(schemas -> schemas.stream().map(CatalogObjectDescriptor::name).filter(name -> JdbcMetadataCatalog.matches(name, schemaNameRegex)).collect(Collectors.toCollection(TreeSet::new)));
    }

    private static JdbcPrimaryKeyMeta createPrimaryKeyMeta(String schemaName, CatalogTableDescriptor tbl) {
        String keyName = PK + tbl.name();
        List keyColNames = List.copyOf(tbl.primaryKeyColumns());
        return new JdbcPrimaryKeyMeta(schemaName, tbl.name(), keyName, keyColNames);
    }

    private static JdbcColumnMeta createColumnMeta(String schemaName, String tblName, CatalogTableColumnDescriptor col) {
        return new JdbcColumnMeta(col.name(), schemaName, tblName, col.name(), col.type(), JdbcMetadataCatalog.resolvePrecision(col), JdbcMetadataCatalog.resolveScale(col), col.nullable());
    }

    private static boolean matches(@Nullable String str, @Nullable String sqlPtrn) {
        if (str == null) {
            return false;
        }
        if (sqlPtrn == null) {
            return true;
        }
        return str.matches(sqlPtrn);
    }

    @Nullable
    private static String translateSqlWildcardsToRegex(String sqlPtrn) {
        if (sqlPtrn == null || sqlPtrn.isEmpty()) {
            return sqlPtrn;
        }
        Object toRegex = " " + sqlPtrn;
        toRegex = ((String)toRegex).replaceAll("([\\[\\]{}()*+?.\\\\\\\\^$|])", "\\\\$1");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)%", "$1$2.*");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)_", "$1$2.");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])(\\\\\\\\(?>\\\\\\\\\\\\\\\\)*\\\\\\\\)*\\\\\\\\([_|%])", "$1$2$3");
        return ((String)toRegex).substring(1);
    }

    private static int resolvePrecision(CatalogTableColumnDescriptor column) {
        switch (column.type()) {
            case INT8: {
                return 3;
            }
            case INT16: {
                return 5;
            }
            case INT32: {
                return 10;
            }
            case INT64: {
                return 19;
            }
            case FLOAT: 
            case DOUBLE: {
                return 15;
            }
            case BOOLEAN: 
            case UUID: 
            case DATE: {
                return -1;
            }
            case DECIMAL: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return column.precision();
            }
            case BYTE_ARRAY: 
            case STRING: {
                return column.length();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(column.type()));
    }

    private static int resolveScale(CatalogTableColumnDescriptor column) {
        switch (column.type()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return 0;
            }
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case UUID: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: 
            case BYTE_ARRAY: 
            case STRING: {
                return Integer.MIN_VALUE;
            }
            case DECIMAL: {
                return column.scale();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(column.type()));
    }

    private static enum CatalogObjectType {
        TABLE,
        VIEW;

    }
}

