/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class CatalogSortedIndexDescriptorSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class SortedIndexDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogSortedIndexDescriptor> {
        SortedIndexDescriptorSerializerV2() {
        }

        @Override
        public CatalogSortedIndexDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            int tableId = input.readVarIntAsInt();
            boolean unique = input.readBoolean();
            CatalogIndexStatus status = CatalogIndexStatus.forId(input.readByte());
            boolean isCreatedWithTable = input.readBoolean();
            List columns = input.readObjectCollection(in -> {
                String columnName = input.readUTF();
                CatalogColumnCollation collation = CatalogColumnCollation.unpack(input.readByte());
                return new CatalogIndexColumnDescriptor(columnName, collation);
            }, ArrayList::new);
            return new CatalogSortedIndexDescriptor(id, name, tableId, unique, status, columns, updateTimestamp, isCreatedWithTable);
        }

        @Override
        public void writeTo(CatalogSortedIndexDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeVarInt(descriptor.tableId());
            output.writeBoolean(descriptor.unique());
            output.writeByte(descriptor.status().id());
            output.writeBoolean(descriptor.isCreatedWithTable());
            output.writeObjectCollection((out, elem) -> {
                output.writeUTF(elem.name());
                output.writeByte(CatalogColumnCollation.pack(elem.collation()));
            }, descriptor.columns());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class SortedIndexDescriptorSerializerV1
    implements CatalogObjectSerializer<CatalogSortedIndexDescriptor> {
        private final CatalogEntrySerializerProvider serializers;
        private final IndexColumnDescriptorSerializerV1 indexColumnSerializer = new IndexColumnDescriptorSerializerV1();

        public SortedIndexDescriptorSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogSortedIndexDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            input.readVarInt();
            int tableId = input.readVarIntAsInt();
            boolean unique = input.readBoolean();
            CatalogIndexStatus status = CatalogIndexStatus.forId(input.readByte());
            boolean isCreatedWithTable = input.readBoolean();
            List<CatalogIndexColumnDescriptor> columns = CatalogSerializationUtils.readList(this.indexColumnSerializer, input);
            return new CatalogSortedIndexDescriptor(id, name, tableId, unique, status, columns, CatalogManager.INITIAL_TIMESTAMP, isCreatedWithTable);
        }

        @Override
        public void writeTo(CatalogSortedIndexDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeVarInt(descriptor.tableId());
            output.writeBoolean(descriptor.unique());
            output.writeByte(descriptor.status().id());
            output.writeBoolean(descriptor.isCreatedWithTable());
            CatalogSerializationUtils.writeList(descriptor.columns(), this.indexColumnSerializer, output);
        }

        private static class IndexColumnDescriptorSerializerV1
        implements CatalogObjectSerializer<CatalogIndexColumnDescriptor> {
            private IndexColumnDescriptorSerializerV1() {
            }

            @Override
            public CatalogIndexColumnDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
                String name = input.readUTF();
                CatalogColumnCollation collation = CatalogColumnCollation.unpack(input.readByte());
                return new CatalogIndexColumnDescriptor(name, collation);
            }

            @Override
            public void writeTo(CatalogIndexColumnDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
                output.writeUTF(descriptor.name());
                output.writeByte(CatalogColumnCollation.pack(descriptor.collation()));
            }
        }
    }
}

