/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.property;

import java.lang.reflect.Field;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.property.QueryPropertyAccessor;

public class QueryFieldAccessor
implements QueryPropertyAccessor {
    private final Field fld;

    public QueryFieldAccessor(Field fld) {
        fld.setAccessible(true);
        this.fld = fld;
    }

    @Override
    public Object getValue(Object obj) throws IgniteCheckedException {
        try {
            return this.fld.get(obj);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to get field value", e);
        }
    }

    @Override
    public void setValue(Object obj, Object newVal) throws IgniteCheckedException {
        try {
            this.fld.set(obj, newVal);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to set field value", e);
        }
    }

    @Override
    public String getPropertyName() {
        return this.fld.getName();
    }

    @Override
    public Class<?> getType() {
        return this.fld.getType();
    }
}

