/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.closure;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.closure.ClosureQueue;
import org.apache.ignite3.raft.jraft.closure.TaskClosure;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.option.NodeOptions;
import org.apache.ignite3.raft.jraft.util.OnlyForTest;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.Utils;

public class ClosureQueueImpl
implements ClosureQueue {
    private static final IgniteLogger LOG = Loggers.forClass(ClosureQueueImpl.class);
    private final Lock lock = new ReentrantLock();
    private final NodeOptions options;
    private long firstIndex = 0L;
    private LinkedList<Closure> queue = new LinkedList();

    @OnlyForTest
    public long getFirstIndex() {
        return this.firstIndex;
    }

    @OnlyForTest
    public LinkedList<Closure> getQueue() {
        return this.queue;
    }

    public ClosureQueueImpl(NodeOptions options) {
        this.options = options;
    }

    @Override
    public void clear() {
        LinkedList<Closure> savedQueue;
        this.lock.lock();
        try {
            this.firstIndex = 0L;
            savedQueue = this.queue;
            this.queue = new LinkedList();
        }
        finally {
            this.lock.unlock();
        }
        Status status = new Status(RaftError.EPERM, "Leader stepped down", new Object[0]);
        Utils.runInThread(this.options.getCommonExecutor(), () -> {
            for (Closure done : savedQueue) {
                if (done == null) continue;
                done.run(status);
            }
        });
    }

    @Override
    public void resetFirstIndex(long firstIndex) {
        this.lock.lock();
        try {
            Requires.requireTrue(this.queue.isEmpty(), "Queue is not empty.");
            this.firstIndex = firstIndex;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void appendPendingClosure(Closure closure) {
        this.lock.lock();
        try {
            this.queue.add(closure);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long popClosureUntil(long endIndex, List<Closure> closures) {
        return this.popClosureUntil(endIndex, closures, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long popClosureUntil(long endIndex, List<Closure> closures, List<TaskClosure> taskClosures) {
        closures.clear();
        if (taskClosures != null) {
            taskClosures.clear();
        }
        this.lock.lock();
        try {
            long outFirstIndex;
            int queueSize = this.queue.size();
            if (queueSize == 0 || endIndex < this.firstIndex) {
                long l = endIndex + 1L;
                return l;
            }
            if (endIndex > this.firstIndex + (long)queueSize - 1L) {
                LOG.error("Invalid endIndex={}, firstIndex={}, closureQueueSize={}", endIndex, this.firstIndex, queueSize);
                long l = -1L;
                return l;
            }
            for (long i = outFirstIndex = this.firstIndex; i <= endIndex; ++i) {
                Closure closure = this.queue.pollFirst();
                if (taskClosures != null && closure instanceof TaskClosure) {
                    taskClosures.add((TaskClosure)closure);
                }
                closures.add(closure);
            }
            this.firstIndex = endIndex + 1L;
            long l = outFirstIndex;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

