/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict;

import java.util.Objects;
import org.apache.bifromq.sysprops.props.SessionRegisterNumber;
import org.apache.bifromq.type.ClientInfo;

public class SessionRegisterKeyUtil {
    private static final int SESSION_REGISTER_NUM = (Integer)SessionRegisterNumber.INSTANCE.get();

    public static String toRegisterKey(ClientInfo owner) {
        return SessionRegisterKeyUtil.toRegisterKey(owner.getTenantId(), owner.getMetadataOrDefault("userId", ""), owner.getMetadataOrDefault("clientId", ""));
    }

    public static String toRegisterKey(String tenantId, String userId, String clientId) {
        int key = Objects.hash(userId, clientId) % SESSION_REGISTER_NUM;
        if (key < 0) {
            key += SESSION_REGISTER_NUM;
        }
        return tenantId + "_" + key;
    }

    public static String parseTenantId(String registerKey) {
        int index = registerKey.indexOf(95);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid register key: " + registerKey);
        }
        return registerKey.substring(0, index);
    }
}

