/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.InnerTable;
import org.apache.paimon.table.sink.StreamTableCommit;
import org.apache.paimon.table.sink.StreamTableWrite;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.sink.WriteSelector;
import org.apache.paimon.types.RowType;

public class StreamWriteBuilderImpl
implements StreamWriteBuilder {
    private static final long serialVersionUID = 1L;
    private final InnerTable table;
    private String commitUser;

    public StreamWriteBuilderImpl(InnerTable table) {
        this.table = table;
        this.commitUser = CoreOptions.createCommitUser(new Options(table.options()));
    }

    @Override
    public String tableName() {
        return this.table.name();
    }

    @Override
    public RowType rowType() {
        return this.table.rowType();
    }

    @Override
    public Optional<WriteSelector> newWriteSelector() {
        return this.table.newWriteSelector();
    }

    @Override
    public String commitUser() {
        return this.commitUser;
    }

    @Override
    public StreamWriteBuilder withCommitUser(String commitUser) {
        this.commitUser = commitUser;
        return this;
    }

    @Override
    public StreamTableWrite newWrite() {
        return this.table.newWrite(this.commitUser);
    }

    @Override
    public StreamTableCommit newCommit() {
        return this.table.newCommit(this.commitUser).ignoreEmptyCommit(false);
    }
}

