/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.EmptyResultStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.table.source.snapshot.TimeTravelUtil;
import org.apache.paimon.tag.Tag;
import org.apache.paimon.tag.TagPeriodHandler;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalDiffStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalDiffStartingScanner.class);
    private final Snapshot start;
    private final Snapshot end;

    public IncrementalDiffStartingScanner(SnapshotManager snapshotManager, Snapshot start, Snapshot end) {
        super(snapshotManager);
        this.start = start;
        this.end = end;
        this.startingSnapshotId = start.id();
        TimeTravelUtil.checkRescaleBucketForIncrementalDiffQuery(new SchemaManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch()), start, end);
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader reader) {
        return StartingScanner.fromPlan(reader.withSnapshot(this.end).readIncrementalDiff(this.start));
    }

    public static StartingScanner betweenTags(Tag startTag, Tag endTag, SnapshotManager snapshotManager, Pair<String, String> incrementalBetween) {
        Snapshot start = startTag.trimToSnapshot();
        Snapshot end = endTag.trimToSnapshot();
        LOG.info("{} start and end are parsed to tag with snapshot id {} to {}.", new Object[]{CoreOptions.INCREMENTAL_BETWEEN.key(), start.id(), end.id()});
        Preconditions.checkArgument(end.id() >= start.id(), "Tag end %s with snapshot id %s should be >= tag start %s with snapshot id %s", incrementalBetween.getRight(), end.id(), incrementalBetween.getLeft(), start.id());
        if (start.id() == end.id()) {
            return new EmptyResultStartingScanner(snapshotManager);
        }
        return new IncrementalDiffStartingScanner(snapshotManager, start, end);
    }

    public static StartingScanner betweenSnapshotIds(long startId, long endId, SnapshotManager snapshotManager) {
        Snapshot start = snapshotManager.snapshot(startId);
        Snapshot end = snapshotManager.snapshot(endId);
        return new IncrementalDiffStartingScanner(snapshotManager, start, end);
    }

    public static IncrementalDiffStartingScanner betweenTimestamps(long startTimestamp, long endTimestamp, SnapshotManager snapshotManager) {
        Snapshot endSnapshot;
        Snapshot startSnapshot = snapshotManager.earlierOrEqualTimeMills(startTimestamp);
        if (startSnapshot == null) {
            startSnapshot = snapshotManager.earliestSnapshot();
        }
        if ((endSnapshot = snapshotManager.earlierOrEqualTimeMills(endTimestamp)) == null) {
            endSnapshot = snapshotManager.latestSnapshot();
        }
        return new IncrementalDiffStartingScanner(snapshotManager, startSnapshot, endSnapshot);
    }

    public static AbstractStartingScanner toEndAutoTag(SnapshotManager snapshotManager, String endTagName, CoreOptions options) {
        TagPeriodHandler periodHandler = TagPeriodHandler.create(options);
        Preconditions.checkArgument(periodHandler.isAutoTag(endTagName), "Specified tag '%s' is not an auto-created tag.", endTagName);
        TagManager tagManager = new TagManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch());
        Optional<Tag> endTag = tagManager.get(endTagName);
        if (!endTag.isPresent()) {
            LOG.info("Tag {} doesn't exist.", (Object)endTagName);
            return new EmptyResultStartingScanner(snapshotManager);
        }
        Snapshot end = endTag.get().trimToSnapshot();
        LocalDateTime endTagTime = periodHandler.tagToTime(endTagName);
        List previousTags = tagManager.tagObjects().stream().filter(p -> periodHandler.isAutoTag((String)p.getRight())).map(p -> Pair.of(p.getLeft(), periodHandler.tagToTime((String)p.getRight()))).filter(p -> ((LocalDateTime)p.getRight()).isBefore(endTagTime)).sorted((tag1, tag2) -> ((LocalDateTime)tag2.getRight()).compareTo((ChronoLocalDateTime)tag1.getRight())).collect(Collectors.toList());
        if (previousTags.isEmpty()) {
            LOG.info("Didn't found earlier tags for {}.", (Object)endTagName);
            return new EmptyResultStartingScanner(snapshotManager);
        }
        LOG.info("Found start tag {} .", (Object)periodHandler.timeToTag((LocalDateTime)((Pair)previousTags.get(0)).getRight()));
        Snapshot start = ((Tag)((Pair)previousTags.get(0)).getLeft()).trimToSnapshot();
        return new IncrementalDiffStartingScanner(snapshotManager, start, end);
    }
}

