/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.utils.ExceptionUtils;
import org.apache.paimon.utils.IOUtils;

@Public
public interface CloseableIterator<T>
extends Iterator<T>,
AutoCloseable {
    public static final CloseableIterator<?> EMPTY_INSTANCE = CloseableIterator.adapterForIterator(Collections.emptyIterator());

    @Nonnull
    public static <T> CloseableIterator<T> adapterForIterator(@Nonnull Iterator<T> iterator2) {
        return CloseableIterator.adapterForIterator(iterator2, () -> {});
    }

    public static <T> CloseableIterator<T> adapterForIterator(@Nonnull Iterator<T> iterator2, AutoCloseable close) {
        return new IteratorAdapter<T>(iterator2, close);
    }

    public static <T> CloseableIterator<T> fromList(final List<T> list, final Consumer<T> closeNotConsumed) {
        return new CloseableIterator<T>(){
            private final Deque<T> stack;
            {
                this.stack = new ArrayDeque(list);
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public T next() {
                return this.stack.poll();
            }

            @Override
            public void close() throws Exception {
                Exception exception = null;
                for (Object el : this.stack) {
                    try {
                        closeNotConsumed.accept(el);
                    }
                    catch (Exception e) {
                        exception = ExceptionUtils.firstOrSuppressed(e, exception);
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        };
    }

    public static <T> CloseableIterator<T> flatten(final CloseableIterator<T> ... iterators) {
        return new CloseableIterator<T>(){
            private final Queue<CloseableIterator<T>> queue;
            {
                this.queue = this.removeEmptyHead(new LinkedList(Arrays.asList(iterators)));
            }

            private Queue<CloseableIterator<T>> removeEmptyHead(Queue<CloseableIterator<T>> queue) {
                while (!queue.isEmpty() && !queue.peek().hasNext()) {
                    queue.poll();
                }
                return queue;
            }

            @Override
            public boolean hasNext() {
                this.removeEmptyHead(this.queue);
                return !this.queue.isEmpty();
            }

            @Override
            public T next() {
                this.removeEmptyHead(this.queue);
                return this.queue.peek().next();
            }

            @Override
            public void close() throws Exception {
                IOUtils.closeAll(iterators);
            }
        };
    }

    public static <T> CloseableIterator<T> empty() {
        return EMPTY_INSTANCE;
    }

    public static <T> CloseableIterator<T> ofElements(Consumer<T> closeNotConsumed, T ... elements) {
        return CloseableIterator.fromList(Arrays.asList(elements), closeNotConsumed);
    }

    public static <E> CloseableIterator<E> ofElement(final E element, final Consumer<E> closeIfNotConsumed) {
        return new CloseableIterator<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                this.hasNext = false;
                return element;
            }

            @Override
            public void close() {
                if (this.hasNext) {
                    closeIfNotConsumed.accept(element);
                }
            }
        };
    }

    public static final class IteratorAdapter<E>
    implements CloseableIterator<E> {
        @Nonnull
        private final Iterator<E> delegate;
        private final AutoCloseable close;

        IteratorAdapter(@Nonnull Iterator<E> delegate, AutoCloseable close) {
            this.delegate = delegate;
            this.close = close;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.delegate.forEachRemaining(action);
        }

        @Override
        public void close() throws Exception {
            this.close.close();
        }
    }
}

