/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class HostsFileReader {
    private static final Log LOG = LogFactory.getLog(HostsFileReader.class);
    private final AtomicReference<HostDetails> current;

    public HostsFileReader(String inFile, String exFile) throws IOException {
        HostDetails hostDetails = new HostDetails(inFile, Collections.emptySet(), exFile, Collections.emptySet());
        this.current = new AtomicReference<HostDetails>(hostDetails);
        this.refresh(inFile, exFile);
    }

    @InterfaceAudience.Private
    public HostsFileReader(String includesFile, InputStream inFileInputStream, String excludesFile, InputStream exFileInputStream) throws IOException {
        HostDetails hostDetails = new HostDetails(includesFile, Collections.emptySet(), excludesFile, Collections.emptySet());
        this.current = new AtomicReference<HostDetails>(hostDetails);
        this.refresh(inFileInputStream, exFileInputStream);
    }

    public static void readFileToSet(String type, String filename, Set<String> set) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToSetWithFileInputStream(type, filename, fis, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static void readFileToSetWithFileInputStream(String type, String filename, InputStream fileInputStream, Set<String> set) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            block3: while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = nodes[i].trim();
                    if (nodes[i].startsWith("#")) continue block3;
                    if (nodes[i].isEmpty()) continue;
                    LOG.info("Adding a node \"" + nodes[i] + "\" to the list of " + type + " hosts from " + filename);
                    set.add(nodes[i]);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fileInputStream.close();
        }
    }

    public void refresh() throws IOException {
        HostDetails hostDetails = this.current.get();
        this.refresh(hostDetails.includesFile, hostDetails.excludesFile);
    }

    public void refresh(String includesFile, String excludesFile) throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        HostDetails oldDetails = this.current.get();
        Set<String> newIncludes = oldDetails.includes;
        Set<String> newExcludes = oldDetails.excludes;
        if (includesFile != null && !includesFile.isEmpty()) {
            newIncludes = new HashSet<String>();
            HostsFileReader.readFileToSet("included", includesFile, newIncludes);
            newIncludes = Collections.unmodifiableSet(newIncludes);
        }
        if (excludesFile != null && !excludesFile.isEmpty()) {
            newExcludes = new HashSet<String>();
            HostsFileReader.readFileToSet("excluded", excludesFile, newExcludes);
            newExcludes = Collections.unmodifiableSet(newExcludes);
        }
        HostDetails newDetails = new HostDetails(includesFile, newIncludes, excludesFile, newExcludes);
        this.current.set(newDetails);
    }

    @InterfaceAudience.Private
    public void refresh(InputStream inFileInputStream, InputStream exFileInputStream) throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        HostDetails oldDetails = this.current.get();
        Set<String> newIncludes = oldDetails.includes;
        Set<String> newExcludes = oldDetails.excludes;
        if (inFileInputStream != null) {
            newIncludes = new HashSet<String>();
            HostsFileReader.readFileToSetWithFileInputStream("included", oldDetails.includesFile, inFileInputStream, newIncludes);
            newIncludes = Collections.unmodifiableSet(newIncludes);
        }
        if (exFileInputStream != null) {
            newExcludes = new HashSet<String>();
            HostsFileReader.readFileToSetWithFileInputStream("excluded", oldDetails.excludesFile, exFileInputStream, newExcludes);
            newExcludes = Collections.unmodifiableSet(newExcludes);
        }
        HostDetails newDetails = new HostDetails(oldDetails.includesFile, newIncludes, oldDetails.excludesFile, newExcludes);
        this.current.set(newDetails);
    }

    public Set<String> getHosts() {
        HostDetails hostDetails = this.current.get();
        return hostDetails.getIncludedHosts();
    }

    public Set<String> getExcludedHosts() {
        HostDetails hostDetails = this.current.get();
        return hostDetails.getExcludedHosts();
    }

    @Deprecated
    public void getHostDetails(Set<String> includes, Set<String> excludes) {
        HostDetails hostDetails = this.current.get();
        includes.addAll(hostDetails.getIncludedHosts());
        excludes.addAll(hostDetails.getExcludedHosts());
    }

    public HostDetails getHostDetails() {
        return this.current.get();
    }

    public void setIncludesFile(String includesFile) {
        LOG.info("Setting the includes file to " + includesFile);
        HostDetails oldDetails = this.current.get();
        HostDetails newDetails = new HostDetails(includesFile, oldDetails.includes, oldDetails.excludesFile, oldDetails.excludes);
        this.current.set(newDetails);
    }

    public void setExcludesFile(String excludesFile) {
        LOG.info("Setting the excludes file to " + excludesFile);
        HostDetails oldDetails = this.current.get();
        HostDetails newDetails = new HostDetails(oldDetails.includesFile, oldDetails.includes, excludesFile, oldDetails.excludes);
        this.current.set(newDetails);
    }

    public void updateFileNames(String includesFile, String excludesFile) {
        LOG.info("Setting the includes file to " + includesFile);
        LOG.info("Setting the excludes file to " + excludesFile);
        HostDetails oldDetails = this.current.get();
        HostDetails newDetails = new HostDetails(includesFile, oldDetails.includes, excludesFile, oldDetails.excludes);
        this.current.set(newDetails);
    }

    public static class HostDetails {
        private final String includesFile;
        private final Set<String> includes;
        private final String excludesFile;
        private final Set<String> excludes;

        HostDetails(String includesFile, Set<String> includes, String excludesFile, Set<String> excludes) {
            this.includesFile = includesFile;
            this.includes = includes;
            this.excludesFile = excludesFile;
            this.excludes = excludes;
        }

        public String getIncludesFile() {
            return this.includesFile;
        }

        public Set<String> getIncludedHosts() {
            return this.includes;
        }

        public String getExcludesFile() {
            return this.excludesFile;
        }

        public Set<String> getExcludedHosts() {
            return this.excludes;
        }
    }
}

