/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.utils;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.utils.LineBufferedProcess;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SortedMap;
import scala.collection.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class LivySparkUtils$
implements Logging {
    public static LivySparkUtils$ MODULE$;
    private final SortedMap<Tuple2<Object, Object>, String> _defaultSparkScalaVersion;
    private final Tuple2<Object, Object> MIN_VERSION;
    private final Tuple2<Object, Object> MAX_VERSION;
    private final UnanchoredRegex sparkVersionRegex;
    private final UnanchoredRegex scalaVersionRegex;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LivySparkUtils$();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        LivySparkUtils$ livySparkUtils$ = this;
        synchronized (livySparkUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SortedMap<Tuple2<Object, Object>, String> _defaultSparkScalaVersion() {
        return this._defaultSparkScalaVersion;
    }

    private Tuple2<Object, Object> MIN_VERSION() {
        return this.MIN_VERSION;
    }

    private Tuple2<Object, Object> MAX_VERSION() {
        return this.MAX_VERSION;
    }

    private UnanchoredRegex sparkVersionRegex() {
        return this.sparkVersionRegex;
    }

    private UnanchoredRegex scalaVersionRegex() {
        return this.scalaVersionRegex;
    }

    public void testSparkHome(LivyConf livyConf) {
        String sparkHome = (String)livyConf.sparkHome().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Livy requires the SPARK_HOME environment variable");
        });
        Predef$.MODULE$.require(new File(sparkHome).isDirectory(), (Function0 & Serializable & scala.Serializable)() -> "SPARK_HOME path does not exist");
    }

    public void testSparkSubmit(LivyConf livyConf) {
        try {
            this.testSparkVersion((String)this.sparkSubmitVersion(livyConf)._1());
        }
        catch (IOException e) {
            throw new IOException("Failed to run spark-submit executable", e);
        }
    }

    public void testSparkVersion(String version) {
        Tuple2<Object, Object> v = this.formatSparkVersion(version);
        Predef$.MODULE$.require(Ordering.Implicits$.MODULE$.infixOrderingOps(v, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$greater$eq(this.MIN_VERSION()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Unsupported Spark version ").append(v).toString());
        if (Ordering.Implicits$.MODULE$.infixOrderingOps(v, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$greater$eq(this.MAX_VERSION())) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Current Spark ").append(v).append(" is not verified in Livy, please use it carefully").toString());
            return;
        }
    }

    public Tuple2<String, Option<String>> sparkSubmitVersion(LivyConf livyConf) {
        String version;
        String version2;
        String sparkSubmit = livyConf.sparkSubmit();
        ProcessBuilder pb = new ProcessBuilder(sparkSubmit, "--version");
        pb.redirectErrorStream(true);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        Object object = LivyConf$.MODULE$.TEST_MODE() ? pb.environment().put("LIVY_TEST_CLASSPATH", (String)package$.MODULE$.props().apply((Object)"java.class.path")) : BoxedUnit.UNIT;
        LineBufferedProcess process = new LineBufferedProcess(pb.start(), 200);
        int exitCode = process.waitFor();
        String output = process.inputIterator().mkString("\n");
        String sparkVersion = "";
        String string = output;
        Option option = ((Regex)this.sparkVersionRegex()).unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)exitCode);
            String arg$macro$2 = output;
            throw new IOException(new StringOps("Unable to determine spark-submit version [%s]:\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
        }
        sparkVersion = version2 = (String)((LinearSeqOptimized)option.get()).apply(0);
        String string2 = output;
        Option option2 = ((Regex)this.scalaVersionRegex()).unapplySeq((CharSequence)string2);
        None$ scalaVersion = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0 && new StringOps(Predef$.MODULE$.augmentString(version = (String)((LinearSeqOptimized)option2.get()).apply(0))).nonEmpty() ? new Some((Object)this.formatScalaVersion(version)) : None$.MODULE$;
        return new Tuple2((Object)sparkVersion, (Object)scalaVersion);
    }

    public String sparkScalaVersion(Tuple2<Object, Object> formattedSparkVersion, Option<String> scalaVersionFromSparkSubmit, LivyConf livyConf) {
        Option scalaVersionInLivyConf = Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_SCALA_VERSION())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LivySparkUtils$.$anonfun$sparkScalaVersion$1(x$1))).map((Function1 & Serializable & scala.Serializable)scalaVersion -> MODULE$.formatScalaVersion((String)scalaVersion));
        scalaVersionFromSparkSubmit.foreach((Function1 & Serializable & scala.Serializable)vSparkSubmit -> {
            scalaVersionInLivyConf.foreach((Function1 & Serializable & scala.Serializable)vLivyConf -> {
                LivySparkUtils$.$anonfun$sparkScalaVersion$4(vSparkSubmit, vLivyConf);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return (String)scalaVersionInLivyConf.orElse((Function0 & Serializable & scala.Serializable)() -> scalaVersionFromSparkSubmit).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultSparkScalaVersion(formattedSparkVersion));
    }

    public Tuple2<Object, Object> formatSparkVersion(String version) {
        Regex versionPattern = new StringOps(Predef$.MODULE$.augmentString("^(\\d+)\\.(\\d+)(\\..*)?$")).r();
        Option option = versionPattern.findFirstMatchIn((CharSequence)version);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt(), new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt());
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(33).append("Fail to parse Spark version from ").append(version).toString());
        }
        throw new MatchError((Object)option);
    }

    public String formatScalaVersion(String scalaVersion) {
        String string;
        Regex versionPattern = new StringOps(Predef$.MODULE$.augmentString("(\\d)+\\.(\\d+)+.*")).r();
        Option option = versionPattern.unapplySeq((CharSequence)(string = scalaVersion));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String major = (String)((LinearSeqOptimized)option.get()).apply(0);
            String minor = (String)((LinearSeqOptimized)option.get()).apply(1);
            return new StringBuilder(1).append(major).append(".").append(minor).toString();
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("Unrecognized Scala version: ").append(scalaVersion).toString());
    }

    public String defaultSparkScalaVersion(Tuple2<Object, Object> sparkVersion) {
        return (String)this._defaultSparkScalaVersion().get(sparkVersion).orElse((Function0 & Serializable & scala.Serializable)() -> {
            if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)sparkVersion, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less(((Tuple2)MODULE$._defaultSparkScalaVersion().head())._1())) {
                throw new IllegalArgumentException(new StringBuilder(66).append("Spark version ").append(sparkVersion).append(" is less than the ").append("minimum version ").append(((Tuple2)MODULE$._defaultSparkScalaVersion().head())._1()).append(" supported by Livy").toString());
            }
            if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)sparkVersion, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$greater(((Tuple2)MODULE$._defaultSparkScalaVersion().last())._1())) {
                Tuple2 tuple2 = (Tuple2)MODULE$._defaultSparkScalaVersion().last();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 spark = (Tuple2)tuple2._1();
                String scala = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)spark, (Object)scala);
                Tuple2 spark2 = (Tuple2)tuple22._1();
                String scala2 = (String)tuple22._2();
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(175).append("Spark version ").append(sparkVersion).append(" is greater then the maximum version ").append(spark2).append(" supported by Livy, will choose Scala version ").append(scala2).append(" instead, ").append("please specify manually if it is the expected Scala version you want").toString());
                return new Some((Object)scala2);
            }
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(37).append("Fail to get Scala version from Spark ").append(sparkVersion).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$sparkScalaVersion$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$sparkScalaVersion$4(String vSparkSubmit$1, String vLivyConf) {
        String string = vSparkSubmit$1;
        String string2 = vLivyConf;
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Scala version detected from spark-submit (").append(vSparkSubmit$1).append(") does not match ").append("Scala version configured in livy.conf (").append(vLivyConf).append(")").toString());
    }

    private LivySparkUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this._defaultSparkScalaVersion = SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, 5)), (Object)"2.12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, 4)), (Object)"2.12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, 3)), (Object)"2.12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, 2)), (Object)"2.12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, 1)), (Object)"2.12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, 0)), (Object)"2.12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, 4)), (Object)"2.11"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, 3)), (Object)"2.11"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, 2)), (Object)"2.11")}), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        this.MIN_VERSION = new Tuple2.mcII.sp(2, 2);
        this.MAX_VERSION = new Tuple2.mcII.sp(3, 6);
        this.sparkVersionRegex = new StringOps(Predef$.MODULE$.augmentString("version (.*)")).r().unanchored();
        this.scalaVersionRegex = new StringOps(Predef$.MODULE$.augmentString("Scala version (.*), Java")).r().unanchored();
    }
}

