/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;

public class PolarisEntity
extends PolarisBaseEntity {
    @JsonCreator
    private PolarisEntity(@JsonProperty(value="catalogId") long catalogId, @JsonProperty(value="typeCode") PolarisEntityType type, @JsonProperty(value="subTypeCode") PolarisEntitySubType subType, @JsonProperty(value="id") long id, @JsonProperty(value="parentId") long parentId, @JsonProperty(value="name") String name, @JsonProperty(value="createTimestamp") long createTimestamp, @JsonProperty(value="dropTimestamp") long dropTimestamp, @JsonProperty(value="purgeTimestamp") long purgeTimestamp, @JsonProperty(value="lastUpdateTimestamp") long lastUpdateTimestamp, @JsonProperty(value="properties") String properties, @JsonProperty(value="internalProperties") String internalProperties, @JsonProperty(value="entityVersion") int entityVersion, @JsonProperty(value="grantRecordsVersion") int grantRecordsVersion) {
        super(catalogId, id, type.getCode(), parentId, name, subType.getCode(), createTimestamp, dropTimestamp, purgeTimestamp, lastUpdateTimestamp, properties, internalProperties, grantRecordsVersion, entityVersion);
    }

    public PolarisEntity(long catalogId, PolarisEntityType type, PolarisEntitySubType subType, long id, long parentId, String name, long createTimestamp, long dropTimestamp, long purgeTimestamp, long lastUpdateTimestamp, Map<String, String> properties, Map<String, String> internalProperties, int entityVersion, int grantRecordsVersion) {
        super(catalogId, id, type.getCode(), parentId, name, subType.getCode(), createTimestamp, dropTimestamp, purgeTimestamp, lastUpdateTimestamp, PolarisEntity.convertPropertiesToJson(properties), PolarisEntity.convertPropertiesToJson(internalProperties), grantRecordsVersion, entityVersion);
    }

    @Nullable
    public static PolarisEntity of(@Nullable PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new PolarisEntity(sourceEntity);
        }
        return null;
    }

    @Nullable
    public static PolarisEntity of(EntityResult result) {
        if (result.isSuccess()) {
            return new PolarisEntity(result.getEntity());
        }
        return null;
    }

    public static PolarisEntityCore toCore(PolarisBaseEntity entity) {
        return ((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)((PolarisEntityCore.Builder)new PolarisEntityCore.Builder().catalogId(entity.getCatalogId())).id(entity.getId())).parentId(entity.getParentId())).typeCode(entity.getTypeCode())).name(entity.getName())).entityVersion(entity.getEntityVersion())).build();
    }

    public static List<PolarisEntityCore> toCoreList(List<PolarisEntity> path) {
        return Optional.ofNullable(path).filter(Predicate.not(List::isEmpty)).map(list -> list.stream().map(PolarisEntity::toCore).collect(Collectors.toList())).orElse(null);
    }

    public static List<NameAndId> toNameAndIdList(List<EntityNameLookupRecord> entities) {
        return Optional.ofNullable(entities).map(list -> list.stream().map(record -> new NameAndId(record.getName(), record.getId())).collect(Collectors.toList())).orElse(null);
    }

    public PolarisEntity(@Nonnull PolarisBaseEntity sourceEntity) {
        super(sourceEntity.getCatalogId(), sourceEntity.getId(), sourceEntity.getType().getCode(), sourceEntity.getParentId(), sourceEntity.getName(), sourceEntity.getSubType().getCode(), sourceEntity.getCreateTimestamp(), sourceEntity.getDropTimestamp(), sourceEntity.getPurgeTimestamp(), sourceEntity.getLastUpdateTimestamp(), sourceEntity.getProperties(), sourceEntity.getInternalProperties(), sourceEntity.getGrantRecordsVersion(), sourceEntity.getEntityVersion());
    }

    @Override
    @JsonIgnore
    public PolarisEntityType getType() {
        return PolarisEntityType.fromCode(this.getTypeCode());
    }

    @Override
    @JsonIgnore
    public PolarisEntitySubType getSubType() {
        return PolarisEntitySubType.fromCode(this.getSubTypeCode());
    }

    @Override
    public String toString() {
        return "name=" + this.getName() + ";id=" + this.getId() + ";parentId=" + this.getParentId() + ";entityVersion=" + this.getEntityVersion() + ";type=" + String.valueOf((Object)this.getType()) + ";subType=" + String.valueOf((Object)this.getSubType()) + ";internalProperties=" + String.valueOf(this.getInternalPropertiesAsMap());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static class NameAndId {
        private final String name;
        private final long id;

        public NameAndId(String name, long id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }
    }

    public static abstract class BaseBuilder<T extends PolarisEntity, B extends BaseBuilder<T, B>> {
        protected long catalogId;
        protected PolarisEntityType type;
        protected PolarisEntitySubType subType;
        protected long id;
        protected long parentId;
        protected String name;
        protected long createTimestamp;
        protected long dropTimestamp;
        protected long purgeTimestamp;
        protected long lastUpdateTimestamp;
        protected Map<String, String> properties;
        protected Map<String, String> internalProperties;
        protected int entityVersion;
        protected int grantRecordsVersion;

        protected BaseBuilder() {
            this.catalogId = -1L;
            this.type = PolarisEntityType.NULL_TYPE;
            this.subType = PolarisEntitySubType.NULL_SUBTYPE;
            this.id = -1L;
            this.parentId = 0L;
            this.name = null;
            this.createTimestamp = 0L;
            this.dropTimestamp = 0L;
            this.purgeTimestamp = 0L;
            this.lastUpdateTimestamp = 0L;
            this.properties = new HashMap<String, String>();
            this.internalProperties = new HashMap<String, String>();
            this.entityVersion = 1;
            this.grantRecordsVersion = 1;
        }

        protected BaseBuilder(T original) {
            this.catalogId = ((PolarisEntity)original).catalogId;
            this.type = ((PolarisEntity)original).getType();
            this.subType = ((PolarisEntity)original).getSubType();
            this.id = ((PolarisEntity)original).id;
            this.parentId = ((PolarisEntity)original).parentId;
            this.name = ((PolarisEntity)original).name;
            this.createTimestamp = ((PolarisEntity)original).createTimestamp;
            this.dropTimestamp = ((PolarisEntity)original).dropTimestamp;
            this.purgeTimestamp = ((PolarisEntity)original).purgeTimestamp;
            this.lastUpdateTimestamp = ((PolarisEntity)original).lastUpdateTimestamp;
            this.properties = new HashMap<String, String>(((PolarisBaseEntity)original).getPropertiesAsMap());
            this.internalProperties = new HashMap<String, String>(((PolarisBaseEntity)original).getInternalPropertiesAsMap());
            this.entityVersion = ((PolarisEntity)original).entityVersion;
            this.grantRecordsVersion = ((PolarisEntity)original).grantRecordsVersion;
        }

        public abstract T build();

        public PolarisEntity buildBase() {
            return new PolarisEntity(this.catalogId, this.type, this.subType, this.id, this.parentId, this.name, this.createTimestamp, this.dropTimestamp, this.purgeTimestamp, this.lastUpdateTimestamp, this.properties, this.internalProperties, this.entityVersion, this.grantRecordsVersion);
        }

        public B setCatalogId(long catalogId) {
            this.catalogId = catalogId;
            return (B)this;
        }

        public B setType(PolarisEntityType type) {
            this.type = type;
            return (B)this;
        }

        public B setSubType(PolarisEntitySubType subType) {
            this.subType = subType;
            return (B)this;
        }

        public B setId(long id) {
            this.id = id;
            return (B)this;
        }

        public B setParentId(long parentId) {
            this.parentId = parentId;
            return (B)this;
        }

        public B setName(String name) {
            this.name = name;
            return (B)this;
        }

        public B setCreateTimestamp(long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return (B)this;
        }

        public B setDropTimestamp(long dropTimestamp) {
            this.dropTimestamp = dropTimestamp;
            return (B)this;
        }

        public B setPurgeTimestamp(long purgeTimestamp) {
            this.purgeTimestamp = purgeTimestamp;
            return (B)this;
        }

        public B setLastUpdateTimestamp(long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return (B)this;
        }

        public B setProperties(Map<String, String> properties) {
            this.properties = new HashMap<String, String>(properties);
            return (B)this;
        }

        public B addProperty(String key, String value) {
            this.properties.put(key, value);
            return (B)this;
        }

        public B setInternalProperties(Map<String, String> internalProperties) {
            this.internalProperties = new HashMap<String, String>(internalProperties);
            return (B)this;
        }

        public B addInternalProperty(String key, String value) {
            this.internalProperties.put(key, value);
            return (B)this;
        }

        public B setEntityVersion(int entityVersion) {
            this.entityVersion = entityVersion;
            return (B)this;
        }

        public B setGrantRecordsVersion(int grantRecordsVersion) {
            this.grantRecordsVersion = grantRecordsVersion;
            return (B)this;
        }
    }

    public static class Builder
    extends BaseBuilder<PolarisEntity, Builder> {
        public Builder() {
        }

        public Builder(PolarisEntity original) {
            super(original);
        }

        @Override
        public PolarisEntity build() {
            return this.buildBase();
        }
    }

    public static class TypeSubTypeAndName {
        private final PolarisEntityType type;
        private final PolarisEntitySubType subType;
        private final String name;

        public TypeSubTypeAndName(PolarisEntityType type, PolarisEntitySubType subType, String name) {
            this.type = type;
            this.subType = subType;
            this.name = name;
        }

        public PolarisEntityType getType() {
            return this.type;
        }

        public PolarisEntitySubType getSubType() {
            return this.subType;
        }

        public String getName() {
            return this.name;
        }
    }
}

