/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public class FutureImpl<R>
implements Future<R> {
    protected final ReentrantLock lock;
    protected boolean isDone;
    protected CountDownLatch latch;
    protected boolean isCancelled;
    protected Throwable failure;
    protected R result;

    public FutureImpl() {
        this(new ReentrantLock());
    }

    public FutureImpl(ReentrantLock lock) {
        this.lock = lock;
        this.latch = new CountDownLatch(1);
    }

    public R getResult() {
        this.lock.lock();
        try {
            R r = this.result;
            return r;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Throwable getFailure() {
        this.lock.lock();
        try {
            Throwable throwable = this.failure;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setResult(R result) {
        this.lock.lock();
        try {
            this.result = result;
            this.notifyHaveResult();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.lock.lock();
        try {
            this.isCancelled = true;
            this.notifyHaveResult();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        try {
            this.lock.lock();
            boolean bl = this.isCancelled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.isDone;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        this.latch.await();
        this.lock.lock();
        try {
            if (this.isCancelled) {
                throw new CancellationException();
            }
            if (this.failure != null) {
                throw new ExecutionException(this.failure);
            }
            R r = this.result;
            return r;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean isTimeOut = !this.latch.await(timeout, unit);
        this.lock.lock();
        try {
            if (!isTimeOut) {
                if (this.isCancelled) {
                    throw new CancellationException();
                }
                if (this.failure != null) {
                    throw new ExecutionException(this.failure);
                }
                R r = this.result;
                return r;
            }
            throw new TimeoutException();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void failure(Throwable failure) {
        this.lock.lock();
        try {
            this.failure = failure;
            this.notifyHaveResult();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void notifyHaveResult() {
        this.isDone = true;
        this.latch.countDown();
    }
}

