/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http.filter;

import java.util.List;
import java.util.function.Consumer;
import org.apache.seata.core.exception.HttpRequestFilterException;
import org.apache.seata.core.rpc.netty.http.filter.HttpFilterContext;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilter;

public class HttpRequestFilterChain {
    private final List<HttpRequestFilter> filters;
    private final Consumer<HttpFilterContext<?>> finalAction;
    private int currentIndex = 0;

    public HttpRequestFilterChain(List<HttpRequestFilter> filters, Consumer<HttpFilterContext<?>> finalAction) {
        this.filters = filters;
        this.finalAction = finalAction;
    }

    public void doFilter(HttpFilterContext<?> httpFilterContext) throws HttpRequestFilterException {
        if (this.currentIndex < this.filters.size()) {
            HttpRequestFilter filter = this.filters.get(this.currentIndex++);
            filter.doFilter(httpFilterContext, this);
        } else {
            if (this.finalAction != null) {
                this.finalAction.accept(httpFilterContext);
            }
            this.currentIndex = 0;
        }
    }

    List<HttpRequestFilter> getFilters() {
        return this.filters;
    }
}

