/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.filter;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.seata.namingserver.filter.CachedBodyHttpServletRequest;

public class CachedBodyHttpServletRequest
extends HttpServletRequestWrapper {
    private final byte[] cachedBody;

    public CachedBodyHttpServletRequest(HttpServletRequest request) throws IOException {
        super(request);
        ServletInputStream requestInputStream = request.getInputStream();
        this.cachedBody = this.toByteArray((InputStream)requestInputStream);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new CachedBodyServletInputStream(this.cachedBody);
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    public byte[] getCachedBody() {
        return this.cachedBody;
    }
}

