/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.sdk.server.events.conversions.UInt32Conversions;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UInt64Conversions {
    private UInt64Conversions() {
    }

    @NotNull
    static Boolean uInt64ToBoolean(@NotNull ULong ul) {
        return ul.intValue() != 0;
    }

    @Nullable
    static UByte uInt64ToByte(@NotNull ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, 255L) <= 0) {
            return Unsigned.ubyte((long)l);
        }
        return null;
    }

    @Nullable
    static Double uInt64ToDouble(@NotNull ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, Long.MAX_VALUE) <= 0) {
            return ul.doubleValue();
        }
        return null;
    }

    @Nullable
    static Float uInt64ToFloat(@NotNull ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, Long.MAX_VALUE) <= 0) {
            return Float.valueOf(ul.floatValue());
        }
        return null;
    }

    @Nullable
    static Short uInt64ToInt16(@NotNull ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, 32767L) <= 0) {
            return (short)l;
        }
        return null;
    }

    @Nullable
    static Integer uInt64ToInt32(@NotNull ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, Integer.MAX_VALUE) <= 0) {
            return (int)l;
        }
        return null;
    }

    @Nullable
    static Long uInt64ToInt64(@NotNull ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, Long.MAX_VALUE) <= 0) {
            return l;
        }
        return null;
    }

    @Nullable
    static Byte uInt64ToSByte(@NotNull ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, 127L) <= 0) {
            return (byte)l;
        }
        return null;
    }

    @Nullable
    static StatusCode uInt64ToStatusCode(@NotNull ULong ul) {
        UInteger ui = UInt64Conversions.uInt64ToUInt32(ul);
        return ui != null ? UInt32Conversions.uInt32ToStatusCode(ui) : null;
    }

    @NotNull
    static String uInt64ToString(ULong ul) {
        return ul.toString();
    }

    @Nullable
    static UShort uInt64ToUInt16(ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, 65535L) <= 0) {
            return Unsigned.ushort((int)((int)l));
        }
        return null;
    }

    @Nullable
    static UInteger uInt64ToUInt32(ULong ul) {
        long l = ul.longValue();
        if (Long.compareUnsigned(l, 0xFFFFFFFFL) <= 0) {
            return Unsigned.uint((long)l);
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof ULong) {
            ULong ul = (ULong)o;
            return implicit ? UInt64Conversions.implicitConversion(ul, targetType) : UInt64Conversions.explicitConversion(ul, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull ULong ul, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return UInt64Conversions.uInt64ToBoolean(ul);
            }
            case Byte: {
                return UInt64Conversions.uInt64ToByte(ul);
            }
            case Int16: {
                return UInt64Conversions.uInt64ToInt16(ul);
            }
            case Int32: {
                return UInt64Conversions.uInt64ToInt32(ul);
            }
            case SByte: {
                return UInt64Conversions.uInt64ToSByte(ul);
            }
            case StatusCode: {
                return UInt64Conversions.uInt64ToStatusCode(ul);
            }
            case String: {
                return UInt64Conversions.uInt64ToString(ul);
            }
            case UInt16: {
                return UInt64Conversions.uInt64ToUInt16(ul);
            }
            case UInt32: {
                return UInt64Conversions.uInt64ToUInt32(ul);
            }
        }
        return UInt64Conversions.implicitConversion(ul, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull ULong ul, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return UInt64Conversions.uInt64ToDouble(ul);
            }
            case Float: {
                return UInt64Conversions.uInt64ToFloat(ul);
            }
            case Int64: {
                return UInt64Conversions.uInt64ToInt64(ul);
            }
        }
        return null;
    }
}

