/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AggregateConfiguration;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilterResult;

public class AggregateFilterResult
extends MonitoringFilterResult
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=737");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=739");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=738");
    private final DateTime revisedStartTime;
    private final Double revisedProcessingInterval;
    private final AggregateConfiguration revisedAggregateConfiguration;

    public AggregateFilterResult(DateTime revisedStartTime, Double revisedProcessingInterval, AggregateConfiguration revisedAggregateConfiguration) {
        this.revisedStartTime = revisedStartTime;
        this.revisedProcessingInterval = revisedProcessingInterval;
        this.revisedAggregateConfiguration = revisedAggregateConfiguration;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime getRevisedStartTime() {
        return this.revisedStartTime;
    }

    public Double getRevisedProcessingInterval() {
        return this.revisedProcessingInterval;
    }

    public AggregateConfiguration getRevisedAggregateConfiguration() {
        return this.revisedAggregateConfiguration;
    }

    protected AggregateFilterResult(AggregateFilterResultBuilder<?, ?> b) {
        super((MonitoringFilterResult.MonitoringFilterResultBuilder<?, ?>)b);
        this.revisedStartTime = ((AggregateFilterResultBuilder)b).revisedStartTime;
        this.revisedProcessingInterval = ((AggregateFilterResultBuilder)b).revisedProcessingInterval;
        this.revisedAggregateConfiguration = ((AggregateFilterResultBuilder)b).revisedAggregateConfiguration;
    }

    public static AggregateFilterResultBuilder<?, ?> builder() {
        return new AggregateFilterResultBuilderImpl();
    }

    public AggregateFilterResultBuilder<?, ?> toBuilder() {
        return new AggregateFilterResultBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateFilterResult)) {
            return false;
        }
        AggregateFilterResult other = (AggregateFilterResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$revisedProcessingInterval = this.getRevisedProcessingInterval();
        Double other$revisedProcessingInterval = other.getRevisedProcessingInterval();
        if (this$revisedProcessingInterval == null ? other$revisedProcessingInterval != null : !((Object)this$revisedProcessingInterval).equals(other$revisedProcessingInterval)) {
            return false;
        }
        DateTime this$revisedStartTime = this.getRevisedStartTime();
        DateTime other$revisedStartTime = other.getRevisedStartTime();
        if (this$revisedStartTime == null ? other$revisedStartTime != null : !((Object)this$revisedStartTime).equals(other$revisedStartTime)) {
            return false;
        }
        AggregateConfiguration this$revisedAggregateConfiguration = this.getRevisedAggregateConfiguration();
        AggregateConfiguration other$revisedAggregateConfiguration = other.getRevisedAggregateConfiguration();
        return !(this$revisedAggregateConfiguration == null ? other$revisedAggregateConfiguration != null : !((Object)this$revisedAggregateConfiguration).equals(other$revisedAggregateConfiguration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AggregateFilterResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $revisedProcessingInterval = this.getRevisedProcessingInterval();
        result = result * 59 + ($revisedProcessingInterval == null ? 43 : ((Object)$revisedProcessingInterval).hashCode());
        DateTime $revisedStartTime = this.getRevisedStartTime();
        result = result * 59 + ($revisedStartTime == null ? 43 : ((Object)$revisedStartTime).hashCode());
        AggregateConfiguration $revisedAggregateConfiguration = this.getRevisedAggregateConfiguration();
        result = result * 59 + ($revisedAggregateConfiguration == null ? 43 : ((Object)$revisedAggregateConfiguration).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AggregateFilterResult(revisedStartTime=" + this.getRevisedStartTime() + ", revisedProcessingInterval=" + this.getRevisedProcessingInterval() + ", revisedAggregateConfiguration=" + this.getRevisedAggregateConfiguration() + ")";
    }

    private static final class AggregateFilterResultBuilderImpl
    extends AggregateFilterResultBuilder<AggregateFilterResult, AggregateFilterResultBuilderImpl> {
        private AggregateFilterResultBuilderImpl() {
        }

        @Override
        protected AggregateFilterResultBuilderImpl self() {
            return this;
        }

        @Override
        public AggregateFilterResult build() {
            return new AggregateFilterResult(this);
        }
    }

    public static abstract class AggregateFilterResultBuilder<C extends AggregateFilterResult, B extends AggregateFilterResultBuilder<C, B>>
    extends MonitoringFilterResult.MonitoringFilterResultBuilder<C, B> {
        private DateTime revisedStartTime;
        private Double revisedProcessingInterval;
        private AggregateConfiguration revisedAggregateConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AggregateFilterResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AggregateFilterResult instance, AggregateFilterResultBuilder<?, ?> b) {
            b.revisedStartTime(instance.revisedStartTime);
            b.revisedProcessingInterval(instance.revisedProcessingInterval);
            b.revisedAggregateConfiguration(instance.revisedAggregateConfiguration);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B revisedStartTime(DateTime revisedStartTime) {
            this.revisedStartTime = revisedStartTime;
            return (B)this.self();
        }

        public B revisedProcessingInterval(Double revisedProcessingInterval) {
            this.revisedProcessingInterval = revisedProcessingInterval;
            return (B)this.self();
        }

        public B revisedAggregateConfiguration(AggregateConfiguration revisedAggregateConfiguration) {
            this.revisedAggregateConfiguration = revisedAggregateConfiguration;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AggregateFilterResult.AggregateFilterResultBuilder(super=" + super.toString() + ", revisedStartTime=" + this.revisedStartTime + ", revisedProcessingInterval=" + this.revisedProcessingInterval + ", revisedAggregateConfiguration=" + this.revisedAggregateConfiguration + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AggregateFilterResult> {
        @Override
        public Class<AggregateFilterResult> getType() {
            return AggregateFilterResult.class;
        }

        @Override
        public AggregateFilterResult decode(SerializationContext context, UaDecoder decoder) {
            DateTime revisedStartTime = decoder.readDateTime("RevisedStartTime");
            Double revisedProcessingInterval = decoder.readDouble("RevisedProcessingInterval");
            AggregateConfiguration revisedAggregateConfiguration = (AggregateConfiguration)decoder.readStruct("RevisedAggregateConfiguration", AggregateConfiguration.TYPE_ID);
            return new AggregateFilterResult(revisedStartTime, revisedProcessingInterval, revisedAggregateConfiguration);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AggregateFilterResult value) {
            encoder.writeDateTime("RevisedStartTime", value.getRevisedStartTime());
            encoder.writeDouble("RevisedProcessingInterval", value.getRevisedProcessingInterval());
            encoder.writeStruct("RevisedAggregateConfiguration", (Object)value.getRevisedAggregateConfiguration(), AggregateConfiguration.TYPE_ID);
        }
    }
}

