/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.procedure;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.procedure.Procedure;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.PrintSerializableBase;

public abstract class ProcedureBase
extends PrintSerializableBase
implements Procedure {
    private Node procId;
    private ExprList args;

    @Override
    public void build(Node procId, ExprList args, ExecutionContext execCxt) {
        this.procId = procId;
        this.args = args;
    }

    @Override
    public final QueryIterator proc(QueryIterator input, ExecutionContext execCxt) {
        return new RepeatApplyIteratorProc(input, execCxt);
    }

    public abstract QueryIterator exec(Binding var1, Node var2, ExprList var3, ExecutionContext var4);

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.print("Procedure [" + FmtUtils.stringForNode(this.procId, sCxt) + "]");
        out.print("[");
        out.print(this.args.toString());
        out.print("]");
        out.println();
    }

    class RepeatApplyIteratorProc
    extends QueryIterRepeatApply {
        private ExecutionContext execCxt;
        private Node name;

        public RepeatApplyIteratorProc(QueryIterator input, ExecutionContext execCxt) {
            super(input, execCxt);
        }

        @Override
        protected QueryIterator nextStage(Binding binding) {
            QueryIterator iter = ProcedureBase.this.exec(binding, this.name, ProcedureBase.this.args, super.getExecContext());
            if (iter == null) {
                iter = IterLib.noResults(this.execCxt);
            }
            return iter;
        }

        @Override
        protected void details(IndentedWriter out, SerializationContext sCxt) {
            out.print("Procedure [" + FmtUtils.stringForNode(this.name, sCxt) + "]");
            WriterExpr.output(out, ProcedureBase.this.args, sCxt);
            out.println();
        }
    }
}

