/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.PrintStream;
import java.util.Optional;

public class Version {
    private Version() {
    }

    public static Optional<String> versionForClass(Class<?> cls) {
        String x = cls.getPackage().getImplementationVersion();
        return Optional.ofNullable(x);
    }

    public static void printVersion(PrintStream out, String system, Optional<String> versionString) {
        Version.printVersion(out, system, versionString.orElse("<development>"));
    }

    public static void printVersion(PrintStream out, String system, String versionString) {
        if (system == null) {
            out.printf("Apache Jena version %s\n", versionString);
        } else {
            out.printf("Apache Jena %s version %s\n", system, versionString);
        }
    }
}

