/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.data.DistinctDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.lib.FileOps;

public class DistinctDataNet<E>
extends DistinctDataBag<E> {
    protected File firstSpillFile;

    public DistinctDataNet(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory, Comparator<E> comparator) {
        super(policy, serializerFactory, comparator);
    }

    public boolean netAdd(E item) {
        long s = this.size;
        super.add(item);
        return !this.spilled && this.size > s;
    }

    @Override
    protected void registerSpillFile(File spillFile) {
        if (!this.spilled) {
            this.firstSpillFile = spillFile;
        } else {
            super.registerSpillFile(spillFile);
        }
    }

    @Override
    protected void deleteSpillFiles() {
        super.deleteSpillFiles();
        if (null != this.firstSpillFile) {
            FileOps.delete(this.firstSpillFile, false);
            this.firstSpillFile = null;
        }
    }

    @Override
    protected List<File> getSpillFiles() {
        ArrayList<File> toReturn = new ArrayList<File>(super.getSpillFiles());
        if (null != this.firstSpillFile) {
            toReturn.add(this.firstSpillFile);
        }
        return toReturn;
    }

    protected List<File> getNetSpillFiles() {
        return super.getSpillFiles();
    }

    public Iterator<E> netIterator() {
        Iterator exclusionsIterator;
        if (!this.spilled) {
            return Iter.nullIterator();
        }
        try {
            exclusionsIterator = this.getInputIterator(this.firstSpillFile);
        }
        catch (FileNotFoundException e2) {
            throw new AtlasException("Cannot find the first spill file", e2);
        }
        Iterator rest = super.iterator();
        SortedDiffIterator sdi = SortedDiffIterator.create(rest, exclusionsIterator, this.comparator);
        this.registerCloseableIterator(sdi);
        return sdi;
    }

    protected static class SortedDiffIterator<T>
    implements IteratorCloseable<T> {
        private final Iterator<T> inputToBeFiltered;
        private final Iterator<T> exclusions;
        private final Comparator<? super T> comp;
        private boolean finished = false;
        private boolean exclusionSlotFull = false;
        private T inputElement;
        private T exclusionElement;

        public static <S extends Comparable<? super S>> SortedDiffIterator<S> create(Iterator<S> first, Iterator<S> exclusions) {
            return SortedDiffIterator.create(first, exclusions, new Comparator<S>(){

                @Override
                public int compare(S o1, S o2) {
                    if (null == o1 && null == o2) {
                        return 0;
                    }
                    if (null == o1) {
                        return -1;
                    }
                    if (null == o2) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }

        public static <S> SortedDiffIterator<S> create(Iterator<S> first, Iterator<S> second, Comparator<? super S> comparator) {
            return new SortedDiffIterator<S>(first, second, comparator);
        }

        private SortedDiffIterator(Iterator<T> first, Iterator<T> second, Comparator<? super T> comparator) {
            this.inputToBeFiltered = first;
            this.exclusions = second;
            this.comp = comparator;
            this.fill();
        }

        private void fill() {
            if (this.finished) {
                return;
            }
            if (!this.inputToBeFiltered.hasNext()) {
                this.close();
                return;
            }
            if (!this.exclusionSlotFull) {
                if (!this.exclusions.hasNext()) {
                    this.inputElement = this.inputToBeFiltered.next();
                    return;
                }
                this.exclusionElement = this.exclusions.next();
                this.exclusionSlotFull = true;
            }
            block0: while (true) {
                if (!this.inputToBeFiltered.hasNext()) {
                    this.close();
                    return;
                }
                this.inputElement = this.inputToBeFiltered.next();
                int cmp = this.comp.compare(this.inputElement, this.exclusionElement);
                if (cmp < 0) {
                    return;
                }
                do {
                    if (cmp <= 0) continue block0;
                    if (!this.exclusions.hasNext()) {
                        this.exclusionElement = null;
                        this.exclusionSlotFull = false;
                        return;
                    }
                    this.exclusionElement = this.exclusions.next();
                } while ((cmp = this.comp.compare(this.inputElement, this.exclusionElement)) >= 0);
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.finished;
        }

        @Override
        public T next() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            T toReturn = this.inputElement;
            this.fill();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SortedDiffIterator.remove");
        }

        @Override
        public void close() {
            this.finished = true;
            this.inputElement = null;
            this.exclusionElement = null;
            Iter.close(this.inputToBeFiltered);
            Iter.close(this.exclusions);
        }
    }
}

