/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.changes;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfpatch.PatchException;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.sparql.util.FmtUtils;

public class RDFChangesApplyGraph
implements RDFChanges {
    private Graph graph;

    public RDFChangesApplyGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
    }

    @Override
    public void segment() {
    }

    @Override
    public void header(String field, Node value) {
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        if (g != null) {
            throw new QuadDataException("Attempt to add quad data to a graph: g=" + FmtUtils.stringForNode(g));
        }
        this.graph.add(Triple.create(s, p, o));
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        if (g != null) {
            throw new QuadDataException("Attempt to delete quad data to a graph: g=" + FmtUtils.stringForNode(g));
        }
        this.graph.delete(Triple.create(s, p, o));
    }

    @Override
    public void addPrefix(Node gn, String prefix, String uriStr) {
        this.graph.getPrefixMapping().setNsPrefix(prefix, uriStr);
    }

    @Override
    public void deletePrefix(Node gn, String prefix) {
        this.graph.getPrefixMapping().removeNsPrefix(prefix);
    }

    @Override
    public void txnBegin() {
        this.graph.getTransactionHandler().begin();
    }

    @Override
    public void txnCommit() {
        this.graph.getTransactionHandler().commit();
    }

    @Override
    public void txnAbort() {
        this.graph.getTransactionHandler().abort();
    }

    private static class QuadDataException
    extends PatchException {
        QuadDataException(String msg) {
            super(msg);
        }
    }
}

