/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;

public class TransformReorder
extends TransformCopy {
    private ReorderTransformation reorder;

    public TransformReorder() {
        this(ReorderLib.fixed());
    }

    public TransformReorder(ReorderTransformation reorder) {
        if (reorder == null) {
            throw new IllegalArgumentException("reorder cannot be null");
        }
        this.reorder = reorder;
    }

    @Override
    public Op transform(OpBGP opBGP) {
        BasicPattern pattern = opBGP.getPattern();
        if (pattern.size() < 2) {
            return opBGP;
        }
        BasicPattern pattern2 = this.reorder.reorder(pattern);
        return new OpBGP(pattern2);
    }

    @Override
    public Op transform(OpQuadPattern opQuadPattern) {
        BasicPattern pattern = opQuadPattern.getBasicPattern();
        if (pattern.size() < 2) {
            return opQuadPattern;
        }
        BasicPattern pattern2 = this.reorder.reorder(pattern);
        return new OpQuadPattern(opQuadPattern.getGraphNode(), pattern2);
    }
}

