/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.lucene.analysis.Analyzer;

public class EntityDefinition {
    private final Map<Node, String> predicateToField = new HashMap<Node, String>();
    private final Map<String, Analyzer> fieldToAnalyzer = new HashMap<String, Analyzer>();
    private final ListValuedMap<String, Node> fieldToPredicate = MultiMapUtils.newListValuedHashMap();
    private final Map<String, Boolean> fieldToNoIndex = new HashMap<String, Boolean>();
    private final Collection<String> fields = Collections.unmodifiableCollection(this.fieldToPredicate.keys());
    private final String entityField;
    private final String primaryField;
    private String graphField = null;
    private String langField;
    private String uidField;
    private boolean cacheQueries;

    public EntityDefinition(String entityField, String primaryField) {
        this.entityField = entityField;
        this.primaryField = primaryField;
    }

    public EntityDefinition(String entityField, String primaryField, String graphField) {
        this(entityField, primaryField);
        this.setGraphField(graphField);
    }

    public EntityDefinition(String entityField, String primaryField, Resource primaryPredicate) {
        this(entityField, primaryField);
        this.setPrimaryPredicate(primaryPredicate);
    }

    public EntityDefinition(String entityField, String primaryField, Node primaryPredicate) {
        this(entityField, primaryField);
        this.setPrimaryPredicate(primaryPredicate);
    }

    public EntityDefinition(String entityField, String primaryField, String graphField, Node primaryPredicate) {
        this(entityField, primaryField);
        this.setGraphField(graphField);
        this.setPrimaryPredicate(primaryPredicate);
    }

    public String getEntityField() {
        return this.entityField;
    }

    public void setPrimaryPredicate(Resource primaryPredicate) {
        this.setPrimaryPredicate(primaryPredicate.asNode());
    }

    public void setPrimaryPredicate(Node primaryPredicate) {
        this.set(this.primaryField, primaryPredicate);
    }

    public void set(String field, Node predicate) {
        this.predicateToField.put(predicate, field);
        Collection c = this.fieldToPredicate.get((Object)field);
        if (c == null || !c.contains(predicate)) {
            this.fieldToPredicate.put(field, predicate);
        }
    }

    public Collection<Node> getPredicates(String field) {
        return this.fieldToPredicate.get((Object)field);
    }

    public String getField(Node predicate) {
        return this.predicateToField.get(predicate);
    }

    public void setAnalyzer(String field, Analyzer analyzer) {
        this.fieldToAnalyzer.put(field, analyzer);
    }

    public Analyzer getAnalyzer(String field) {
        return this.fieldToAnalyzer.get(field);
    }

    public void setNoIndex(String field, boolean b) {
        this.fieldToNoIndex.put(field, b);
    }

    public boolean getNoIndex(String field) {
        Boolean b = this.fieldToNoIndex.get(field);
        return b != null ? b : false;
    }

    public String getPrimaryField() {
        return this.primaryField;
    }

    public Node getPrimaryPredicate() {
        Collection c = this.fieldToPredicate.get((Object)this.getPrimaryField());
        return (Node)EntityDefinition.getOne(c);
    }

    public String getGraphField() {
        return this.graphField;
    }

    public void setGraphField(String graphField) {
        this.graphField = graphField;
    }

    public String getLangField() {
        return this.langField;
    }

    public void setLangField(String langField) {
        this.langField = langField;
    }

    public String getUidField() {
        return this.uidField;
    }

    public void setUidField(String uidField) {
        this.uidField = uidField;
    }

    public Collection<String> fields() {
        return this.fields;
    }

    private static <T> T getOne(Collection<T> collection) {
        if (collection.size() != 1) {
            return null;
        }
        return collection.iterator().next();
    }

    public boolean areQueriesCached() {
        return this.cacheQueries;
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public String toString() {
        return this.entityField + ":" + String.valueOf(this.predicateToField);
    }
}

