/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.messages;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.lucene.util.CollectionUtil;

public class NLS {
    private static final Map<String, Class<? extends NLS>> bundles = new HashMap<String, Class<? extends NLS>>(0);

    protected NLS() {
    }

    public static String getLocalizedMessage(String key) {
        return NLS.getLocalizedMessage(key, Locale.getDefault());
    }

    public static String getLocalizedMessage(String key, Locale locale) {
        Object message = NLS.getResourceBundleObject(key, locale);
        if (message == null) {
            return "Message with key:" + key + " and locale: " + String.valueOf(locale) + " not found.";
        }
        return message.toString();
    }

    public static String getLocalizedMessage(String key, Locale locale, Object ... args) {
        String str2 = NLS.getLocalizedMessage(key, locale);
        if (args.length > 0) {
            str2 = new MessageFormat(str2, Locale.ROOT).format(args);
        }
        return str2;
    }

    public static String getLocalizedMessage(String key, Object ... args) {
        return NLS.getLocalizedMessage(key, Locale.getDefault(), args);
    }

    protected static void initializeMessages(String bundleName, Class<? extends NLS> clazz) {
        try {
            NLS.load(clazz);
            bundles.putIfAbsent(bundleName, clazz);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Object getResourceBundleObject(String messageKey, Locale locale) {
        for (Class<? extends NLS> clazz : bundles.values()) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(clazz.getName(), locale);
            if (resourceBundle == null) continue;
            try {
                Object obj = resourceBundle.getObject(messageKey);
                if (obj == null) continue;
                return obj;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    private static void load(Class<? extends NLS> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int len = fieldArray.length;
        HashMap<String, Field> fields = CollectionUtil.newHashMap(len);
        for (Field field : fieldArray) {
            fields.put(field.getName(), field);
            NLS.loadfieldValue(field, clazz);
        }
    }

    private static void loadfieldValue(Field field, Class<? extends NLS> clazz) {
        int MOD_EXPECTED = 9;
        int MOD_MASK = MOD_EXPECTED | 0x10;
        if ((field.getModifiers() & MOD_MASK) != MOD_EXPECTED) {
            return;
        }
        try {
            field.set(null, field.getName());
            NLS.validateMessage(field.getName(), clazz);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private static void validateMessage(String key, Class<? extends NLS> clazz) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(clazz.getName(), Locale.getDefault());
            if (resourceBundle != null) {
                resourceBundle.getObject(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

