/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.Quantity;
import javax.measure.spi.FormatService;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.SystemOfUnitsService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ServiceProvider {
    private static final String NAMED_ANNOTATION = "javax.inject.Named";
    private static final String PRIORITY_ANNOTATION = "javax.annotation.Priority";
    private static final String JAKARTA_NAMED_ANNOTATION = "jakarta.inject.Named";
    private static final String JAKARTA_PRIORITY_ANNOTATION = "jakarta.annotation.Priority";
    private static final AtomicReference<ServiceProvider> current = new AtomicReference();

    protected ServiceProvider() {
    }

    public int getPriority() {
        return 0;
    }

    public abstract SystemOfUnitsService getSystemOfUnitsService();

    public abstract FormatService getFormatService();

    public abstract <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(Class<Q> var1);

    public static final List<ServiceProvider> available() {
        ArrayList providers;
        block4: {
            providers = new Selector(null).stream().collect(Collectors.toCollection(ArrayList::new));
            ServiceProvider first = current.get();
            if (first == null && !providers.isEmpty()) {
                first = ServiceProvider.setDefault((ServiceProvider)providers.get(0));
            }
            if (first != null) {
                Class<?> cf = first.getClass();
                int size = providers.size();
                for (int i = 0; i < size; ++i) {
                    if (!cf.equals(((ServiceProvider)providers.get(i)).getClass())) continue;
                    if (i != 0) {
                        providers.remove(i);
                        break;
                    }
                    break block4;
                }
                providers.add(0, first);
            }
        }
        return providers;
    }

    public static ServiceProvider of(String name) {
        Objects.requireNonNull(name);
        Selector select = new Selector(name);
        ServiceProvider p = current.get();
        if (p != null && select.test(p)) {
            return p;
        }
        Optional first = select.stream().findFirst();
        if (first.isPresent()) {
            return (ServiceProvider)first.get();
        }
        throw new IllegalArgumentException("No Measurement ServiceProvider " + name + " found .");
    }

    public static final ServiceProvider current() {
        ServiceProvider p = current.get();
        if (p == null) {
            Optional first = new Selector(null).stream().findFirst();
            if (!first.isPresent()) {
                throw new IllegalStateException("No Measurement ServiceProvider found.");
            }
            p = (ServiceProvider)first.get();
            p = ServiceProvider.setDefault(p);
        }
        return p;
    }

    private static ServiceProvider setDefault(ServiceProvider provider) {
        while (!current.compareAndSet(null, provider)) {
            ServiceProvider c = current.get();
            if (c == null) continue;
            return c;
        }
        return provider;
    }

    public static final ServiceProvider setCurrent(ServiceProvider provider) {
        Objects.requireNonNull(provider);
        ServiceProvider old = current.getAndSet(provider);
        if (old != provider) {
            Logger.getLogger("javax.measure.spi").log(Level.CONFIG, "Measurement ServiceProvider {1,choice,0#set to|1#replaced by} {0}.", new Object[]{provider.getClass().getName(), old == null ? 0 : 1});
        }
        return old;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Selector
    implements Predicate<ServiceProvider>,
    Comparator<ServiceProvider> {
        private final String toSearch;
        private Class<? extends Annotation> namedAnnotation;
        private Class<? extends Annotation> priorityAnnotation;
        private Class<? extends Annotation> jakartaNamedAnnotation;
        private Class<? extends Annotation> jakartaPriorityAnnotation;
        private Method nameGetter;
        private Method priorityGetter;

        Selector(String name) {
            this.toSearch = name;
            try {
                if (name != null) {
                    try {
                        this.namedAnnotation = Class.forName(ServiceProvider.NAMED_ANNOTATION).asSubclass(Annotation.class);
                        this.nameGetter = this.namedAnnotation.getMethod("value", null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.nameGetter == null) {
                    try {
                        this.jakartaNamedAnnotation = Class.forName(ServiceProvider.JAKARTA_NAMED_ANNOTATION).asSubclass(Annotation.class);
                        this.nameGetter = this.jakartaNamedAnnotation.getMethod("value", null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    this.priorityAnnotation = Class.forName(ServiceProvider.PRIORITY_ANNOTATION).asSubclass(Annotation.class);
                    this.priorityGetter = this.priorityAnnotation.getMethod("value", null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (this.priorityGetter == null) {
                    try {
                        this.jakartaPriorityAnnotation = Class.forName(ServiceProvider.JAKARTA_PRIORITY_ANNOTATION).asSubclass(Annotation.class);
                        this.priorityGetter = this.jakartaPriorityAnnotation.getMethod("value", null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            catch (NoSuchMethodException e2) {
                throw new ServiceConfigurationError("Cannot get annotation value", e2);
            }
        }

        @Override
        public boolean test(ServiceProvider provider) {
            Object value = null;
            if (this.nameGetter != null) {
                Annotation a = null;
                if (this.namedAnnotation != null) {
                    a = provider.getClass().getAnnotation(this.namedAnnotation);
                } else if (this.jakartaNamedAnnotation != null) {
                    a = provider.getClass().getAnnotation(this.jakartaNamedAnnotation);
                }
                if (a != null) {
                    try {
                        value = this.nameGetter.invoke((Object)a, (Object[])null);
                    }
                    catch (IllegalAccessException | InvocationTargetException e2) {
                        throw new ServiceConfigurationError("Cannot get annotation value", e2);
                    }
                }
            }
            if (value == null) {
                value = provider.toString();
            }
            return this.toSearch.equals(value);
        }

        private int priority(ServiceProvider provider) {
            if (this.priorityGetter != null) {
                Annotation a = null;
                if (this.priorityAnnotation != null) {
                    a = provider.getClass().getAnnotation(this.priorityAnnotation);
                } else if (this.jakartaPriorityAnnotation != null) {
                    a = provider.getClass().getAnnotation(this.jakartaPriorityAnnotation);
                }
                if (a != null) {
                    try {
                        return (Integer)this.priorityGetter.invoke((Object)a, (Object[])null);
                    }
                    catch (IllegalAccessException | InvocationTargetException e2) {
                        throw new ServiceConfigurationError("Cannot get annotation value", e2);
                    }
                }
            }
            return provider.getPriority();
        }

        @Override
        public int compare(ServiceProvider p1, ServiceProvider p2) {
            return Integer.compare(this.priority(p2), this.priority(p1));
        }

        private Stream<ServiceProvider> stream() {
            Stream<ServiceProvider> stream = StreamSupport.stream(ServiceLoader.load(ServiceProvider.class).spliterator(), false);
            if (this.toSearch != null) {
                stream = stream.filter(this);
            }
            return stream.sorted(this);
        }
    }
}

