/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.auth;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.main.auth.BearerMode;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.http.auth.AuthHeader;
import org.slf4j.Logger;

public class AuthBearerFilter
implements Filter {
    private static Logger log = Fuseki.serverLog;
    private final Function<String, String> getPrincipalFromToken;
    private final BearerMode bearerMode;

    public AuthBearerFilter(Function<String, String> getPrincipalFromToken) {
        this(getPrincipalFromToken, BearerMode.REQUIRED);
    }

    public AuthBearerFilter(Function<String, String> getPrincipalFromToken, BearerMode bearerMode) {
        Objects.requireNonNull(bearerMode);
        Objects.requireNonNull(getPrincipalFromToken);
        this.getPrincipalFromToken = getPrincipalFromToken;
        this.bearerMode = bearerMode;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            AuthHeader authHeader;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String auth = this.getHttpAuthField(request);
            if (auth == null) {
                switch (this.bearerMode) {
                    case REQUIRED: {
                        this.sendResponseNoAuthPresent(response);
                        return;
                    }
                    case OPTIONAL: 
                    case NONE: {
                        chain.doFilter(request, response);
                        return;
                    }
                }
            }
            if (!(authHeader = this.getAuthToken(request, auth)).isBearerAuth()) {
                switch (this.bearerMode) {
                    case REQUIRED: {
                        this.sendResponseAuthBearerRequired(response);
                        return;
                    }
                    case OPTIONAL: 
                    case NONE: {
                        chain.doFilter(request, response);
                        return;
                    }
                }
            }
            if (this.bearerMode == BearerMode.NONE) {
                this.sendResponseAuthBearerDenied(response);
                return;
            }
            String bearerToken = authHeader.getBearerToken();
            if (bearerToken == null) {
                log.warn("Not a legal bearer token: " + authHeader.getAuthArgs());
                response.sendError(400);
                return;
            }
            this.validateAuthToken(request, bearerToken);
            if (this.getPrincipalFromToken == null) {
                response.sendError(400);
                return;
            }
            String user = this.getPrincipalFromToken.apply(bearerToken);
            if (user == null) {
                response.sendError(403);
                return;
            }
            HttpServletRequestWithPrincipal chainRequest = new HttpServletRequestWithPrincipal(request, user);
            chain.doFilter(chainRequest, servletResponse);
        }
        catch (Throwable ex) {
            log.warn("Filter: unexpected exception: " + ex.getMessage(), ex);
            ServletOps.error(500);
            return;
        }
    }

    @Override
    public void destroy() {
    }

    protected String getHttpAuthField(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    protected AuthHeader getAuthToken(HttpServletRequest request, String authHeaderValue) {
        return AuthHeader.parseAuth(authHeaderValue);
    }

    protected void validateAuthToken(HttpServletRequest request, String b64token) {
    }

    protected void sendResponseNoAuthPresent(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Bearer");
        response.sendError(401);
    }

    protected void sendResponseAuthBearerRequired(HttpServletResponse response) throws IOException {
        response.sendError(403);
    }

    protected void sendResponseAuthBearerDenied(HttpServletResponse response) throws IOException {
        response.sendError(400);
    }

    private static class HttpServletRequestWithPrincipal
    extends HttpServletRequestWrapper {
        private final String username;

        HttpServletRequestWithPrincipal(HttpServletRequest req, String username) {
            super(req);
            this.username = username;
        }

        @Override
        public String getRemoteUser() {
            return this.username;
        }

        @Override
        public Principal getUserPrincipal() {
            return () -> this.username;
        }
    }
}

