/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggAvgDistinct
extends AggregatorBase {
    private static Logger log = LoggerFactory.getLogger("AVG DISTINCT");
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvgDistinct(Expr expr) {
        super("AVG", true, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggAvgDistinct(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccAvgDistinct(this, this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToAvg);
    }

    @Override
    public int hashCode() {
        return 0x171 ^ this.getExprList().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggAvgDistinct)) {
            return false;
        }
        AggAvgDistinct a = (AggAvgDistinct)other;
        return this.exprList.equals(a.exprList, bySyntax);
    }

    class AccAvgDistinct
    extends AccumulatorExpr {
        private NodeValue total = noValuesToAvg;
        private int count = 0;

        public AccAvgDistinct(AggAvgDistinct this$0, Expr expr) {
            super(expr, true);
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                ++this.count;
                this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("avg: not a number: " + String.valueOf(nv));
            }
            log.debug("avg count {}", (Object)this.count);
        }

        @Override
        public NodeValue getAccValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.numDivide(this.total, nvCount);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

