/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.ConcurrentHnswMerger;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.HnswGraphMerger;
import org.apache.lucene.util.hnsw.IncrementalHnswGraphMerger;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicWriter;

public final class Lucene99HnswVectorsWriter
extends KnnVectorsWriter {
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Lucene99HnswVectorsWriter.class);
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorIndex;
    private final int M;
    private final int beamWidth;
    private final FlatVectorsWriter flatVectorWriter;
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;
    private final int version;
    private final List<FieldWriter<?>> fields = new ArrayList();
    private boolean finished;

    public Lucene99HnswVectorsWriter(SegmentWriteState state, int M, int beamWidth, FlatVectorsWriter flatVectorWriter, int numMergeWorkers, TaskExecutor mergeExec) throws IOException {
        this(state, M, beamWidth, flatVectorWriter, numMergeWorkers, mergeExec, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene99HnswVectorsWriter(SegmentWriteState state, int M, int beamWidth, FlatVectorsWriter flatVectorWriter, int numMergeWorkers, TaskExecutor mergeExec, int version2) throws IOException {
        this.M = M;
        this.flatVectorWriter = flatVectorWriter;
        this.beamWidth = beamWidth;
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec;
        this.version = version2;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        String indexDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene99HnswVectorsFormatMeta", version2, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorIndex, "Lucene99HnswVectorsFormatIndex", version2, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FieldWriter<?> newField = FieldWriter.create(this.flatVectorWriter.getFlatVectorScorer(), this.flatVectorWriter.addField(fieldInfo), fieldInfo, this.M, this.beamWidth, this.segmentWriteState.infoStream);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.flatVectorWriter.flush(maxDoc, sortMap);
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field);
                continue;
            }
            this.writeSortingField(field, sortMap);
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.flatVectorWriter.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorIndex != null) {
            CodecUtil.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter<?> fieldData) throws IOException {
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        int[][] graphLevelNodeOffsets = this.writeGraph(graph);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, vectorIndexOffset, vectorIndexLength, fieldData.getDocsWithFieldSet().cardinality(), graph, graphLevelNodeOffsets);
    }

    private void writeSortingField(FieldWriter<?> fieldData, Sorter.DocMap sortMap) throws IOException {
        int[] ordMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        int[] oldOrdMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        Lucene99HnswVectorsWriter.mapOldOrdToNewOrd(fieldData.getDocsWithFieldSet(), sortMap, oldOrdMap, ordMap, null);
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        int[][] graphLevelNodeOffsets = graph == null ? new int[][]{} : new int[graph.numLevels()][];
        HnswGraph mockGraph = this.reconstructAndWriteGraph(graph, ordMap, oldOrdMap, graphLevelNodeOffsets);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, vectorIndexOffset, vectorIndexLength, fieldData.getDocsWithFieldSet().cardinality(), mockGraph, graphLevelNodeOffsets);
    }

    private HnswGraph reconstructAndWriteGraph(final OnHeapHnswGraph graph, int[] newToOldMap, int[] oldToNewMap, int[][] levelNodeOffsets) throws IOException {
        if (graph == null) {
            return null;
        }
        final ArrayList<int[]> nodesByLevel = new ArrayList<int[]>(graph.numLevels());
        nodesByLevel.add(null);
        int maxOrd = graph.size();
        int[] scratch = new int[graph.maxConn() * 2];
        HnswGraph.NodesIterator nodesOnLevel0 = graph.getNodesOnLevel(0);
        levelNodeOffsets[0] = new int[nodesOnLevel0.size()];
        while (nodesOnLevel0.hasNext()) {
            int node = nodesOnLevel0.nextInt();
            NeighborArray neighbors = graph.getNeighbors(0, newToOldMap[node]);
            long offset = this.vectorIndex.getFilePointer();
            this.reconstructAndWriteNeighbours(neighbors, oldToNewMap, scratch, maxOrd);
            levelNodeOffsets[0][node] = Math.toIntExact(this.vectorIndex.getFilePointer() - offset);
        }
        for (int level = 1; level < graph.numLevels(); ++level) {
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            int[] newNodes = new int[nodesOnLevel.size()];
            int n = 0;
            while (nodesOnLevel.hasNext()) {
                newNodes[n] = oldToNewMap[nodesOnLevel.nextInt()];
                ++n;
            }
            Arrays.sort(newNodes);
            nodesByLevel.add(newNodes);
            levelNodeOffsets[level] = new int[newNodes.length];
            int nodeOffsetIndex = 0;
            for (int node : newNodes) {
                NeighborArray neighbors = graph.getNeighbors(level, newToOldMap[node]);
                long offset = this.vectorIndex.getFilePointer();
                this.reconstructAndWriteNeighbours(neighbors, oldToNewMap, scratch, maxOrd);
                levelNodeOffsets[level][nodeOffsetIndex++] = Math.toIntExact(this.vectorIndex.getFilePointer() - offset);
            }
        }
        return new HnswGraph(this){

            @Override
            public int nextNeighbor() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public void seek(int level, int target) {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public int size() {
                return graph.size();
            }

            @Override
            public int numLevels() {
                return graph.numLevels();
            }

            @Override
            public int maxConn() {
                return graph.maxConn();
            }

            @Override
            public int entryNode() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public int neighborCount() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public HnswGraph.NodesIterator getNodesOnLevel(int level) {
                if (level == 0) {
                    return graph.getNodesOnLevel(0);
                }
                return new HnswGraph.ArrayNodesIterator((int[])nodesByLevel.get(level), ((int[])nodesByLevel.get(level)).length);
            }
        };
    }

    private void reconstructAndWriteNeighbours(NeighborArray neighbors, int[] oldToNewMap, int[] scratch, int maxOrd) throws IOException {
        int i;
        int size = neighbors.size();
        int[] nnodes = neighbors.nodes();
        for (int i2 = 0; i2 < size; ++i2) {
            nnodes[i2] = oldToNewMap[nnodes[i2]];
        }
        Arrays.sort(nnodes, 0, size);
        int actualSize = 0;
        if (size > 0) {
            scratch[0] = nnodes[0];
            actualSize = 1;
        }
        for (i = 1; i < size; ++i) {
            assert (nnodes[i] < maxOrd) : "node too large: " + nnodes[i] + ">=" + maxOrd;
            if (nnodes[i - 1] == nnodes[i]) continue;
            scratch[actualSize++] = nnodes[i] - nnodes[i - 1];
        }
        this.vectorIndex.writeVInt(actualSize);
        if (this.version >= 1) {
            this.vectorIndex.writeGroupVInts(scratch, actualSize);
        } else {
            for (i = 0; i < actualSize; ++i) {
                this.vectorIndex.writeVInt(scratch[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        block11: {
            CloseableRandomVectorScorerSupplier scorerSupplier;
            block10: {
                scorerSupplier = this.flatVectorWriter.mergeOneFieldToIndex(fieldInfo, mergeState);
                boolean success = false;
                try {
                    long vectorIndexOffset = this.vectorIndex.getFilePointer();
                    OnHeapHnswGraph graph = null;
                    int[][] vectorIndexNodeOffsets = null;
                    if (scorerSupplier.totalVectorCount() > 0) {
                        HnswGraphMerger merger = this.createGraphMerger(fieldInfo, scorerSupplier, mergeState.intraMergeTaskExecutor == null ? null : new TaskExecutor(mergeState.intraMergeTaskExecutor), this.numMergeWorkers);
                        for (int i = 0; i < mergeState.liveDocs.length; ++i) {
                            if (!KnnVectorsWriter.MergedVectorValues.hasVectorValues(mergeState.fieldInfos[i], fieldInfo.name)) continue;
                            merger.addReader(mergeState.knnVectorsReaders[i], mergeState.docMaps[i], mergeState.liveDocs[i]);
                        }
                        KnnVectorValues mergedVectorValues = null;
                        switch (fieldInfo.getVectorEncoding()) {
                            case BYTE: {
                                mergedVectorValues = KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState);
                                break;
                            }
                            case FLOAT32: {
                                mergedVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
                            }
                        }
                        graph = merger.merge(mergedVectorValues, this.segmentWriteState.infoStream, scorerSupplier.totalVectorCount());
                        vectorIndexNodeOffsets = this.writeGraph(graph);
                    }
                    long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
                    this.writeMeta(fieldInfo, vectorIndexOffset, vectorIndexLength, scorerSupplier.totalVectorCount(), graph, vectorIndexNodeOffsets);
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(scorerSupplier);
                    } else {
                        IOUtils.closeWhileHandlingException(scorerSupplier);
                    }
                    throw throwable;
                }
                IOUtils.close(scorerSupplier);
                break block11;
            }
            IOUtils.closeWhileHandlingException(scorerSupplier);
        }
    }

    private int[][] writeGraph(OnHeapHnswGraph graph) throws IOException {
        if (graph == null) {
            return new int[0][0];
        }
        int countOnLevel0 = graph.size();
        int[][] offsets = new int[graph.numLevels()][];
        int[] scratch = new int[graph.maxConn() * 2];
        for (int level = 0; level < graph.numLevels(); ++level) {
            int[] sortedNodes = HnswGraph.NodesIterator.getSortedNodes(graph.getNodesOnLevel(level));
            offsets[level] = new int[sortedNodes.length];
            int nodeOffsetId = 0;
            for (int node : sortedNodes) {
                int i;
                NeighborArray neighbors = graph.getNeighbors(level, node);
                int size = neighbors.size();
                long offsetStart = this.vectorIndex.getFilePointer();
                int[] nnodes = neighbors.nodes();
                Arrays.sort(nnodes, 0, size);
                int actualSize = 0;
                if (size > 0) {
                    scratch[0] = nnodes[0];
                    actualSize = 1;
                }
                for (i = 1; i < size; ++i) {
                    assert (nnodes[i] < countOnLevel0) : "node too large: " + nnodes[i] + ">=" + countOnLevel0;
                    if (nnodes[i - 1] == nnodes[i]) continue;
                    scratch[actualSize++] = nnodes[i] - nnodes[i - 1];
                }
                this.vectorIndex.writeVInt(actualSize);
                if (this.version >= 1) {
                    this.vectorIndex.writeGroupVInts(scratch, actualSize);
                } else {
                    for (i = 0; i < actualSize; ++i) {
                        this.vectorIndex.writeVInt(scratch[i]);
                    }
                }
                offsets[level][nodeOffsetId++] = Math.toIntExact(this.vectorIndex.getFilePointer() - offsetStart);
            }
        }
        return offsets;
    }

    private void writeMeta(FieldInfo field, long vectorIndexOffset, long vectorIndexLength, int count, HnswGraph graph, int[][] graphLevelNodeOffsets) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(Lucene99HnswVectorsWriter.distFuncToOrd(field.getVectorSimilarityFunction()));
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeVInt(field.getVectorDimension());
        this.meta.writeInt(count);
        this.meta.writeVInt(this.M);
        if (graph == null) {
            this.meta.writeVInt(0);
        } else {
            this.meta.writeVInt(graph.numLevels());
            long valueCount = 0L;
            for (int level = 0; level < graph.numLevels(); ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                valueCount += (long)nodesOnLevel.size();
                if (level > 0) {
                    int[] nol = new int[nodesOnLevel.size()];
                    int numberConsumed = nodesOnLevel.consume(nol);
                    Arrays.sort(nol);
                    assert (numberConsumed == nodesOnLevel.size());
                    this.meta.writeVInt(nol.length);
                    for (int i = nodesOnLevel.size() - 1; i > 0; --i) {
                        int n = i;
                        nol[n] = nol[n] - nol[i - 1];
                    }
                    for (int n : nol) {
                        assert (n >= 0) : "delta encoding for nodes failed; expected nodes to be sorted";
                        this.meta.writeVInt(n);
                    }
                    continue;
                }
                assert (nodesOnLevel.size() == count) : "Level 0 expects to have all nodes";
            }
            long start = this.vectorIndex.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter memoryOffsetsWriter = DirectMonotonicWriter.getInstance(this.meta, this.vectorIndex, valueCount, 16);
            long cumulativeOffsetSum = 0L;
            int[][] nArray = graphLevelNodeOffsets;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] levelOffsets;
                for (int v : levelOffsets = nArray[i]) {
                    memoryOffsetsWriter.add(cumulativeOffsetSum);
                    cumulativeOffsetSum += (long)v;
                }
            }
            memoryOffsetsWriter.finish();
            this.meta.writeLong(this.vectorIndex.getFilePointer() - start);
        }
    }

    private HnswGraphMerger createGraphMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, TaskExecutor parallelMergeTaskExecutor, int numParallelMergeWorkers) {
        if (this.mergeExec != null) {
            return new ConcurrentHnswMerger(fieldInfo, scorerSupplier, this.M, this.beamWidth, this.mergeExec, this.numMergeWorkers);
        }
        if (parallelMergeTaskExecutor != null && numParallelMergeWorkers > 1) {
            return new ConcurrentHnswMerger(fieldInfo, scorerSupplier, this.M, this.beamWidth, parallelMergeTaskExecutor, numParallelMergeWorkers);
        }
        return new IncrementalHnswGraphMerger(fieldInfo, scorerSupplier, this.M, this.beamWidth);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorIndex, this.flatVectorWriter);
    }

    static int distFuncToOrd(VectorSimilarityFunction func) {
        for (int i = 0; i < Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.size(); ++i) {
            if (!Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.get(i).equals((Object)func)) continue;
            return (byte)i;
        }
        throw new IllegalArgumentException("invalid distance function: " + String.valueOf((Object)func));
    }

    private static class FieldWriter<T>
    extends KnnFieldVectorsWriter<T> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private final HnswGraphBuilder hnswGraphBuilder;
        private int lastDocID = -1;
        private int node = 0;
        private final FlatFieldVectorsWriter<T> flatFieldVectorsWriter;
        private UpdateableRandomVectorScorer scorer;

        static FieldWriter<?> create(FlatVectorsScorer scorer, FlatFieldVectorsWriter<?> flatFieldVectorsWriter, FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            return switch (fieldInfo.getVectorEncoding()) {
                default -> throw new MatchException(null, null);
                case VectorEncoding.BYTE -> new FieldWriter(scorer, flatFieldVectorsWriter, fieldInfo, M, beamWidth, infoStream);
                case VectorEncoding.FLOAT32 -> new FieldWriter(scorer, flatFieldVectorsWriter, fieldInfo, M, beamWidth, infoStream);
            };
        }

        FieldWriter(FlatVectorsScorer scorer, FlatFieldVectorsWriter<T> flatFieldVectorsWriter, FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            this.fieldInfo = fieldInfo;
            RandomVectorScorerSupplier scorerSupplier = switch (fieldInfo.getVectorEncoding()) {
                default -> throw new MatchException(null, null);
                case VectorEncoding.BYTE -> scorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), ByteVectorValues.fromBytes(flatFieldVectorsWriter.getVectors(), fieldInfo.getVectorDimension()));
                case VectorEncoding.FLOAT32 -> scorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), FloatVectorValues.fromFloats(flatFieldVectorsWriter.getVectors(), fieldInfo.getVectorDimension()));
            };
            this.scorer = scorerSupplier.scorer();
            this.hnswGraphBuilder = HnswGraphBuilder.create(scorerSupplier, M, beamWidth, HnswGraphBuilder.randSeed);
            this.hnswGraphBuilder.setInfoStream(infoStream);
            this.flatFieldVectorsWriter = Objects.requireNonNull(flatFieldVectorsWriter);
        }

        @Override
        public void addValue(int docID, T vectorValue) throws IOException {
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            this.flatFieldVectorsWriter.addValue(docID, vectorValue);
            this.scorer.setScoringOrdinal(this.node);
            this.hnswGraphBuilder.addGraphNode(this.node, this.scorer);
            ++this.node;
            this.lastDocID = docID;
        }

        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.flatFieldVectorsWriter.getDocsWithFieldSet();
        }

        @Override
        public T copyValue(T vectorValue) {
            throw new UnsupportedOperationException();
        }

        OnHeapHnswGraph getGraph() throws IOException {
            assert (this.flatFieldVectorsWriter.isFinished());
            if (this.node > 0) {
                return this.hnswGraphBuilder.getCompletedGraph();
            }
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return SHALLOW_SIZE + this.flatFieldVectorsWriter.ramBytesUsed() + this.hnswGraphBuilder.getGraph().ramBytesUsed();
        }
    }
}

