/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashSpi;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.SimpleByteSource;

public class SimpleHashProvider
implements HashSpi {
    private static final Set<String> IMPLEMENTED_ALGORITHMS = Arrays.stream(new String[]{"SHA-256", "SHA-384", "SHA-512"}).collect(Collectors.toSet());

    @Override
    public Set<String> getImplementedAlgorithms() {
        return Collections.unmodifiableSet(IMPLEMENTED_ALGORITHMS);
    }

    @Override
    public SimpleHash fromString(String format) {
        Hash hash = new Shiro1CryptFormat().parse(format);
        if (!(hash instanceof SimpleHash)) {
            throw new IllegalArgumentException("formatted string was not a simple hash: " + format);
        }
        return (SimpleHash)hash;
    }

    @Override
    public HashSpi.HashFactory newHashFactory(Random random) {
        return new SimpleHashFactory(random);
    }

    static class SimpleHashFactory
    implements HashSpi.HashFactory {
        private final Random random;

        SimpleHashFactory(Random random) {
            this.random = random;
        }

        @Override
        public SimpleHash generate(HashRequest hashRequest) {
            String algorithmName = hashRequest.getAlgorithmName().orElse("SHA-512");
            ByteSource source = hashRequest.getSource();
            int iterations = this.getIterations(hashRequest);
            ByteSource publicSalt = this.getPublicSalt(hashRequest);
            ByteSource secretSalt = this.getSecretSalt(hashRequest);
            ByteSource salt = this.combine(secretSalt, publicSalt);
            return this.createSimpleHash(algorithmName, source, iterations, publicSalt, salt);
        }

        protected ByteSource getPublicSalt(HashRequest request) {
            Optional<ByteSource> publicSalt = request.getSalt();
            if (publicSalt.isPresent() && !publicSalt.orElseThrow(NoSuchElementException::new).isEmpty()) {
                return publicSalt.orElseThrow(NoSuchElementException::new);
            }
            byte[] ps = new byte[16];
            this.random.nextBytes(ps);
            return new SimpleByteSource(ps);
        }

        private ByteSource getSecretSalt(HashRequest request) {
            Optional<Object> secretSalt = Optional.ofNullable(request.getParameters().get("SimpleHash.secretSalt"));
            return secretSalt.map(salt -> (String)salt).map(salt -> Base64.getDecoder().decode((String)salt)).map(SimpleByteSource::new).orElse(null);
        }

        private SimpleHash createSimpleHash(String algorithmName, ByteSource source, int iterations, ByteSource publicSalt, ByteSource salt) {
            SimpleHash computed = new SimpleHash(algorithmName, source, salt, iterations);
            SimpleHash result = new SimpleHash(algorithmName);
            result.setBytes(computed.getBytes());
            result.setIterations(iterations);
            result.setSalt(publicSalt);
            return result;
        }

        protected int getIterations(HashRequest request) {
            Object parameterIterations = request.getParameters().getOrDefault("SimpleHash.iterations", 0);
            if (!(parameterIterations instanceof Integer)) {
                return 50000;
            }
            int iterations = Math.max(0, (Integer)parameterIterations);
            if (iterations < 1) {
                return 50000;
            }
            return iterations;
        }

        protected ByteSource combine(ByteSource privateSalt, ByteSource publicSalt) {
            int j;
            byte[] publicSaltBytes;
            int extraBytesLength;
            byte[] privateSaltBytes = privateSalt != null ? privateSalt.getBytes() : null;
            int privateSaltLength = privateSaltBytes != null ? privateSaltBytes.length : 0;
            int length = privateSaltLength + (extraBytesLength = (publicSaltBytes = publicSalt.getBytes()).length);
            if (length <= 0) {
                return SimpleByteSource.empty();
            }
            byte[] combined = new byte[length];
            int i = 0;
            for (j = 0; j < privateSaltLength; ++j) {
                combined[i++] = privateSaltBytes[j];
            }
            for (j = 0; j < extraBytesLength; ++j) {
                combined[i++] = publicSaltBytes[j];
            }
            return ByteSource.Util.bytes(combined);
        }
    }

    public static final class Parameters {
        public static final String PARAMETER_ITERATIONS = "SimpleHash.iterations";
        public static final String PARAMETER_SECRET_SALT = "SimpleHash.secretSalt";
        public static final String DEFAULT_ALGORITHM = "SHA-512";
        public static final int DEFAULT_ITERATIONS = 50000;

        private Parameters() {
        }
    }
}

