/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import org.apache.felix.scr.impl.logger.AbstractLogger;
import org.apache.felix.scr.impl.logger.BundleLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

public class ComponentLogger
extends AbstractLogger {
    private final String name;
    private final String className;
    private final BundleLogger parent;
    private volatile int trackingCount = -3;
    private volatile InternalLogger currentLogger;

    public ComponentLogger(ComponentMetadata metadata, BundleLogger parent) {
        super(parent.getConfiguration(), "");
        this.parent = parent;
        this.name = metadata.getName() != null ? metadata.getName() : (metadata.getImplementationClassName() != null ? "implementation class " + metadata.getImplementationClassName() : "UNKNOWN");
        this.className = metadata.getImplementationClassName() != null ? metadata.getImplementationClassName() : null;
        this.setComponentId(-1L);
    }

    public void setComponentId(long id) {
        if (id > -1L) {
            this.setPrefix(this.parent.getPrefix() + "[" + this.name + "(" + id + ")] : ");
        } else {
            this.setPrefix(this.parent.getPrefix() + "[" + this.name + "] : ");
        }
    }

    @Override
    InternalLogger getLogger() {
        if (this.trackingCount < this.parent.getTrackingCount()) {
            this.currentLogger = this.parent.getLogger(this.className);
            this.trackingCount = this.parent.getTrackingCount();
        }
        return this.currentLogger;
    }

    @Override
    public boolean log(int level, String pattern, Throwable ex, Object ... arguments) {
        if (!super.log(level, pattern, ex, arguments)) {
            return this.parent.log(level, pattern, ex, arguments);
        }
        return false;
    }

    @Override
    public boolean log(int level, String message, Throwable ex) {
        if (!super.log(level, message, ex)) {
            return this.parent.log(level, message, ex);
        }
        return false;
    }
}

