/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import io.substrait.proto.FunctionArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.type.TypeNode;

public class ScalarFunctionNode
implements ExpressionNode,
Serializable {
    private final Long functionId;
    private final List<ExpressionNode> expressionNodes = new ArrayList<ExpressionNode>();
    private final TypeNode typeNode;

    ScalarFunctionNode(Long functionId, List<ExpressionNode> expressionNodes, TypeNode typeNode) {
        this.functionId = functionId;
        this.expressionNodes.addAll(expressionNodes);
        this.typeNode = typeNode;
    }

    @Override
    public Expression toProtobuf() {
        Expression.ScalarFunction.Builder scalarBuilder = Expression.ScalarFunction.newBuilder();
        scalarBuilder.setFunctionReference(this.functionId.intValue());
        for (ExpressionNode expressionNode : this.expressionNodes) {
            FunctionArgument.Builder functionArgument = FunctionArgument.newBuilder();
            functionArgument.setValue(expressionNode.toProtobuf());
            scalarBuilder.addArguments(functionArgument.build());
        }
        scalarBuilder.setOutputType(this.typeNode.toProtobuf());
        Expression.Builder builder = Expression.newBuilder();
        builder.setScalarFunction(scalarBuilder.build());
        return builder.build();
    }
}

