/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.NamedStruct;
import io.substrait.proto.ReadRel;
import io.substrait.proto.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.expression.ConverterUtils;
import org.apache.gluten.substrait.rel.SplitInfo;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class LocalFilesNode
implements SplitInfo {
    private final Integer index;
    private final List<String> paths = new ArrayList<String>();
    private final List<Long> starts = new ArrayList<Long>();
    private final List<Long> lengths = new ArrayList<Long>();
    private final List<Long> fileSizes = new ArrayList<Long>();
    private final List<Long> modificationTimes = new ArrayList<Long>();
    private final List<Map<String, String>> partitionColumns = new ArrayList<Map<String, String>>();
    private final List<Map<String, String>> metadataColumns = new ArrayList<Map<String, String>>();
    private final List<String> preferredLocations = new ArrayList<String>();
    protected ReadFileFormat fileFormat = ReadFileFormat.UnknownFormat;
    private Boolean iterAsInput = false;
    private StructType fileSchema;
    private Map<String, String> fileReadProperties;

    LocalFilesNode(Integer index, List<String> paths, List<Long> starts, List<Long> lengths, List<Long> fileSizes, List<Long> modificationTimes, List<Map<String, String>> partitionColumns, List<Map<String, String>> metadataColumns, ReadFileFormat fileFormat, List<String> preferredLocations, Map<String, String> properties) {
        this.index = index;
        this.paths.addAll(paths);
        this.starts.addAll(starts);
        this.lengths.addAll(lengths);
        this.fileSizes.addAll(fileSizes);
        this.modificationTimes.addAll(modificationTimes);
        this.fileFormat = fileFormat;
        this.partitionColumns.addAll(partitionColumns);
        this.metadataColumns.addAll(metadataColumns);
        this.preferredLocations.addAll(preferredLocations);
        this.fileReadProperties = properties;
    }

    LocalFilesNode(String iterPath) {
        this.index = null;
        this.paths.add(iterPath);
        this.iterAsInput = true;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> newPaths) {
        this.paths.clear();
        this.paths.addAll(newPaths);
    }

    public void setFileSchema(StructType schema) {
        this.fileSchema = schema;
    }

    private NamedStruct buildNamedStruct() {
        NamedStruct.Builder namedStructBuilder = NamedStruct.newBuilder();
        if (this.fileSchema != null) {
            Type.Struct.Builder structBuilder = Type.Struct.newBuilder();
            for (StructField field : this.fileSchema.fields()) {
                structBuilder.addTypes(ConverterUtils.getTypeNode(field.dataType(), field.nullable()).toProtobuf());
                namedStructBuilder.addNames(ConverterUtils.normalizeColName(field.name()));
            }
            namedStructBuilder.setStruct(structBuilder.build());
        }
        return namedStructBuilder.build();
    }

    @Override
    public List<String> preferredLocations() {
        return this.preferredLocations;
    }

    protected void processFileBuilder(ReadRel.LocalFiles.FileOrFiles.Builder fileBuilder, int index) {
    }

    @Override
    public ReadRel.LocalFiles toProtobuf() {
        ReadRel.LocalFiles.Builder localFilesBuilder = ReadRel.LocalFiles.newBuilder();
        if (this.iterAsInput.booleanValue() && !this.paths.isEmpty()) {
            ReadRel.LocalFiles.FileOrFiles.Builder fileBuilder = ReadRel.LocalFiles.FileOrFiles.newBuilder();
            fileBuilder.setUriFile(this.paths.get(0));
            localFilesBuilder.addItems(fileBuilder.build());
            return localFilesBuilder.build();
        }
        if (this.paths.size() != this.starts.size() || this.paths.size() != this.lengths.size()) {
            throw new RuntimeException("Invalid parameters.");
        }
        for (int i = 0; i < this.paths.size(); ++i) {
            Map<String, String> partitionColumn2;
            ReadRel.LocalFiles.FileOrFiles.Builder fileBuilder = ReadRel.LocalFiles.FileOrFiles.newBuilder();
            fileBuilder.setUriFile(this.paths.get(i));
            if (this.index != null) {
                fileBuilder.setPartitionIndex(this.index.intValue());
            }
            if (!(partitionColumn2 = this.partitionColumns.get(i)).isEmpty()) {
                partitionColumn2.forEach((key, value) -> {
                    ReadRel.LocalFiles.FileOrFiles.partitionColumn.Builder pcBuilder = ReadRel.LocalFiles.FileOrFiles.partitionColumn.newBuilder();
                    pcBuilder.setKey((String)key).setValue((String)value);
                    fileBuilder.addPartitionColumns(pcBuilder.build());
                });
            }
            fileBuilder.setLength(this.lengths.get(i));
            fileBuilder.setStart(this.starts.get(i));
            if (!this.fileSizes.isEmpty() && !this.modificationTimes.isEmpty() && this.fileSizes.size() == this.modificationTimes.size() && this.fileSizes.size() == this.paths.size()) {
                ReadRel.LocalFiles.FileOrFiles.fileProperties.Builder filePropsBuilder = ReadRel.LocalFiles.FileOrFiles.fileProperties.newBuilder();
                filePropsBuilder.setFileSize(this.fileSizes.get(i));
                filePropsBuilder.setModificationTime(this.modificationTimes.get(i));
                fileBuilder.setProperties(filePropsBuilder.build());
            }
            if (!this.metadataColumns.isEmpty()) {
                Map<String, String> metadataColumn2 = this.metadataColumns.get(i);
                if (!metadataColumn2.isEmpty()) {
                    metadataColumn2.forEach((key, value) -> {
                        ReadRel.LocalFiles.FileOrFiles.metadataColumn.Builder mcBuilder = ReadRel.LocalFiles.FileOrFiles.metadataColumn.newBuilder();
                        mcBuilder.setKey((String)key).setValue((String)value);
                        fileBuilder.addMetadataColumns(mcBuilder.build());
                    });
                }
            } else {
                ReadRel.LocalFiles.FileOrFiles.metadataColumn.Builder mcBuilder = ReadRel.LocalFiles.FileOrFiles.metadataColumn.newBuilder();
                fileBuilder.addMetadataColumns(mcBuilder.build());
            }
            NamedStruct namedStruct = this.buildNamedStruct();
            fileBuilder.setSchema(namedStruct);
            switch (this.fileFormat) {
                case ParquetReadFormat: {
                    ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions parquetReadOptions = ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions.newBuilder().setEnableRowGroupMaxminIndex(GlutenConfig.get().enableParquetRowGroupMaxMinIndex()).build();
                    fileBuilder.setParquet(parquetReadOptions);
                    break;
                }
                case OrcReadFormat: {
                    ReadRel.LocalFiles.FileOrFiles.OrcReadOptions orcReadOptions = ReadRel.LocalFiles.FileOrFiles.OrcReadOptions.newBuilder().build();
                    fileBuilder.setOrc(orcReadOptions);
                    break;
                }
                case DwrfReadFormat: {
                    ReadRel.LocalFiles.FileOrFiles.DwrfReadOptions dwrfReadOptions = ReadRel.LocalFiles.FileOrFiles.DwrfReadOptions.newBuilder().build();
                    fileBuilder.setDwrf(dwrfReadOptions);
                    break;
                }
                case TextReadFormat: {
                    String field_delimiter = this.fileReadProperties.getOrDefault("field_delimiter", ",");
                    String quote = this.fileReadProperties.getOrDefault("quote", "");
                    String header = this.fileReadProperties.getOrDefault("header", "0");
                    String escape = this.fileReadProperties.getOrDefault("escape", "");
                    String nullValue = this.fileReadProperties.getOrDefault("nullValue", "");
                    ReadRel.LocalFiles.FileOrFiles.TextReadOptions textReadOptions = ReadRel.LocalFiles.FileOrFiles.TextReadOptions.newBuilder().setFieldDelimiter(field_delimiter).setQuote(quote).setHeader(Long.parseLong(header)).setEscape(escape).setNullValue(nullValue).setMaxBlockSize(GlutenConfig.get().textInputMaxBlockSize()).setEmptyAsDefault(GlutenConfig.get().textIputEmptyAsDefault()).build();
                    fileBuilder.setText(textReadOptions);
                    break;
                }
                case JsonReadFormat: {
                    ReadRel.LocalFiles.FileOrFiles.JsonReadOptions jsonReadOptions = ReadRel.LocalFiles.FileOrFiles.JsonReadOptions.newBuilder().setMaxBlockSize(GlutenConfig.get().textInputMaxBlockSize()).build();
                    fileBuilder.setJson(jsonReadOptions);
                    break;
                }
            }
            this.processFileBuilder(fileBuilder, i);
            localFilesBuilder.addItems(fileBuilder.build());
        }
        return localFilesBuilder.build();
    }

    public static enum ReadFileFormat {
        ParquetReadFormat,
        ArrowReadFormat,
        OrcReadFormat,
        DwrfReadFormat,
        MergeTreeReadFormat,
        TextReadFormat,
        JsonReadFormat,
        UnknownFormat;

    }
}

