/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.http.client.utils.DateUtils;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;

public class QueryRecItem
implements Serializable {
    private static final int DEATH_LOOP_DETECT = 10000;
    private String queryId;
    private String sql;
    private long totalScanBytes;
    private long totalScanCount;
    private long resultRowCount;
    private long cpuTime;
    private long duration;
    private String project;
    private String modelIds;
    private String submitter;
    private String server;
    private String errorType;
    private String engineType;
    private boolean cacheHit;
    private boolean indexHit;
    private boolean isTableIndexUsed;
    private boolean isAggIndexUsed;
    private boolean isTableSnapshotUsed;
    private String queryStatus;
    private long queryTime;
    private long queryDay;
    private long queryFirstDayOfMonth;
    private long queryFirstDayOfWeek;
    private String day;
    private boolean isAccelerated = true;
    private String accFailedReason;
    private Map<String, RecDetail> recDetailMap = Maps.newHashMap();

    public QueryRecItem(QueryHistory queryHistory) {
        this.queryId = queryHistory.getQueryId();
        this.sql = queryHistory.getQueryHistorySql().getNormalizedSql();
        this.project = queryHistory.getProjectName();
        this.submitter = queryHistory.getQuerySubmitter();
        this.server = queryHistory.getHostName();
        this.errorType = queryHistory.getErrorType();
        this.engineType = queryHistory.getEngineType();
        this.queryStatus = queryHistory.getQueryStatus();
        this.cacheHit = queryHistory.isCacheHit();
        this.indexHit = queryHistory.isIndexHit();
        this.isTableIndexUsed = queryHistory.isIndexHit();
        this.queryTime = queryHistory.getQueryTime();
        Date date = new Date(this.queryTime);
        this.day = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd");
        this.queryDay = TimeUtil.getDayStart((long)this.queryTime);
        this.queryFirstDayOfMonth = TimeUtil.getMonthStart((long)this.queryTime);
        this.queryFirstDayOfWeek = TimeUtil.getWeekStart((long)this.queryTime);
        this.totalScanBytes = queryHistory.getTotalScanBytes();
        this.totalScanCount = queryHistory.getTotalScanCount();
        this.resultRowCount = queryHistory.getResultRowCount();
        this.cpuTime = queryHistory.getCpuTime() == null ? 0L : queryHistory.getCpuTime();
        this.duration = queryHistory.getDuration();
    }

    public RecDetail getRecDetail(NDataModel model) {
        RecDetail recDetail;
        if (this.getRecDetailMap().containsKey(model.getId())) {
            recDetail = this.getRecDetailMap().get(model.getId());
        } else {
            recDetail = new RecDetail(model);
            this.getRecDetailMap().put(model.getId(), recDetail);
        }
        return recDetail;
    }

    public void addLayout(LayoutEntity layout, NDataModel model) {
        this.getRecDetail(model).getLayouts().add(new RecInfo(layout, model, Collections.emptyMap()));
    }

    public void addLayoutRec(LayoutEntity layout, NDataModel model, Map<String, RawRecItem> nonLayoutRecItemIdMap) {
        try {
            this.getRecDetail(model).getLayoutRecs().add(new RecInfo(layout, model, nonLayoutRecItemIdMap));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public long getTotalScanBytes() {
        return this.totalScanBytes;
    }

    @Generated
    public long getTotalScanCount() {
        return this.totalScanCount;
    }

    @Generated
    public long getResultRowCount() {
        return this.resultRowCount;
    }

    @Generated
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getModelIds() {
        return this.modelIds;
    }

    @Generated
    public String getSubmitter() {
        return this.submitter;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getErrorType() {
        return this.errorType;
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }

    @Generated
    public boolean isCacheHit() {
        return this.cacheHit;
    }

    @Generated
    public boolean isIndexHit() {
        return this.indexHit;
    }

    @Generated
    public boolean isTableIndexUsed() {
        return this.isTableIndexUsed;
    }

    @Generated
    public boolean isAggIndexUsed() {
        return this.isAggIndexUsed;
    }

    @Generated
    public boolean isTableSnapshotUsed() {
        return this.isTableSnapshotUsed;
    }

    @Generated
    public String getQueryStatus() {
        return this.queryStatus;
    }

    @Generated
    public long getQueryTime() {
        return this.queryTime;
    }

    @Generated
    public long getQueryDay() {
        return this.queryDay;
    }

    @Generated
    public long getQueryFirstDayOfMonth() {
        return this.queryFirstDayOfMonth;
    }

    @Generated
    public long getQueryFirstDayOfWeek() {
        return this.queryFirstDayOfWeek;
    }

    @Generated
    public String getDay() {
        return this.day;
    }

    @Generated
    public boolean isAccelerated() {
        return this.isAccelerated;
    }

    @Generated
    public String getAccFailedReason() {
        return this.accFailedReason;
    }

    @Generated
    public Map<String, RecDetail> getRecDetailMap() {
        return this.recDetailMap;
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setTotalScanBytes(long totalScanBytes) {
        this.totalScanBytes = totalScanBytes;
    }

    @Generated
    public void setTotalScanCount(long totalScanCount) {
        this.totalScanCount = totalScanCount;
    }

    @Generated
    public void setResultRowCount(long resultRowCount) {
        this.resultRowCount = resultRowCount;
    }

    @Generated
    public void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setModelIds(String modelIds) {
        this.modelIds = modelIds;
    }

    @Generated
    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    @Generated
    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    @Generated
    public void setCacheHit(boolean cacheHit) {
        this.cacheHit = cacheHit;
    }

    @Generated
    public void setIndexHit(boolean indexHit) {
        this.indexHit = indexHit;
    }

    @Generated
    public void setTableIndexUsed(boolean isTableIndexUsed) {
        this.isTableIndexUsed = isTableIndexUsed;
    }

    @Generated
    public void setAggIndexUsed(boolean isAggIndexUsed) {
        this.isAggIndexUsed = isAggIndexUsed;
    }

    @Generated
    public void setTableSnapshotUsed(boolean isTableSnapshotUsed) {
        this.isTableSnapshotUsed = isTableSnapshotUsed;
    }

    @Generated
    public void setQueryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
    }

    @Generated
    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    @Generated
    public void setQueryDay(long queryDay) {
        this.queryDay = queryDay;
    }

    @Generated
    public void setQueryFirstDayOfMonth(long queryFirstDayOfMonth) {
        this.queryFirstDayOfMonth = queryFirstDayOfMonth;
    }

    @Generated
    public void setQueryFirstDayOfWeek(long queryFirstDayOfWeek) {
        this.queryFirstDayOfWeek = queryFirstDayOfWeek;
    }

    @Generated
    public void setDay(String day) {
        this.day = day;
    }

    @Generated
    public void setAccelerated(boolean isAccelerated) {
        this.isAccelerated = isAccelerated;
    }

    @Generated
    public void setAccFailedReason(String accFailedReason) {
        this.accFailedReason = accFailedReason;
    }

    @Generated
    public void setRecDetailMap(Map<String, RecDetail> recDetailMap) {
        this.recDetailMap = recDetailMap;
    }

    @Generated
    public QueryRecItem() {
    }

    public static class RecInfo
    implements Serializable {
        @JsonIgnore
        private transient Map<String, RawRecItem> nonLayoutRecItemMap;
        @JsonIgnore
        private transient NDataModel dataModel;
        private String uniqueId;
        private List<String> columns = new ArrayList<String>();
        private List<String> dimensions = new ArrayList<String>();
        private List<NDataModel.Measure> measures = new ArrayList<NDataModel.Measure>();
        private List<String> shardBy = new ArrayList<String>();
        private List<String> sortBy = new ArrayList<String>();
        private Map<String, String> ccExpression = new HashMap<String, String>();
        private Map<String, String> ccType = new HashMap<String, String>();

        public RecInfo(LayoutEntity layoutEntity, NDataModel dataModel, Map<String, RawRecItem> nonLayoutRecItemMap) {
            this.dataModel = dataModel;
            this.nonLayoutRecItemMap = nonLayoutRecItemMap;
            for (Integer colId : layoutEntity.getColOrder()) {
                this.acquireDependencies(colId, new AtomicInteger());
            }
            for (Integer colId : layoutEntity.getShardByColumns()) {
                this.shardBy.add(this.getColumnNameById(colId));
            }
            for (Integer colId : layoutEntity.getShardByColumns()) {
                this.sortBy.add(this.getColumnNameById(colId));
            }
            this.initUniqueId();
        }

        private void initUniqueId() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String dim : this.dimensions) {
                if (!first) {
                    builder.append(',');
                }
                first = false;
                builder.append(dim);
            }
            builder.append('@');
            first = true;
            for (NDataModel.Measure measure : this.measures) {
                if (!first) {
                    builder.append(',');
                }
                first = false;
                builder.append(measure.getFunction().getFullExpression());
            }
            builder.append('@');
            for (String shardByCol : this.shardBy) {
                builder.append(',').append(shardByCol);
            }
            builder.append('@');
            for (String sortByCol : this.sortBy) {
                builder.append(',').append(sortByCol);
            }
            this.uniqueId = RawRecUtil.computeMD5((String)builder.toString());
        }

        private void addColumn(TblColRef column) {
            if (!this.columns.contains(column.getIdentity())) {
                this.columns.add(column.getIdentity());
            }
        }

        private void addColumn(String column) {
            if (!this.columns.contains(column)) {
                this.columns.add(column);
            }
        }

        private void addColumn(NDataModel.NamedColumn column) {
            TblColRef col = this.dataModel.getColRef(column.getAliasDotColumn());
            if (col.getColumnDesc().isComputedColumn()) {
                this.addColumnRelatedCC(col);
            } else {
                this.addColumn(col);
            }
        }

        private void addMeasure(NDataModel.Measure measure) {
            this.measures.add(measure);
            for (ParameterDesc parameterDesc : measure.getFunction().getParameters()) {
                if (!parameterDesc.isColumnType()) continue;
                TblColRef colRef = parameterDesc.getColRef();
                if (colRef != null) {
                    this.addColumn(colRef);
                    continue;
                }
                this.addColumn(parameterDesc.getValue());
            }
        }

        private void addColumnRelatedCC(TblColRef col) {
            for (ComputedColumnDesc cc : this.dataModel.getComputedColumnDescs()) {
                if (!cc.getColumnName().equals(col.getName())) continue;
                this.addCC(cc);
            }
        }

        private void addCC(ComputedColumnDesc cc) {
            if (this.ccExpression.containsKey(cc.getFullName())) {
                return;
            }
            this.ccExpression.put(cc.getFullName(), cc.getInnerExpression());
            this.ccType.put(cc.getFullName(), cc.getDatatype());
            List exprIdentifiers = ComputedColumnUtil.ExprIdentifierFinder.getExprIdentifiers((String)cc.getExpression());
            ImmutableBiMap effectiveCols = this.dataModel.getEffectiveCols();
            HashMap map = Maps.newHashMap();
            effectiveCols.forEach((k, v) -> map.put(v.getIdentity(), k));
            for (Pair exprIdentifier : exprIdentifiers) {
                String columnName = (String)exprIdentifier.getFirst() + "." + (String)exprIdentifier.getSecond();
                this.addColumn(this.dataModel.getColRef(columnName));
            }
        }

        private void addDimension(NDataModel.NamedColumn column) {
            this.dimensions.add(column.getAliasDotColumn());
            this.addColumn(column);
        }

        private void acquireDependencies(Integer id, AtomicInteger countLoop) {
            if (countLoop.incrementAndGet() > 10000 || Integer.MAX_VALUE == id) {
                return;
            }
            if (id < 0) {
                this.acquireRecItemDependencies(id, countLoop);
            } else if (id < 100000) {
                NDataModel.NamedColumn column = (NDataModel.NamedColumn)this.dataModel.getEffectiveNamedColumns().get(id);
                if (countLoop.get() == 1) {
                    this.addDimension(column);
                } else {
                    this.addColumn(column);
                }
            } else {
                NDataModel.Measure measure = (NDataModel.Measure)this.dataModel.getEffectiveMeasures().get((Object)id);
                this.addMeasure(measure);
            }
        }

        private String getColumnNameById(Integer id) {
            if (id < 0) {
                RawRecItem rawRecItem = this.nonLayoutRecItemMap.get(id + "");
                CCRecItemV2 cc = (CCRecItemV2)rawRecItem.getRecEntity();
                return cc.getCc().getFullName();
            }
            return ((NDataModel.NamedColumn)this.dataModel.getEffectiveNamedColumns().get(id)).getAliasDotColumn();
        }

        private void acquireRecItemDependencies(Integer id, AtomicInteger countLoop) {
            RawRecItem rawRecItem = this.nonLayoutRecItemMap.get(id + "");
            if (rawRecItem.getRecEntity() instanceof DimensionRecItemV2) {
                DimensionRecItemV2 dimensionRec = (DimensionRecItemV2)rawRecItem.getRecEntity();
                this.addDimension(dimensionRec.getColumn());
            }
            if (rawRecItem.getRecEntity() instanceof CCRecItemV2) {
                CCRecItemV2 cc = (CCRecItemV2)rawRecItem.getRecEntity();
                this.addCC(cc.getCc());
            }
            if (rawRecItem.getRecEntity() instanceof MeasureRecItemV2) {
                MeasureRecItemV2 measure = (MeasureRecItemV2)rawRecItem.getRecEntity();
                this.checkIsValidMeasure(measure.getMeasure(), rawRecItem.getDependIDs());
                this.addMeasure(measure.getMeasure());
            }
            int[] nArray = rawRecItem.getDependIDs();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer dependId = nArray[i];
                this.acquireDependencies(dependId, countLoop);
            }
        }

        private void checkIsValidMeasure(NDataModel.Measure measure, int[] dependIds) {
            int index = 0;
            for (ParameterDesc parameterDesc : measure.getFunction().getParameters()) {
                if (dependIds[index] == Integer.MAX_VALUE && parameterDesc.isColumnType()) {
                    throw new KylinRuntimeException("bad measureRecItem, ignore this layout rec");
                }
                ++index;
            }
        }

        @Generated
        public void setNonLayoutRecItemMap(Map<String, RawRecItem> nonLayoutRecItemMap) {
            this.nonLayoutRecItemMap = nonLayoutRecItemMap;
        }

        @Generated
        public void setDataModel(NDataModel dataModel) {
            this.dataModel = dataModel;
        }

        @Generated
        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Generated
        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        @Generated
        public void setDimensions(List<String> dimensions) {
            this.dimensions = dimensions;
        }

        @Generated
        public void setMeasures(List<NDataModel.Measure> measures) {
            this.measures = measures;
        }

        @Generated
        public void setShardBy(List<String> shardBy) {
            this.shardBy = shardBy;
        }

        @Generated
        public void setSortBy(List<String> sortBy) {
            this.sortBy = sortBy;
        }

        @Generated
        public void setCcExpression(Map<String, String> ccExpression) {
            this.ccExpression = ccExpression;
        }

        @Generated
        public void setCcType(Map<String, String> ccType) {
            this.ccType = ccType;
        }

        @Generated
        public Map<String, RawRecItem> getNonLayoutRecItemMap() {
            return this.nonLayoutRecItemMap;
        }

        @Generated
        public NDataModel getDataModel() {
            return this.dataModel;
        }

        @Generated
        public String getUniqueId() {
            return this.uniqueId;
        }

        @Generated
        public List<String> getColumns() {
            return this.columns;
        }

        @Generated
        public List<String> getDimensions() {
            return this.dimensions;
        }

        @Generated
        public List<NDataModel.Measure> getMeasures() {
            return this.measures;
        }

        @Generated
        public List<String> getShardBy() {
            return this.shardBy;
        }

        @Generated
        public List<String> getSortBy() {
            return this.sortBy;
        }

        @Generated
        public Map<String, String> getCcExpression() {
            return this.ccExpression;
        }

        @Generated
        public Map<String, String> getCcType() {
            return this.ccType;
        }

        @Generated
        public RecInfo() {
        }
    }

    public static class RecDetail
    implements Serializable {
        private String modelId;
        private int semanticVersion;
        private List<RecInfo> layouts = new ArrayList<RecInfo>();
        private List<RecInfo> layoutRecs = new ArrayList<RecInfo>();

        public RecDetail(NDataModel dataModel) {
            this.modelId = dataModel.getUuid();
            this.semanticVersion = dataModel.getSemanticVersion();
        }

        @Generated
        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Generated
        public void setSemanticVersion(int semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Generated
        public void setLayouts(List<RecInfo> layouts) {
            this.layouts = layouts;
        }

        @Generated
        public void setLayoutRecs(List<RecInfo> layoutRecs) {
            this.layoutRecs = layoutRecs;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public int getSemanticVersion() {
            return this.semanticVersion;
        }

        @Generated
        public List<RecInfo> getLayouts() {
            return this.layouts;
        }

        @Generated
        public List<RecInfo> getLayoutRecs() {
            return this.layoutRecs;
        }

        @Generated
        public RecDetail() {
        }
    }
}

