/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.request.AutoIndexPlanRuleUpdateRequest;

public class AutoIndexPlanRuleUtil {
    private AutoIndexPlanRuleUtil() {
    }

    public static void checkUpdateFavoriteRuleArgs(AutoIndexPlanRuleUpdateRequest request) {
        if (!request.isIndexPlannerEnable()) {
            return;
        }
        AutoIndexPlanRuleUtil.checkRange(request.getAutoIndexPlanOption(), 0, 2);
        KylinConfig config = NProjectManager.getProjectConfig((String)request.getProject());
        if (!config.isSemiAutoMode()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SEMI_AUTO_NOT_ENABLED, MsgPicker.getMsg().getSemiAutoNotEnabled());
        }
        if (!FavoriteRule.AUTO_COMPLETE_MODES.contains(request.getAutoIndexPlanAutoCompleteMode())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_AUTO_COMPLETE_MODE, MsgPicker.getMsg().getAutoCompleteModeNotValid());
        }
        if ("ABSOLUTE".equals(request.getAutoIndexPlanAutoCompleteMode())) {
            AutoIndexPlanRuleUtil.checkDateFormat(request.getAutoIndexPlanAbsoluteBeginDate());
        } else {
            if (!FavoriteRule.DATE_UNIT_CANDIDATES.contains(request.getAutoIndexPlanRelativeTimeUnit())) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_DATE_UNIT, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidDateUnit(), request.getAutoIndexPlanRelativeTimeUnit()));
            }
            AutoIndexPlanRuleUtil.checkRange(request.getAutoIndexPlanRelativeTimeInterval(), 0, 1000);
        }
        AutoIndexPlanRuleUtil.checkRange(request.getIndexPlannerMaxIndexCount(), 1, 100000);
        AutoIndexPlanRuleUtil.checkRange(request.getIndexPlannerMaxChangeCount(), 0, Math.min(request.getIndexPlannerMaxIndexCount(), 100));
    }

    private static void checkDateFormat(String value) {
        boolean isRightFormat = true;
        if (value == null) {
            isRightFormat = false;
        } else {
            try {
                LocalDate.parse(value);
            }
            catch (Exception e) {
                isRightFormat = false;
            }
        }
        if (!isRightFormat) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_DATE_FORMAT, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidDateFormat(), "yyyy-MM-dd", value));
        }
    }

    private static void checkRange(Integer value, int start, int end) {
        boolean inRightRange;
        if (value == null) {
            inRightRange = false;
        } else {
            boolean bl = inRightRange = value >= start && value <= end;
        }
        if (!inRightRange) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_RANGE, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidRange(), value, start, end));
        }
    }

    public static Object getRuleValue(FavoriteRule rule) {
        String ruleName;
        if (rule == null) {
            return null;
        }
        List conditions = rule.getConds().stream().filter(condition -> condition instanceof FavoriteRule.Condition).map(condition -> (FavoriteRule.Condition)condition).collect(Collectors.toList());
        String right = null;
        if (conditions.size() == 1) {
            FavoriteRule.Condition condition2 = (FavoriteRule.Condition)conditions.get(0);
            right = condition2.getRightThreshold();
        }
        switch (ruleName = rule.getName()) {
            case "auto_index_plan_option": {
                return AutoIndexPlanRuleUtil.getInteger(right, 0);
            }
            case "index_planner_enable": {
                return AutoIndexPlanRuleUtil.getBoolean(right, null);
            }
            case "auto_index_plan_segment_job_enable": 
            case "auto_index_plan_auto_change_index_enable": {
                return AutoIndexPlanRuleUtil.getBoolean(right, true);
            }
            case "index_planner_max_index_count": {
                return AutoIndexPlanRuleUtil.getInteger(right, 100);
            }
            case "index_planner_max_change_count": {
                return AutoIndexPlanRuleUtil.getInteger(right, 10);
            }
            case "index_planner_level": {
                return right == null ? FavoriteRule.IndexPlannerLevelType.BALANCED.name() : right;
            }
            case "auto_index_plan_auto_complete_mode": {
                return right == null ? "ABSOLUTE" : right;
            }
            case "auto_index_plan_relative_time_interval": {
                return AutoIndexPlanRuleUtil.getInteger(right, 12);
            }
            case "auto_index_plan_relative_time_unit": {
                return right == null ? "MONTH" : right;
            }
            case "auto_index_plan_absolute_begin_date": {
                return right;
            }
        }
        return null;
    }

    private static Boolean getBoolean(String value, Boolean defaultValue) {
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)value, (CharSequence)"null")) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static Integer getInteger(String value, Integer defaultValue) {
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)value, (CharSequence)"null")) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static List<FavoriteRule.AbstractCondition> getConditionsFromUpdateRequest(String ruleName, AutoIndexPlanRuleUpdateRequest request) {
        ArrayList conds = Lists.newArrayList();
        switch (ruleName) {
            case "auto_index_plan_option": {
                conds.add(new FavoriteRule.Condition(null, Objects.toString(request.getAutoIndexPlanOption())));
                break;
            }
            case "index_planner_enable": {
                conds.add(new FavoriteRule.Condition(null, Boolean.toString(request.isIndexPlannerEnable())));
                break;
            }
            case "auto_index_plan_auto_change_index_enable": {
                conds.add(new FavoriteRule.Condition(null, Boolean.toString(request.isAutoIndexPlanAutoChangeIndexEnable())));
                break;
            }
            case "index_planner_max_index_count": {
                conds.add(new FavoriteRule.Condition(null, Objects.toString(request.getIndexPlannerMaxIndexCount())));
                break;
            }
            case "index_planner_max_change_count": {
                conds.add(new FavoriteRule.Condition(null, Objects.toString(request.getIndexPlannerMaxChangeCount())));
                break;
            }
            case "index_planner_level": {
                conds.add(new FavoriteRule.Condition(null, Objects.toString(request.getIndexPlannerLevel())));
                break;
            }
            case "auto_index_plan_auto_complete_mode": {
                conds.add(new FavoriteRule.Condition(null, request.getAutoIndexPlanAutoCompleteMode()));
                break;
            }
            case "auto_index_plan_relative_time_interval": {
                conds.add(new FavoriteRule.Condition(null, Objects.toString(request.getAutoIndexPlanRelativeTimeInterval())));
                break;
            }
            case "auto_index_plan_relative_time_unit": {
                conds.add(new FavoriteRule.Condition(null, request.getAutoIndexPlanRelativeTimeUnit()));
                break;
            }
            case "auto_index_plan_absolute_begin_date": {
                conds.add(new FavoriteRule.Condition(null, request.getAutoIndexPlanAbsoluteBeginDate()));
                break;
            }
            case "auto_index_plan_segment_job_enable": {
                conds.add(new FavoriteRule.Condition(null, Boolean.toString(request.isAutoIndexPlanSegmentJobEnable())));
                break;
            }
        }
        return conds;
    }
}

