/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.gluten.GlutenBuildInfo$;
import org.apache.gluten.component.Component;
import org.apache.gluten.component.Component$;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.events.GlutenBuildInfoEvent;
import org.apache.gluten.events.GlutenEvent;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.extension.GlutenSessionExtensions$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.softaffinity.SoftAffinityListener$;
import org.apache.spark.sql.execution.ui.GlutenEventUtils$;
import org.apache.spark.sql.execution.ui.GlutenSQLAppStatusListener$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.SparkResourceUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194QAC\u0006\u0001\u0017EAQA\u000b\u0001\u0005\u00021Bqa\f\u0001A\u0002\u0013%\u0001\u0007C\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\t\r\t\u0003\u0001\u0015)\u00032\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015!\u0007\u0001\"\u0003f\u0011\u00159\u0007\u0001\"\u0003i\u0005I9E.\u001e;f]\u0012\u0013\u0018N^3s!2,x-\u001b8\u000b\u00051i\u0011AB4mkR,gN\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0003\u0002\u0001\u00135\u0011\u0002\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\t1\fgn\u001a\u0006\u0002/\u0005!!.\u0019<b\u0013\tIBC\u0001\u0004PE*,7\r\u001e\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\ta\u0001\u001d7vO&t'BA\u0010!\u0003\r\t\u0007/\u001b\u0006\u0003C5\tQa\u001d9be.L!a\t\u000f\u0003\u0019\u0011\u0013\u0018N^3s!2,x-\u001b8\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\u0002\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ\u0006\u0005\u0002/\u00015\t1\"A\u0002`g\u000e,\u0012!\r\t\u0004eU:T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r=\u0003H/[8o!\tA\u0014(D\u0001!\u0013\tQ\u0004E\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0004`g\u000e|F%Z9\u0015\u0005u\u0002\u0005C\u0001\u001a?\u0013\ty4G\u0001\u0003V]&$\bbB!\u0004\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\n\u0014\u0001B0tG\u0002\nA!\u001b8jiR\u0019QI\u0016-\u0011\t\u0019K5jS\u0007\u0002\u000f*\u0011\u0001JF\u0001\u0005kRLG.\u0003\u0002K\u000f\n\u0019Q*\u00199\u0011\u00051\u001bfBA'R!\tq5'D\u0001P\u0015\t\u00016&\u0001\u0004=e>|GOP\u0005\u0003%N\na\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!k\r\u0005\u0006/\u0016\u0001\raN\u0001\u0003g\u000eDQ!W\u0003A\u0002i\u000bQ\u0002\u001d7vO&t7i\u001c8uKb$\bCA\u000e\\\u0013\taFDA\u0007QYV<\u0017N\\\"p]R,\u0007\u0010^\u0001\u0010e\u0016<\u0017n\u001d;fe6+GO]5dgR\u0019QhX1\t\u000b\u00014\u0001\u0019A&\u0002\u000b\u0005\u0004\b/\u00133\t\u000be3\u0001\u0019\u0001.\u0002\u0011MDW\u000f\u001e3po:$\u0012!P\u0001\u0013a>\u001cHOQ;jY\u0012LeNZ8Fm\u0016tG\u000f\u0006\u0002>M\")q\u000b\u0003a\u0001o\u0005!2/\u001a;Qe\u0016$WMZ5oK\u0012\u001cuN\u001c4jON$\"!P5\t\u000b)L\u0001\u0019A6\u0002\t\r|gN\u001a\t\u0003q1L!!\u001c\u0011\u0003\u0013M\u0003\u0018M]6D_:4\u0007")
public class GlutenDriverPlugin
implements DriverPlugin,
Logging {
    private Option<SparkContext> _sc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Object receive(Object x$1) throws Exception {
        return super.receive(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<SparkContext> _sc() {
        return this._sc;
    }

    private void _sc_$eq(Option<SparkContext> x$1) {
        this._sc = x$1;
    }

    public Map<String, String> init(SparkContext sc, PluginContext pluginContext) {
        this._sc_$eq((Option<SparkContext>)new Some((Object)sc));
        SparkConf conf = pluginContext.conf();
        GlutenSQLAppStatusListener$.MODULE$.register(sc);
        if (conf.getBoolean(GlutenConfig$.MODULE$.GLUTEN_SOFT_AFFINITY_ENABLED(), GlutenConfig$.MODULE$.GLUTEN_SOFT_AFFINITY_ENABLED_DEFAULT_VALUE())) {
            SoftAffinityListener$.MODULE$.register(sc);
        }
        this.postBuildInfoEvent(sc);
        this.setPredefinedConfigs(conf);
        Component$.MODULE$.sorted().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onDriverStart(sc, pluginContext);
            return BoxedUnit.UNIT;
        });
        return Collections.emptyMap();
    }

    public void registerMetrics(String appId, PluginContext pluginContext) {
        block0: {
            if (!pluginContext.conf().getBoolean(GlutenConfig$.MODULE$.GLUTEN_UI_ENABLED(), true)) break block0;
            this._sc().foreach((Function1 & Serializable & scala.Serializable)sc -> {
                GlutenDriverPlugin.$anonfun$registerMetrics$1(this, sc);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void shutdown() {
        ((IterableLike)Component$.MODULE$.sorted().reverse()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onDriverShutdown();
            return BoxedUnit.UNIT;
        });
    }

    private void postBuildInfoEvent(SparkContext sc) {
        System.setProperty("gluten.version", GlutenBuildInfo$.MODULE$.VERSION());
        LinkedHashMap glutenBuildInfo = new LinkedHashMap();
        Seq<Component> components = Component$.MODULE$.sorted();
        glutenBuildInfo.put((Object)"Components", (Object)((TraversableOnce)components.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.buildInfo().name(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
        components.foreach((Function1 & Serializable & scala.Serializable)comp -> {
            Component.BuildInfo buildInfo = comp.buildInfo();
            glutenBuildInfo.put((Object)new StringBuilder(17).append("Component ").append(buildInfo.name()).append(" Branch").toString(), (Object)buildInfo.branch());
            glutenBuildInfo.put((Object)new StringBuilder(19).append("Component ").append(buildInfo.name()).append(" Revision").toString(), (Object)buildInfo.revision());
            return glutenBuildInfo.put((Object)new StringBuilder(24).append("Component ").append(buildInfo.name()).append(" Revision Time").toString(), (Object)buildInfo.revisionTime());
        });
        glutenBuildInfo.put((Object)"Gluten Version", (Object)GlutenBuildInfo$.MODULE$.VERSION());
        glutenBuildInfo.put((Object)"GCC Version", (Object)GlutenBuildInfo$.MODULE$.GCC_VERSION());
        glutenBuildInfo.put((Object)"Java Version", (Object)GlutenBuildInfo$.MODULE$.JAVA_COMPILE_VERSION());
        glutenBuildInfo.put((Object)"Scala Version", (Object)GlutenBuildInfo$.MODULE$.SCALA_COMPILE_VERSION());
        glutenBuildInfo.put((Object)"Spark Version", (Object)GlutenBuildInfo$.MODULE$.SPARK_COMPILE_VERSION());
        glutenBuildInfo.put((Object)"Hadoop Version", (Object)GlutenBuildInfo$.MODULE$.HADOOP_COMPILE_VERSION());
        glutenBuildInfo.put((Object)"Gluten Branch", (Object)GlutenBuildInfo$.MODULE$.BRANCH());
        glutenBuildInfo.put((Object)"Gluten Revision", (Object)GlutenBuildInfo$.MODULE$.REVISION());
        glutenBuildInfo.put((Object)"Gluten Revision Time", (Object)GlutenBuildInfo$.MODULE$.REVISION_TIME());
        glutenBuildInfo.put((Object)"Gluten Build Time", (Object)GlutenBuildInfo$.MODULE$.BUILD_DATE());
        glutenBuildInfo.put((Object)"Gluten Repo URL", (Object)GlutenBuildInfo$.MODULE$.REPO_URL());
        String loggingInfo = ((TraversableOnce)glutenBuildInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = new StringBuilder(2).append(name).append(": ").append(value).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("Gluten build info:\n==============================================================\n", "\n", "\n==============================================================");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> loggingInfo);
        GlutenBuildInfoEvent event = new GlutenBuildInfoEvent(glutenBuildInfo.toMap(Predef$.MODULE$.$conforms()));
        GlutenEventUtils$.MODULE$.post(sc, (GlutenEvent)event);
    }

    private void setPredefinedConfigs(SparkConf conf) {
        BoxedUnit boxedUnit;
        SparkConf sparkConf;
        BoxedUnit boxedUnit2;
        String extensions = conf.contains(StaticSQLConf$.MODULE$.SPARK_SESSION_EXTENSIONS().key()) ? new StringBuilder(1).append(conf.get(StaticSQLConf$.MODULE$.SPARK_SESSION_EXTENSIONS().key())).append(",").append(GlutenSessionExtensions$.MODULE$.GLUTEN_SESSION_EXTENSION_NAME()).toString() : String.valueOf(GlutenSessionExtensions$.MODULE$.GLUTEN_SESSION_EXTENSION_NAME());
        conf.set(StaticSQLConf$.MODULE$.SPARK_SESSION_EXTENSIONS().key(), extensions);
        boolean enableGlutenCostEvaluator = conf.getBoolean(GlutenConfig$.MODULE$.GLUTEN_COST_EVALUATOR_ENABLED(), GlutenConfig$.MODULE$.GLUTEN_COST_EVALUATOR_ENABLED_DEFAULT_VALUE());
        if (enableGlutenCostEvaluator) {
            String costEvaluator = "org.apache.spark.sql.execution.adaptive.GlutenCostEvaluator";
            boxedUnit2 = conf.set(SQLConf$.MODULE$.ADAPTIVE_CUSTOM_COST_EVALUATOR_CLASS().key(), costEvaluator);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String minOffHeapSize = "1MB";
        if (!(conf.getBoolean(GlutenConfig$.MODULE$.GLUTEN_DYNAMIC_OFFHEAP_SIZING_ENABLED(), false) || conf.getBoolean(GlutenConfig$.MODULE$.SPARK_OFFHEAP_ENABLED(), false) && conf.getSizeAsBytes(GlutenConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY(), 0L) >= JavaUtils.byteStringAsBytes((String)minOffHeapSize))) {
            throw new GlutenException(new StringBuilder(50).append("Must set '").append(GlutenConfig$.MODULE$.SPARK_OFFHEAP_ENABLED()).append("' to true ").append("and set '").append(GlutenConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY()).append("' to be greater than ").append(minOffHeapSize).toString());
        }
        conf.set(GlutenConfig$.MODULE$.GLUTEN_DEFAULT_SESSION_TIMEZONE_KEY(), SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().defaultValueString());
        int taskSlots = SparkResourceUtil$.MODULE$.getTaskSlots(conf);
        conf.set(GlutenConfig$.MODULE$.GLUTEN_NUM_TASK_SLOTS_PER_EXECUTOR_KEY(), Integer.toString(taskSlots));
        long onHeapSize = conf.getSizeAsBytes(GlutenConfig$.MODULE$.SPARK_ONHEAP_SIZE_KEY(), 0x40000000L);
        long offHeapSize = conf.getBoolean(GlutenConfig$.MODULE$.GLUTEN_DYNAMIC_OFFHEAP_SIZING_ENABLED(), false) ? (long)((double)(onHeapSize - 314572800L) * conf.getDouble(GlutenConfig$.MODULE$.GLUTEN_DYNAMIC_OFFHEAP_SIZING_MEMORY_FRACTION(), 0.6)) : conf.getSizeAsBytes(GlutenConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY(), 0L);
        conf.set(GlutenConfig$.MODULE$.GLUTEN_OFFHEAP_SIZE_IN_BYTES_KEY(), Long.toString(offHeapSize));
        conf.set(GlutenConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY(), Long.toString(offHeapSize));
        long offHeapPerTask = offHeapSize / (long)taskSlots;
        conf.set(GlutenConfig$.MODULE$.GLUTEN_TASK_OFFHEAP_SIZE_IN_BYTES_KEY(), Long.toString(offHeapPerTask));
        if (conf.getBoolean(GlutenConfig$.MODULE$.GLUTEN_DYNAMIC_OFFHEAP_SIZING_ENABLED(), false)) {
            conf.set(GlutenConfig$.MODULE$.SPARK_OFFHEAP_ENABLED(), "true");
            sparkConf = conf.set(GlutenConfig$.MODULE$.GLUTEN_CONSERVATIVE_TASK_OFFHEAP_SIZE_IN_BYTES_KEY(), Long.toString(offHeapPerTask));
        } else {
            conf.set(GlutenConfig$.MODULE$.GLUTEN_DYNAMIC_OFFHEAP_SIZING_ENABLED(), "false");
            double fraction = 1.0 - conf.getDouble("spark.memory.storageFraction", 0.5);
            long conservativeOffHeapPerTask = (long)((double)offHeapSize * fraction) / (long)taskSlots;
            sparkConf = conf.set(GlutenConfig$.MODULE$.GLUTEN_CONSERVATIVE_TASK_OFFHEAP_SIZE_IN_BYTES_KEY(), Long.toString(conservativeOffHeapPerTask));
        }
        if (!conf.getBoolean(GlutenConfig$.MODULE$.VANILLA_VECTORIZED_READERS_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)GlutenConfig$.MODULE$.VANILLA_VECTORIZED_READERS_ENABLED().defaultValue().get()))) {
            conf.set(SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key(), "false");
            conf.set(SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key(), "false");
            boxedUnit = conf.set(SQLConf$.MODULE$.CACHE_VECTORIZED_READER_ENABLED().key(), "false");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (conf.getBoolean(GlutenConfig$.MODULE$.COLUMNAR_VELOX_CACHE_ENABLED().key(), false) && !conf.getBoolean(GlutenConfig$.MODULE$.COLUMNAR_VELOX_FILE_HANDLE_CACHE_ENABLED().key(), false)) {
            throw new IllegalArgumentException(new StringBuilder(33).append(GlutenConfig$.MODULE$.COLUMNAR_VELOX_CACHE_ENABLED().key()).append(" and ").append(GlutenConfig$.MODULE$.COLUMNAR_VELOX_FILE_HANDLE_CACHE_ENABLED().key()).append(" should be enabled together.").toString());
        }
        if (conf.getBoolean(GlutenConfig$.MODULE$.COLUMNAR_VELOX_CACHE_ENABLED().key(), false) && conf.getSizeAsBytes(GlutenConfig$.MODULE$.LOAD_QUANTUM().key(), GlutenConfig$.MODULE$.LOAD_QUANTUM().defaultValueString()) > 0x800000L) {
            throw new IllegalArgumentException(new StringBuilder(120).append("Velox currently only support up to 8MB load quantum size ").append("on SSD cache enabled by ").append(GlutenConfig$.MODULE$.COLUMNAR_VELOX_CACHE_ENABLED().key()).append(", ").append("User can set ").append(GlutenConfig$.MODULE$.LOAD_QUANTUM().key()).append(" <= 8MB skip this error.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$registerMetrics$1(GlutenDriverPlugin $this, SparkContext sc) {
        GlutenEventUtils$.MODULE$.attachUI(sc);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Gluten SQL Tab has attached.");
    }

    public GlutenDriverPlugin() {
        Logging.$init$((Logging)this);
        this._sc = None$.MODULE$;
    }
}

