/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dimension.BooleanDimEnc;
import org.apache.kylin.dimension.DateDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.FixedLenDimEnc;
import org.apache.kylin.dimension.FixedLenHexDimEnc;
import org.apache.kylin.dimension.IntDimEnc;
import org.apache.kylin.dimension.IntegerDimEnc;
import org.apache.kylin.dimension.TimeDimEnc;
import org.apache.kylin.guava30.shaded.common.collect.Iterables;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DimensionEncodingFactory {
    private static final Logger logger = LoggerFactory.getLogger(DimensionEncodingFactory.class);
    private static Map<Pair<String, Integer>, DimensionEncodingFactory> factoryMap;

    protected int getCurrentVersion() {
        return 1;
    }

    public static DimensionEncoding create(String encodingName, String[] args, int version) {
        DimensionEncodingFactory factory;
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        if ((factory = factoryMap.get(Pair.newPair((Object)encodingName, (Object)version))) == null) {
            throw new IllegalArgumentException("Unknown dimension encoding name " + encodingName + " (note '" + "dict" + "' is not handled by factory)");
        }
        return factory.createDimensionEncoding(encodingName, args);
    }

    public static Map<String, Integer> getValidEncodings() {
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        TreeMap result = Maps.newTreeMap();
        for (Pair<String, Integer> p : factoryMap.keySet()) {
            if (result.containsKey(p.getFirst()) && (Integer)result.get(p.getFirst()) > (Integer)p.getSecond()) continue;
            result.put(p.getFirst(), p.getSecond());
        }
        result.put("dict", 1);
        return result;
    }

    public static boolean isValidEncoding(String encodingName) {
        if (factoryMap == null) {
            DimensionEncodingFactory.initFactoryMap();
        }
        return "dict".equals(encodingName) || Iterables.any(factoryMap.keySet(), input -> input != null && ((String)input.getFirst()).equals(encodingName));
    }

    private static synchronized void initFactoryMap() {
        if (factoryMap == null) {
            String[] clsNames;
            ConcurrentMap map = Maps.newConcurrentMap();
            DimensionEncodingFactory value = new FixedLenDimEnc.Factory();
            map.put(Pair.newPair((Object)"fixed_length", (Object)value.getCurrentVersion()), value);
            value = new IntDimEnc.Factory();
            map.put(Pair.newPair((Object)"int", (Object)value.getCurrentVersion()), value);
            value = new IntegerDimEnc.Factory();
            map.put(Pair.newPair((Object)"integer", (Object)value.getCurrentVersion()), value);
            value = new FixedLenHexDimEnc.Factory();
            map.put(Pair.newPair((Object)"fixed_length_hex", (Object)value.getCurrentVersion()), value);
            value = new DateDimEnc.Factory();
            map.put(Pair.newPair((Object)"date", (Object)value.getCurrentVersion()), value);
            value = new TimeDimEnc.Factory();
            map.put(Pair.newPair((Object)"time", (Object)value.getCurrentVersion()), value);
            value = new BooleanDimEnc.Factory();
            map.put(Pair.newPair((Object)"boolean", (Object)value.getCurrentVersion()), value);
            for (String clsName : clsNames = KylinConfig.getInstanceFromEnv().getCubeDimensionCustomEncodingFactories()) {
                try {
                    DimensionEncodingFactory factory = (DimensionEncodingFactory)ClassUtil.newInstance((String)clsName);
                    map.put(Pair.newPair((Object)factory.getSupportedEncodingName(), (Object)factory.getCurrentVersion()), factory);
                }
                catch (Exception ex) {
                    logger.error("Failed to init dimension encoding factory " + clsName, (Throwable)ex);
                }
            }
            factoryMap = map;
        }
    }

    public abstract String getSupportedEncodingName();

    public abstract DimensionEncoding createDimensionEncoding(String var1, String[] var2);
}

