/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.metadata.acl.SensitiveDataMask;

public class SensitiveDataMaskInfo {
    private Map<String, Map<String, SensitiveDataMask>> infos = new HashMap<String, Map<String, SensitiveDataMask>>();

    public boolean hasMask() {
        return !this.infos.isEmpty();
    }

    public void addMasks(String dbName, String tableName, Collection<SensitiveDataMask> masks) {
        for (SensitiveDataMask mask : masks) {
            this.infos.putIfAbsent(dbName + "." + tableName, new HashMap());
            SensitiveDataMask originalMask = this.infos.get(dbName + "." + tableName).get(mask.column);
            if (originalMask != null) {
                this.infos.get(dbName + "." + tableName).put(mask.column, new SensitiveDataMask(mask.column, mask.getType().merge(originalMask.getType())));
                continue;
            }
            this.infos.get(dbName + "." + tableName).put(mask.column, mask);
        }
    }

    public SensitiveDataMask getMask(String dbName, String tableName, String columnName) {
        if (this.infos.containsKey(dbName + "." + tableName)) {
            return this.infos.get(dbName + "." + tableName).get(columnName);
        }
        return null;
    }
}

