/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.job;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.metadata.job.JobTokenItem;
import org.apache.kylin.metadata.job.JobTokenMapper;
import org.apache.kylin.metadata.job.JobTokenTable;
import org.apache.kylin.util.MetadataStoreUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.insert.InsertDSL;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.util.DigestUtils;

public class JobTokenManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobTokenManager.class);
    public static final String JOB_TOKEN_TABLE = "_job_token";
    private final JobTokenTable table;
    @VisibleForTesting
    private final SqlSessionTemplate sqlSessionTemplate;
    private final DataSourceTransactionManager transactionManager;

    public static JobTokenManager getInstance(KylinConfig config) {
        return (JobTokenManager)config.getManager(JobTokenManager.class);
    }

    static JobTokenManager newInstance(KylinConfig config) {
        try {
            String cls = JobTokenManager.class.getName();
            Class clz = ClassUtil.forName((String)cls, JobTokenManager.class);
            return (JobTokenManager)clz.getConstructor(KylinConfig.class).newInstance(config);
        }
        catch (Exception e) {
            throw new KylinRuntimeException("Failed to init JobTokenManager from " + config, (Throwable)e);
        }
    }

    public JobTokenManager(KylinConfig config) throws Exception {
        this(config, JobTokenManager.getJobTokenTable(config));
    }

    private JobTokenManager(KylinConfig config, String tableName) throws Exception {
        StorageURL url = KylinConfig.getInstanceFromEnv().isUTEnv() ? config.getQueryHistoryUrl() : config.getJDBCDistributedLockURL();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.table = new JobTokenTable(tableName);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
        this.sqlSessionTemplate = new SqlSessionTemplate(MetadataStoreUtil.getSqlSessionFactory(dataSource, this.table.tableNameAtRuntime(), MetadataStoreUtil.TableType.JOB_TOKEN));
    }

    public String encrypt(String token) {
        return DigestUtils.md5DigestAsHex((byte[])token.getBytes(Charset.defaultCharset()));
    }

    private static String getJobTokenTable(KylinConfig config) {
        StorageURL url = config.getQueryHistoryUrl();
        String tablePrefix = config.isUTEnv() ? "test_job_token" : url.getIdentifier();
        return tablePrefix + JOB_TOKEN_TABLE;
    }

    public void save(JobTokenItem item) {
        this.delete(item.getJobId());
        JobTokenMapper mapper = (JobTokenMapper)this.sqlSessionTemplate.getMapper(JobTokenMapper.class);
        InsertStatementProvider<JobTokenItem> insertStatement = this.getInsertProvider(item);
        int rows = mapper.insert(insertStatement);
        if (rows <= 0) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Failed to insert token (jobId: %s, token: %s", item.getJobId(), item.getToken()));
        }
        log.debug("Insert one token({}/{}) into database.", (Object)item.getJobId(), (Object)item.getToken());
    }

    public JobTokenItem query(String jobId) {
        JobTokenMapper mapper = (JobTokenMapper)this.sqlSessionTemplate.getMapper(JobTokenMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByIdStatementProvider(jobId);
        return mapper.selectOne(statementProvider);
    }

    public void delete(String jobId) {
        long startTime = System.currentTimeMillis();
        try {
            JobTokenMapper mapper = (JobTokenMapper)this.sqlSessionTemplate.getMapper(JobTokenMapper.class);
            DeleteModel deleteStatement = (DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.jobId, (VisitableCondition)SqlBuilder.isEqualTo((Object)jobId), new AndOrCriteriaGroup[0])).build();
            int rows = mapper.delete(deleteStatement.render(RenderingStrategies.MYBATIS3));
            if (rows > 0) {
                log.debug("Delete one token of jobId: {} takes {} ms.", (Object)jobId, (Object)(System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception e) {
            log.error("Fail to delete token of jobId:{}.", (Object)jobId, (Object)e);
        }
    }

    public InsertStatementProvider<JobTokenItem> getInsertProvider(JobTokenItem item) {
        InsertDSL provider = SqlBuilder.insert((Object)item).into((SqlTable)this.table);
        return provider.map(this.table.jobId).toProperty("jobId").map(this.table.token).toProperty("token").map(this.table.createTime).toProperty("createTime").build().render(RenderingStrategies.MYBATIS3);
    }

    public SelectStatementProvider getSelectByIdStatementProvider(String jobId) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])BasicColumn.columnList((BasicColumn[])new BasicColumn[]{this.table.jobId, this.table.token, this.table.createTime})).from((SqlTable)this.table).where(this.table.jobId, (VisitableCondition)SqlBuilder.isEqualTo((Object)jobId), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    @Generated
    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

