/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class SegmentRange<T extends Comparable<?>>
implements Comparable<SegmentRange<T>>,
Serializable {
    protected T start;
    protected T end;

    public abstract boolean isInfinite();

    public abstract boolean contains(SegmentRange<T> var1);

    public abstract boolean entireOverlaps(SegmentRange<T> var1);

    public abstract boolean overlaps(SegmentRange<T> var1);

    public abstract boolean connects(SegmentRange<T> var1);

    public abstract boolean apartBefore(SegmentRange<T> var1);

    public abstract boolean startStartMatch(SegmentRange<T> var1);

    public abstract boolean endEndMatch(SegmentRange<T> var1);

    public abstract boolean startEndMatch(SegmentRange<T> var1);

    public abstract SegmentRange<T> getStartDeviation(SegmentRange<T> var1);

    public abstract SegmentRange<T> getEndDeviation(SegmentRange<T> var1);

    public abstract SegmentRange<T> getOverlapRange(SegmentRange<T> var1);

    public abstract SegmentRange<T> coverWith(SegmentRange<T> var1);

    public abstract SegmentRange<T> gapTill(SegmentRange<T> var1);

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public String getStartFormatted() {
        return this.start.toString();
    }

    public String getEndFormatted() {
        return this.end.toString();
    }

    public String proposeSegmentName() {
        return null;
    }

    public static Long dateToLong(String dateString) {
        return DateFormat.stringToMillis((String)dateString);
    }

    public static void main(String[] args) {
    }

    public static class KafkaOffsetPartitionedSegmentRange
    extends BasicSegmentRange {
        @JsonProperty(value="source_partition_offset_start")
        private Map<Integer, Long> sourcePartitionOffsetStart;
        @JsonProperty(value="source_partition_offset_end")
        private Map<Integer, Long> sourcePartitionOffsetEnd;

        public static KafkaOffsetPartitionedSegmentRange createInfinite() {
            return new KafkaOffsetPartitionedSegmentRange(0L, Long.MAX_VALUE, null, null);
        }

        public KafkaOffsetPartitionedSegmentRange() {
        }

        public KafkaOffsetPartitionedSegmentRange(Long startOffset, Long endOffset) {
            super(startOffset, endOffset);
        }

        public KafkaOffsetPartitionedSegmentRange(Long startOffset, Long endOffset, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd) {
            super(startOffset, endOffset);
            this.sourcePartitionOffsetStart = sourcePartitionOffsetStart == null ? Maps.newHashMap() : sourcePartitionOffsetStart;
            this.sourcePartitionOffsetEnd = sourcePartitionOffsetEnd == null ? Maps.newHashMap() : sourcePartitionOffsetEnd;
        }

        private KafkaOffsetPartitionedSegmentRange convertToKafkaOffset(SegmentRange<Long> o) {
            Preconditions.checkState((boolean)(o instanceof KafkaOffsetPartitionedSegmentRange));
            return (KafkaOffsetPartitionedSegmentRange)o;
        }

        @Override
        public boolean contains(SegmentRange<Long> o) {
            KafkaOffsetPartitionedSegmentRange other = this.convertToKafkaOffset(o);
            return this.comparePartitionOffset(this.sourcePartitionOffsetStart, other.sourcePartitionOffsetStart) <= 0 && this.comparePartitionOffset(other.sourcePartitionOffsetEnd, this.sourcePartitionOffsetEnd) <= 0;
        }

        @Override
        public SegmentRange<Long> coverWith(SegmentRange<Long> o) {
            KafkaOffsetPartitionedSegmentRange other = this.convertToKafkaOffset(o);
            long start = Math.min((Long)this.start, (Long)other.start);
            long end = Math.max((Long)this.end, (Long)other.end);
            return new KafkaOffsetPartitionedSegmentRange(start, end, this.getSourcePartitionOffsetStart(), other.getSourcePartitionOffsetEnd());
        }

        @Override
        public SegmentRange<Long> gapTill(SegmentRange<Long> o) {
            KafkaOffsetPartitionedSegmentRange other = this.convertToKafkaOffset(o);
            return new KafkaOffsetPartitionedSegmentRange((Long)this.end, (Long)other.start, this.getSourcePartitionOffsetEnd(), other.getSourcePartitionOffsetStart());
        }

        @Override
        public SegmentRange<Long> getStartDeviation(SegmentRange<Long> o) {
            KafkaOffsetPartitionedSegmentRange other = this.convertToKafkaOffset(o);
            return new KafkaOffsetPartitionedSegmentRange((Long)this.start, (Long)other.start, this.getSourcePartitionOffsetStart(), other.getSourcePartitionOffsetStart());
        }

        @Override
        public SegmentRange<Long> getEndDeviation(SegmentRange<Long> o) {
            KafkaOffsetPartitionedSegmentRange other = this.convertToKafkaOffset(o);
            return new KafkaOffsetPartitionedSegmentRange((Long)this.end, (Long)other.end, this.getSourcePartitionOffsetEnd(), other.getSourcePartitionOffsetEnd());
        }

        @Override
        public boolean overlaps(SegmentRange<Long> o) {
            super.checkSameType(o);
            KafkaOffsetPartitionedSegmentRange t = this.convertToKafkaOffset(o);
            if (t.sourcePartitionOffsetStart != null && t.sourcePartitionOffsetEnd != null) {
                return this.comparePartitionOffset(this.sourcePartitionOffsetStart, t.sourcePartitionOffsetEnd) < 0 && this.comparePartitionOffset(t.sourcePartitionOffsetStart, this.sourcePartitionOffsetEnd) < 0;
            }
            return (Long)this.start < (Long)t.end && (Long)t.start <= (Long)this.end;
        }

        @Override
        public SegmentRange<Long> getOverlapRange(SegmentRange<Long> o) {
            KafkaOffsetPartitionedSegmentRange other = this.convertToKafkaOffset(o);
            if (!this.overlaps(o)) {
                return null;
            }
            Long start = (Long)this.start < (Long)other.start ? (Long)other.start : (Long)this.start;
            Long end = (Long)this.end < (Long)other.end ? (Long)this.end : (Long)other.end;
            Map<Integer, Long> offsetStart = this.comparePartitionOffset(this.sourcePartitionOffsetStart, other.sourcePartitionOffsetStart) < 0 ? other.sourcePartitionOffsetStart : this.sourcePartitionOffsetStart;
            Map<Integer, Long> offsetEnd = this.comparePartitionOffset(this.sourcePartitionOffsetEnd, other.sourcePartitionOffsetEnd) < 0 ? other.sourcePartitionOffsetEnd : this.sourcePartitionOffsetEnd;
            return new KafkaOffsetPartitionedSegmentRange(start, end, offsetStart, offsetEnd);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KafkaOffsetPartitionedSegmentRange that = (KafkaOffsetPartitionedSegmentRange)o;
            return Objects.equals(this.sourcePartitionOffsetStart, that.sourcePartitionOffsetStart) && Objects.equals(this.sourcePartitionOffsetEnd, that.sourcePartitionOffsetEnd);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.sourcePartitionOffsetStart, this.sourcePartitionOffsetEnd);
        }

        @Override
        public int compareTo(SegmentRange o) {
            KafkaOffsetPartitionedSegmentRange target = (KafkaOffsetPartitionedSegmentRange)o;
            int result = this.comparePartitionOffset(this.sourcePartitionOffsetStart, target.sourcePartitionOffsetStart);
            if (result == 0) {
                result = this.comparePartitionOffset(this.sourcePartitionOffsetEnd, target.sourcePartitionOffsetEnd);
            }
            return result;
        }

        public int comparePartitionOffset(Map<Integer, Long> sourcePartitionOffset, Map<Integer, Long> targetPartitionOffset) {
            int result = 0;
            for (Map.Entry<Integer, Long> entry : sourcePartitionOffset.entrySet()) {
                result = entry.getValue().compareTo(targetPartitionOffset.get(entry.getKey()));
                if (result == 0) continue;
                return result;
            }
            return result;
        }

        public Map<Integer, Long> getSourcePartitionOffsetStart() {
            return this.sourcePartitionOffsetStart;
        }

        public Map<Integer, Long> getSourcePartitionOffsetEnd() {
            return this.sourcePartitionOffsetEnd;
        }

        @Override
        @JsonProperty(value="source_offset_start")
        public Long getStart() {
            return (Long)this.start;
        }

        @JsonProperty(value="source_offset_start")
        public void setStart(Long start) {
            this.start = start;
        }

        @Override
        @JsonProperty(value="source_offset_end")
        public Long getEnd() {
            return (Long)this.end;
        }

        @JsonProperty(value="source_offset_end")
        public void setEnd(Long end) {
            this.end = end;
        }
    }

    public static class TimePartitionedSegmentRange
    extends BasicSegmentRange {
        public TimePartitionedSegmentRange() {
        }

        public TimePartitionedSegmentRange(Long startMs, Long endMs) {
            super(startMs, endMs);
        }

        public TimePartitionedSegmentRange(String startDate, String endDate) {
            super(TimePartitionedSegmentRange.dateToLong(startDate), TimePartitionedSegmentRange.dateToLong(endDate));
        }

        public static TimePartitionedSegmentRange createInfinite() {
            return new TimePartitionedSegmentRange(0L, Long.MAX_VALUE);
        }

        private TimePartitionedSegmentRange convertToTimePartitioned(SegmentRange<Long> o) {
            Preconditions.checkState((boolean)(o instanceof TimePartitionedSegmentRange));
            return (TimePartitionedSegmentRange)o;
        }

        @Override
        public SegmentRange<Long> coverWith(SegmentRange<Long> o) {
            TimePartitionedSegmentRange other = this.convertToTimePartitioned(o);
            return new TimePartitionedSegmentRange((Long)this.start, (Long)other.end);
        }

        @Override
        public SegmentRange<Long> getStartDeviation(SegmentRange<Long> o) {
            TimePartitionedSegmentRange other = this.convertToTimePartitioned(o);
            return new TimePartitionedSegmentRange((Long)this.start, (Long)other.start);
        }

        @Override
        public SegmentRange<Long> getEndDeviation(SegmentRange<Long> o) {
            TimePartitionedSegmentRange other = this.convertToTimePartitioned(o);
            return new TimePartitionedSegmentRange((Long)this.end, (Long)other.end);
        }

        @Override
        public SegmentRange<Long> getOverlapRange(SegmentRange<Long> o) {
            TimePartitionedSegmentRange other = this.convertToTimePartitioned(o);
            if (!this.overlaps(o)) {
                return null;
            }
            Long start = (Long)this.start < (Long)other.start ? (Long)other.start : (Long)this.start;
            Long end = (Long)this.end < (Long)other.end ? (Long)this.end : (Long)other.end;
            return new TimePartitionedSegmentRange(start, end);
        }

        @Override
        public SegmentRange<Long> gapTill(SegmentRange<Long> o) {
            TimePartitionedSegmentRange other = this.convertToTimePartitioned(o);
            return new TimePartitionedSegmentRange((Long)this.end, (Long)other.start);
        }

        @Override
        @JsonProperty(value="date_range_start")
        public Long getStart() {
            return (Long)this.start;
        }

        @JsonProperty(value="date_range_start")
        public void setStart(Long start) {
            this.start = start;
        }

        @Override
        @JsonProperty(value="date_range_end")
        public Long getEnd() {
            return (Long)this.end;
        }

        @JsonProperty(value="date_range_end")
        public void setEnd(Long end) {
            this.end = end;
        }

        @Override
        public String getStartFormatted() {
            return DateFormat.formatToTimeStr((long)((Long)this.start));
        }

        @Override
        public String getEndFormatted() {
            return DateFormat.formatToTimeStr((long)((Long)this.end));
        }
    }

    public static abstract class BasicSegmentRange
    extends SegmentRange<Long> {
        BasicSegmentRange() {
        }

        BasicSegmentRange(Long s, Long e) {
            this.start = Long.valueOf(s == null || s <= 0L ? 0L : s);
            this.end = Long.valueOf(e == null || e == Long.MAX_VALUE ? Long.MAX_VALUE : e);
            Preconditions.checkState(((Long)this.start <= (Long)this.end ? 1 : 0) != 0);
        }

        private BasicSegmentRange convert(SegmentRange<Long> o) {
            Preconditions.checkState((boolean)(o instanceof BasicSegmentRange));
            return (BasicSegmentRange)o;
        }

        protected void checkSameType(SegmentRange<Long> o) {
            Preconditions.checkNotNull(o);
            Preconditions.checkState((this.getClass() == o.getClass() ? 1 : 0) != 0);
        }

        @Override
        public boolean isInfinite() {
            return (Long)this.start == 0L && (Long)this.end == Long.MAX_VALUE;
        }

        @Override
        public boolean contains(SegmentRange<Long> o) {
            this.checkSameType(o);
            BasicSegmentRange t = this.convert(o);
            return (Long)this.start <= (Long)t.start && (Long)t.end <= (Long)this.end;
        }

        @Override
        public boolean entireOverlaps(SegmentRange<Long> o) {
            this.checkSameType(o);
            return this.contains(o) && o.contains(this);
        }

        @Override
        public boolean overlaps(SegmentRange<Long> o) {
            this.checkSameType(o);
            BasicSegmentRange t = this.convert(o);
            return (Long)this.start < (Long)t.end && (Long)t.start < (Long)this.end;
        }

        @Override
        public boolean connects(SegmentRange<Long> o) {
            this.checkSameType(o);
            BasicSegmentRange t = this.convert(o);
            return ((Long)this.end).equals(t.start);
        }

        @Override
        public boolean apartBefore(SegmentRange<Long> o) {
            this.checkSameType(o);
            BasicSegmentRange t = this.convert(o);
            return (Long)this.end < (Long)t.start;
        }

        @Override
        public boolean startStartMatch(SegmentRange<Long> o) {
            this.checkSameType(o);
            BasicSegmentRange t = this.convert(o);
            return ((Long)this.start).equals(t.start);
        }

        @Override
        public boolean endEndMatch(SegmentRange<Long> o) {
            this.checkSameType(o);
            BasicSegmentRange t = this.convert(o);
            return ((Long)this.end).equals(t.end);
        }

        @Override
        public boolean startEndMatch(SegmentRange<Long> o) {
            this.checkSameType(o);
            BasicSegmentRange t = this.convert(o);
            return ((Long)this.start).equals(t.end);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.start + "," + this.end + ")";
        }

        public int hashCode() {
            return org.apache.kylin.guava30.shaded.common.base.Objects.hashCode((Object[])new Object[]{this.start, this.end});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicSegmentRange that = (BasicSegmentRange)o;
            return ((Long)this.start).equals(that.start) && ((Long)this.end).equals(that.end);
        }

        @Override
        public int compareTo(SegmentRange<Long> o) {
            BasicSegmentRange t = this.convert(o);
            int comp = Long.compare((Long)this.start, (Long)t.start);
            if (comp != 0) {
                return comp;
            }
            return Long.compare((Long)this.end, (Long)t.end);
        }
    }
}

