/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.sourceusage.mail;

import freemarker.template.Template;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.mail.MailNotificationCreator;
import org.apache.kylin.common.mail.MailNotificationType;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SizeConvertUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceUsageMailUtil {
    private static final Logger logger = LoggerFactory.getLogger(SourceUsageMailUtil.class);

    private SourceUsageMailUtil() {
        throw new IllegalStateException("Utility class");
    }

    private static Map<String, Object> createMailContent(Long licenseVolume, Long currentCapacity) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String readableCurrentCapacity = SizeConvertUtil.getReadableFileSize((long)currentCapacity);
        String readableLicenseVolume = SizeConvertUtil.getReadableFileSize((long)licenseVolume);
        double overCapacityThreshold = kylinConfig.getOverCapacityThreshold() * 100.0;
        HashMap data = Maps.newHashMap();
        data.put("volume_used", readableCurrentCapacity);
        data.put("volume_total", readableLicenseVolume);
        data.put("capacity_threshold", BigDecimal.valueOf(overCapacityThreshold).toString());
        return data;
    }

    public static Pair<String, String> createMail(MailNotificationType notificationType, Long licenseVolume, Long currentCapacity) {
        String mailTitle = MailNotificationCreator.createTitle((MailNotificationType)notificationType);
        Map<String, Object> data = SourceUsageMailUtil.createMailContent(licenseVolume, currentCapacity);
        String mailContent = null;
        try {
            Template mailTemplate = MailNotificationCreator.MailTemplate.getTemplate((String)notificationType.getCorrespondingTemplateName());
            mailContent = MailNotificationCreator.createContent((Template)mailTemplate, data);
        }
        catch (Exception e) {
            logger.error("create mail [{}] failed!", (Object)notificationType.getDisplayName(), (Object)e);
        }
        return Pair.newPair((Object)mailTitle, (Object)mailContent);
    }
}

